/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.map.impl;

import java.util.HashMap;
import java.util.Map;
import org.drools.persistence.info.SessionInfo;
import org.drools.persistence.info.WorkItemInfo;
import org.drools.persistence.map.KnowledgeSessionStorage;
import org.drools.persistence.map.KnowledgeSessionStorageEnvironmentBuilder;
import org.drools.persistence.map.impl.MapPersistenceTest;
import org.junit.Before;
import org.kie.api.KieBase;
import org.kie.api.runtime.Environment;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class MapBasedPersistenceTest
extends MapPersistenceTest {
    private SimpleKnowledgeSessionStorage storage;

    @Before
    public void createStorage() {
        this.storage = new SimpleKnowledgeSessionStorage();
    }

    @Override
    protected StatefulKnowledgeSession createSession(KnowledgeBase kbase) {
        KnowledgeSessionStorageEnvironmentBuilder envBuilder = new KnowledgeSessionStorageEnvironmentBuilder((KnowledgeSessionStorage)this.storage);
        Environment env = KnowledgeBaseFactory.newEnvironment();
        env.set("org.kie.transaction.TransactionManager", (Object)envBuilder.getTransactionManager());
        env.set("org.kie.api.persistence.PersistenceContextManager", (Object)envBuilder.getPersistenceContextManager());
        return JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)env);
    }

    @Override
    protected StatefulKnowledgeSession disposeAndReloadSession(StatefulKnowledgeSession ksession, KnowledgeBase kbase) {
        int sessionId = ksession.getId();
        ksession.dispose();
        KnowledgeSessionStorageEnvironmentBuilder envBuilder = new KnowledgeSessionStorageEnvironmentBuilder((KnowledgeSessionStorage)this.storage);
        Environment env = KnowledgeBaseFactory.newEnvironment();
        env.set("org.kie.transaction.TransactionManager", (Object)envBuilder.getTransactionManager());
        env.set("org.kie.api.persistence.PersistenceContextManager", (Object)envBuilder.getPersistenceContextManager());
        return JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KieBase)kbase, null, (Environment)env);
    }

    @Override
    protected long getSavedSessionsCount() {
        return this.storage.ksessions.size();
    }

    private static class SimpleKnowledgeSessionStorage
    implements KnowledgeSessionStorage {
        public Map<Integer, SessionInfo> ksessions = new HashMap<Integer, SessionInfo>();
        public Map<Long, WorkItemInfo> workItems = new HashMap<Long, WorkItemInfo>();

        private SimpleKnowledgeSessionStorage() {
        }

        public SessionInfo findSessionInfo(Integer id) {
            return this.ksessions.get(id);
        }

        public void saveOrUpdate(SessionInfo storedObject) {
            this.ksessions.put(storedObject.getId(), storedObject);
        }

        public void saveOrUpdate(WorkItemInfo workItemInfo) {
            this.workItems.put(workItemInfo.getId(), workItemInfo);
        }

        public Long getNextWorkItemId() {
            return new Long(this.workItems.size() + 1);
        }

        public WorkItemInfo findWorkItemInfo(Long id) {
            return this.workItems.get(id);
        }

        public void remove(WorkItemInfo workItemInfo) {
            this.workItems.remove(workItemInfo.getId());
        }

        public Integer getNextStatefulKnowledgeSessionId() {
            return this.ksessions.size() + 1;
        }

        public void lock(SessionInfo sessionInfo) {
            throw new UnsupportedOperationException("Map based persistence does not support locking.");
        }

        public void lock(WorkItemInfo workItemInfo) {
            throw new UnsupportedOperationException("Map based persistence does not support locking.");
        }
    }
}

