/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.session;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Random;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.drools.core.common.DefaultFactHandle;
import org.drools.persistence.PersistenceContextManager;
import org.drools.persistence.util.PersistenceUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.DefaultAgendaEventListener;
import org.kie.api.event.rule.DefaultWorkingMemoryEventListener;
import org.kie.api.event.rule.WorkingMemoryEventListener;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;

@RunWith(value=Parameterized.class)
public class ReloadSessionTest {
    private HashMap<String, Object> context;
    private EntityManagerFactory emf;
    private boolean locking;
    private static String simpleRule = "package org.kie.test\nglobal java.util.List list\nrule rule1\nwhen\n  Integer(intValue > 0)\nthen\n  list.add( 1 );\nend\n\n";

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> persistence() {
        Object[][] locking = new Object[][]{{PersistenceUtil.OPTIMISTIC_LOCKING}, {PersistenceUtil.PESSIMISTIC_LOCKING}};
        return Arrays.asList(locking);
    }

    public ReloadSessionTest(String locking) {
        this.locking = PersistenceUtil.PESSIMISTIC_LOCKING.equals(locking);
    }

    @Before
    public void setup() {
        this.context = PersistenceUtil.setupWithPoolingDataSource("org.drools.persistence.jpa");
        this.emf = (EntityManagerFactory)this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
    }

    @After
    public void cleanUp() {
        PersistenceUtil.cleanUp(this.context);
    }

    private Environment createEnvironment() {
        Environment env = PersistenceUtil.createEnvironment(this.context);
        if (this.locking) {
            env.set("org.kie.api.persistence.pessimistic", (Object)true);
        }
        return env;
    }

    private KnowledgeBase initializeKnowledgeBase(String rule) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    @Test
    public void reloadKnowledgeSessionTest() {
        Environment env = this.createEnvironment();
        KnowledgeBase kbase = this.initializeKnowledgeBase(simpleRule);
        StatefulKnowledgeSession commandKSession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)env);
        Assert.assertTrue((String)"There should be NO facts present in a new (empty) knowledge session.", (boolean)commandKSession.getFactHandles().isEmpty());
        Integer integerFact = new Random().nextInt(0x7FFFFFFE) + 1;
        commandKSession.insert((Object)integerFact);
        Collection factHandles = commandKSession.getFactHandles();
        Assert.assertTrue((String)"At least one fact should have been inserted by the ksession.insert() method above.", (!factHandles.isEmpty() ? 1 : 0) != 0);
        FactHandle origFactHandle = (FactHandle)factHandles.iterator().next();
        Assert.assertTrue((String)"The stored fact should contain the same number as the value inserted (but does not).", (Integer.parseInt(((DefaultFactHandle)origFactHandle).getObject().toString()) == integerFact ? 1 : 0) != 0);
        int sessionInfoId = commandKSession.getId();
        PersistenceContextManager pcm = (PersistenceContextManager)commandKSession.getEnvironment().get("org.kie.api.persistence.PersistenceContextManager");
        commandKSession.dispose();
        pcm.dispose();
        this.emf.close();
        this.emf = Persistence.createEntityManagerFactory((String)"org.drools.persistence.jpa");
        this.context.put("org.kie.api.persistence.jpa.EntityManagerFactory", this.emf);
        env = this.createEnvironment();
        StatefulKnowledgeSession newCommandKSession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionInfoId, (KieBase)kbase, null, (Environment)env);
        factHandles = newCommandKSession.getFactHandles();
        Assert.assertTrue((String)"At least one fact should have been persisted by the ksession.insert above.", (!factHandles.isEmpty() && factHandles.size() == 1 ? 1 : 0) != 0);
        FactHandle retrievedFactHandle = (FactHandle)factHandles.iterator().next();
        Assert.assertTrue((String)"If the retrieved and original FactHandle object are the same, then the knowledge session has NOT been reloaded!", (origFactHandle != retrievedFactHandle ? 1 : 0) != 0);
        Assert.assertTrue((String)"The retrieved fact should contain the same info as the original (but does not).", (Integer.parseInt(((DefaultFactHandle)retrievedFactHandle).getObject().toString()) == integerFact ? 1 : 0) != 0);
        ArrayList list = new ArrayList();
        newCommandKSession.setGlobal("list", list);
        newCommandKSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    @Ignore
    public void testListenersAfterSessionReload() {
        Environment env = this.createEnvironment();
        KnowledgeBase kbase = this.initializeKnowledgeBase(simpleRule);
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)env);
        ksession.addEventListener((AgendaEventListener)new DefaultAgendaEventListener());
        ksession.addEventListener((WorkingMemoryEventListener)new DefaultWorkingMemoryEventListener());
        Assert.assertEquals((long)1L, (long)ksession.getWorkingMemoryEventListeners().size());
        Assert.assertEquals((long)1L, (long)ksession.getAgendaEventListeners().size());
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)ksession.getId(), (KieBase)kbase, null, (Environment)env);
        Assert.assertEquals((long)1L, (long)ksession.getWorkingMemoryEventListeners().size());
        Assert.assertEquals((long)1L, (long)ksession.getAgendaEventListeners().size());
    }
}

