/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.session;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.drools.core.io.impl.ClassPathResource;
import org.drools.core.runtime.rule.impl.InternalAgenda;
import org.drools.persistence.util.PersistenceUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.command.Context;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;

@RunWith(value=Parameterized.class)
public class RuleFlowGroupRollbackTest {
    private HashMap<String, Object> context;
    private boolean locking;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> persistence() {
        Object[][] locking = new Object[][]{{PersistenceUtil.OPTIMISTIC_LOCKING}, {PersistenceUtil.PESSIMISTIC_LOCKING}};
        return Arrays.asList(locking);
    }

    public RuleFlowGroupRollbackTest(String locking) {
        this.locking = PersistenceUtil.PESSIMISTIC_LOCKING.equals(locking);
    }

    @Before
    public void setUp() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource("org.drools.persistence.jpa");
    }

    @After
    public void tearDown() {
        PersistenceUtil.cleanUp(this.context);
    }

    @Test
    public void testRuleFlowGroupRollback() throws Exception {
        CommandBasedStatefulKnowledgeSession ksession = this.createSession();
        ArrayList<String> list = new ArrayList<String>();
        list.add("Test");
        ksession.insert(list);
        ksession.execute((Command)new ActivateRuleFlowCommand("ruleflow-group"));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        try {
            ksession.execute((Command)new ExceptionCommand());
            Assert.fail((String)"Process must throw an exception");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ksession.insert(list);
        ksession.execute((Command)new ActivateRuleFlowCommand("ruleflow-group"));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    private CommandBasedStatefulKnowledgeSession createSession() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ClassPathResource("ruleflowgroup_rollback.drl"), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        Environment env = PersistenceUtil.createEnvironment(this.context);
        if (this.locking) {
            env.set("org.kie.api.persistence.pessimistic", (Object)true);
        }
        return (CommandBasedStatefulKnowledgeSession)JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)env);
    }

    public class ExceptionCommand
    implements GenericCommand<Object> {
        public Void execute(Context context) {
            throw new RuntimeException();
        }
    }

    public class ActivateRuleFlowCommand
    implements GenericCommand<Object> {
        private String ruleFlowGroupName;

        public ActivateRuleFlowCommand(String ruleFlowGroupName) {
            this.ruleFlowGroupName = ruleFlowGroupName;
        }

        public Void execute(Context context) {
            KieSession ksession = ((KnowledgeCommandContext)context).getKieSession();
            ((InternalAgenda)ksession.getAgenda()).activateRuleFlowGroup(this.ruleFlowGroupName);
            return null;
        }
    }
}

