/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.session;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.drools.core.io.impl.ClassPathResource;
import org.drools.core.runtime.rule.impl.AgendaImpl;
import org.drools.core.runtime.rule.impl.InternalAgenda;
import org.drools.core.spi.AgendaGroup;
import org.drools.persistence.util.PersistenceUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.command.Context;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;

@RunWith(value=Parameterized.class)
public class AgendaRuleFlowGroupsTest {
    private HashMap<String, Object> context;
    private boolean locking = true;

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] locking = new Object[][]{{false}, {true}};
        return Arrays.asList(locking);
    }

    public AgendaRuleFlowGroupsTest(boolean locking) {
    }

    @Before
    public void setUp() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource("org.drools.persistence.jpa");
    }

    @After
    public void tearDown() {
        PersistenceUtil.cleanUp(this.context);
    }

    @Test
    public void testRuleFlowGroupOnly() throws Exception {
        CommandBasedStatefulKnowledgeSession ksession = this.createSession(-1, "ruleflow-groups.drl");
        AgendaGroup[] groups = ((AgendaImpl)this.stripSession((KieSession)ksession).getAgenda()).getAgenda().getAgendaGroups();
        Assert.assertEquals((long)1L, (long)groups.length);
        Assert.assertEquals((Object)"MAIN", (Object)groups[0].getName());
        int id = ksession.getId();
        ArrayList<String> list = new ArrayList<String>();
        list.add("Test");
        ksession.insert(list);
        ksession.execute((Command)new ActivateRuleFlowCommand("ruleflow-group"));
        ksession.dispose();
        ksession = this.createSession(id, "ruleflow-groups.drl");
        groups = ((AgendaImpl)this.stripSession((KieSession)ksession).getAgenda()).getAgenda().getAgendaGroups();
        Assert.assertEquals((long)2L, (long)groups.length);
        Assert.assertEquals((Object)"MAIN", (Object)groups[0].getName());
        Assert.assertEquals((Object)"ruleflow-group", (Object)groups[1].getName());
    }

    @Test
    public void testAgendaGroupOnly() throws Exception {
        CommandBasedStatefulKnowledgeSession ksession = this.createSession(-1, "agenda-groups.drl");
        AgendaGroup[] groups = ((AgendaImpl)this.stripSession((KieSession)ksession).getAgenda()).getAgenda().getAgendaGroups();
        Assert.assertEquals((long)1L, (long)groups.length);
        Assert.assertEquals((Object)"MAIN", (Object)groups[0].getName());
        int id = ksession.getId();
        ArrayList<String> list = new ArrayList<String>();
        list.add("Test");
        ksession.insert(list);
        ksession.execute((Command)new ActivateAgendaGroupCommand("agenda-group"));
        ksession.dispose();
        ksession = this.createSession(id, "agenda-groups.drl");
        groups = ((AgendaImpl)this.stripSession((KieSession)ksession).getAgenda()).getAgenda().getAgendaGroups();
        Assert.assertEquals((long)2L, (long)groups.length);
        Assert.assertEquals((Object)"MAIN", (Object)groups[0].getName());
        Assert.assertEquals((Object)"agenda-group", (Object)groups[1].getName());
    }

    @Test
    public void testAgendaGroupAndRuleFlowGroup() throws Exception {
        CommandBasedStatefulKnowledgeSession ksession = this.createSession(-1, "agenda-groups.drl", "ruleflow-groups.drl");
        AgendaGroup[] groups = ((AgendaImpl)this.stripSession((KieSession)ksession).getAgenda()).getAgenda().getAgendaGroups();
        Assert.assertEquals((long)1L, (long)groups.length);
        Assert.assertEquals((Object)"MAIN", (Object)groups[0].getName());
        int id = ksession.getId();
        ArrayList<String> list = new ArrayList<String>();
        list.add("Test");
        ksession.insert(list);
        ksession.execute((Command)new ActivateAgendaGroupCommand("agenda-group"));
        ksession.execute((Command)new ActivateRuleFlowCommand("ruleflow-group"));
        ksession.dispose();
        ksession = this.createSession(id, "agenda-groups.drl", "ruleflow-groups.drl");
        groups = ((AgendaImpl)this.stripSession((KieSession)ksession).getAgenda()).getAgenda().getAgendaGroups();
        Assert.assertEquals((long)3L, (long)groups.length);
        Assert.assertEquals((Object)"MAIN", (Object)groups[0].getName());
        Assert.assertEquals((Object)"ruleflow-group", (Object)groups[1].getName());
        Assert.assertEquals((Object)"agenda-group", (Object)groups[2].getName());
    }

    private KieSession stripSession(KieSession ksession) {
        if (ksession instanceof CommandBasedStatefulKnowledgeSession) {
            return ((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getKieSession();
        }
        return ksession;
    }

    private CommandBasedStatefulKnowledgeSession createSession(int id, String ... rules) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        for (String rule : rules) {
            kbuilder.add((Resource)new ClassPathResource(rule), ResourceType.DRL);
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        Environment env = PersistenceUtil.createEnvironment(this.context);
        if (this.locking) {
            env.set("org.kie.api.persistence.pessimistic", (Object)true);
        }
        if (id == -1) {
            return (CommandBasedStatefulKnowledgeSession)JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)env);
        }
        return (CommandBasedStatefulKnowledgeSession)JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KieBase)kbase, null, (Environment)env);
    }

    public class ExceptionCommand
    implements GenericCommand<Object> {
        public Void execute(Context context) {
            throw new RuntimeException();
        }
    }

    public class ActivateAgendaGroupCommand
    implements GenericCommand<Object> {
        private String agendaGroupName;

        public ActivateAgendaGroupCommand(String agendaGroupName) {
            this.agendaGroupName = agendaGroupName;
        }

        public Void execute(Context context) {
            KieSession ksession = ((KnowledgeCommandContext)context).getKieSession();
            ((InternalAgenda)ksession.getAgenda()).getAgendaGroup(this.agendaGroupName).setFocus();
            return null;
        }
    }

    public class ActivateRuleFlowCommand
    implements GenericCommand<Object> {
        private String ruleFlowGroupName;

        public ActivateRuleFlowCommand(String ruleFlowGroupName) {
            this.ruleFlowGroupName = ruleFlowGroupName;
        }

        public Void execute(Context context) {
            KieSession ksession = ((KnowledgeCommandContext)context).getKieSession();
            ((InternalAgenda)ksession.getAgenda()).activateRuleFlowGroup(this.ruleFlowGroupName);
            return null;
        }
    }
}

