/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.jta;

import java.util.concurrent.locks.ReentrantLock;
import org.drools.core.command.impl.AbstractInterceptor;
import org.drools.persistence.OrderedTransactionSynchronization;
import org.drools.persistence.TransactionManager;
import org.drools.persistence.TransactionManagerHelper;
import org.kie.api.command.Command;
import org.kie.api.runtime.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionLockInterceptor
extends AbstractInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(TransactionLockInterceptor.class);
    private boolean active = false;
    private ReentrantLock lock = new ReentrantLock();
    private Environment environment;

    public TransactionLockInterceptor(Environment environment) {
        this.environment = environment;
        this.active = Boolean.getBoolean("org.kie.tx.lock.enabled");
        if (environment.get("TRANSACTION_LOCK_ENABLED") != null) {
            this.active = Boolean.parseBoolean(environment.get("TRANSACTION_LOCK_ENABLED").toString());
        }
        logger.debug("Transaction lock interceptor enabled " + this.active);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(Command<T> command) {
        if (!this.active) {
            return (T)this.executeNext(command);
        }
        boolean locked = false;
        if (!this.lock.isHeldByCurrentThread()) {
            logger.debug("About to get a lock on command service by {}", (Object)Thread.currentThread().getName());
            this.lock.lock();
            locked = true;
            logger.debug("Lock taken by {}", (Object)Thread.currentThread().getName());
        }
        try {
            Object object = this.executeNext(command);
            return (T)object;
        }
        finally {
            if (locked) {
                logger.debug("About to register lock release handler by {}", (Object)Thread.currentThread().getName());
                this.release((TransactionManager)this.environment.get("org.kie.transaction.TransactionManager"));
            }
        }
    }

    protected void release(TransactionManager txm) {
        try {
            TransactionManagerHelper.registerTransactionSyncInContainer(txm, new OrderedTransactionSynchronization(100){

                @Override
                public void beforeCompletion() {
                }

                @Override
                public void afterCompletion(int status) {
                    logger.debug("Releasing on transaction completion by {}", (Object)Thread.currentThread().getName());
                    TransactionLockInterceptor.this.lock.unlock();
                    logger.debug("Successfully released lock by {}", (Object)Thread.currentThread().getName());
                }
            });
        }
        catch (Throwable e) {
            logger.debug("Error happened releasing directly by {} due to {}", (Object)Thread.currentThread().getName(), (Object)e.getMessage());
            this.lock.unlock();
        }
    }
}

