/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.kie.persistence.cdi;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.inject.Inject;
import org.drools.persistence.util.PersistenceUtil;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.cdi.KBase;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class CDITest {
    private HashMap<String, Object> context;
    private Environment env;
    private boolean locking;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> persistence() {
        Object[][] locking = new Object[][]{{PersistenceUtil.OPTIMISTIC_LOCKING}, {PersistenceUtil.PESSIMISTIC_LOCKING}};
        return Arrays.asList(locking);
    }

    public CDITest(String locking) {
        this.locking = PersistenceUtil.PESSIMISTIC_LOCKING.equals(locking);
    }

    @Before
    public void setUp() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource("org.drools.persistence.jpa");
        this.env = PersistenceUtil.createEnvironment(this.context);
        if (this.locking) {
            this.env.set("org.kie.api.persistence.pessimistic", (Object)true);
        }
    }

    @After
    public void tearDown() throws Exception {
        PersistenceUtil.cleanUp(this.context);
    }

    @Test
    public void testCDI() {
        Weld w = new Weld();
        WeldContainer wc = w.initialize();
        CDIBean bean = (CDIBean)wc.instance().select(CDIBean.class, new Annotation[0]).get();
        bean.test(this.env);
        w.shutdown();
    }

    public static class CDIBean {
        @Inject
        @KBase(value="cdiexample")
        KieBase kBase;

        public void test(Environment env) {
            KieSession ksession = KieServices.Factory.get().getStoreServices().newKieSession(this.kBase, null, env);
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)1);
            ksession.insert((Object)2);
            ksession.insert((Object)3);
            ksession.fireAllRules();
            Assert.assertEquals((long)3L, (long)list.size());
        }
    }
}

