/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.timer.integrationtests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.drools.core.ClockType;
import org.drools.core.time.SessionPseudoClock;
import org.drools.persistence.util.PersistenceUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.definition.type.FactType;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderErrors;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.conf.RuleEngineOption;
import org.kie.internal.definition.KnowledgePackage;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;

@RunWith(value=Parameterized.class)
public class TimerAndCalendarTest {
    private HashMap<String, Object> context;
    private boolean locking;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> persistence() {
        Object[][] locking = new Object[][]{{PersistenceUtil.OPTIMISTIC_LOCKING}, {PersistenceUtil.PESSIMISTIC_LOCKING}};
        return Arrays.asList(locking);
    }

    public TimerAndCalendarTest(String locking) {
        this.locking = PersistenceUtil.PESSIMISTIC_LOCKING.equals(locking);
    }

    @Before
    public void before() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource("org.drools.persistence.jpa");
    }

    @After
    public void after() throws Exception {
        PersistenceUtil.cleanUp(this.context);
    }

    @Test
    @Ignore(value="beta4 phreak")
    public void testTimerRuleAfterIntReloadSession() throws Exception {
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSession ksession = this.createSession(kbase);
        SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(300L, TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(300L, TimeUnit.MILLISECONDS);
        ksession = this.disposeAndReloadSession(ksession, kbase);
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(300L, TimeUnit.MILLISECONDS);
        String timerRule = "package org.drools.test\nglobal java.util.List list \nrule TimerRule \n   timer (int:1000 500) \nwhen \nthen \n        list.add(list.size()); \n end";
        Resource resource = ResourceFactory.newByteArrayResource((byte[])timerRule.getBytes());
        Collection<KnowledgePackage> kpackages = this.buildKnowledgePackage(resource, ResourceType.DRL);
        kbase.addKnowledgePackages(kpackages);
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        ksession = this.disposeAndReloadSession(ksession, kbase);
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        List list = Collections.synchronizedList(new ArrayList());
        ksession.setGlobal("list", list);
        Assert.assertEquals((long)0L, (long)list.size());
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(1700L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)2L, (long)list.size());
        ksession = this.disposeAndReloadSession(ksession, kbase);
        ksession.setGlobal("list", list);
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(1000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)4L, (long)list.size());
    }

    @Test
    @Ignore(value="beta4 phreak")
    public void testTimerRuleAfterCronReloadSession() throws Exception {
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSession ksession = this.createSession(kbase);
        SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(300L, TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(300L, TimeUnit.MILLISECONDS);
        ksession = this.disposeAndReloadSession(ksession, kbase);
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(300L, TimeUnit.MILLISECONDS);
        String timerRule = "package org.drools.test\nglobal java.util.List list \nrule TimerRule \n   timer (cron: * * * * * ?) \nwhen \nthen \n        list.add(list.size()); \n end";
        Resource resource = ResourceFactory.newByteArrayResource((byte[])timerRule.getBytes());
        Collection<KnowledgePackage> kpackages = this.buildKnowledgePackage(resource, ResourceType.DRL);
        kbase.addKnowledgePackages(kpackages);
        List list = Collections.synchronizedList(new ArrayList());
        ksession.setGlobal("list", list);
        ksession.setGlobal("list", list);
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        ksession = this.disposeAndReloadSession(ksession, kbase);
        ksession.setGlobal("list", list);
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)list.size());
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(3L, TimeUnit.SECONDS);
        Assert.assertEquals((long)4L, (long)list.size());
        ksession = this.disposeAndReloadSession(ksession, kbase);
        ksession.setGlobal("list", list);
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(2L, TimeUnit.SECONDS);
        Assert.assertEquals((long)6L, (long)list.size());
    }

    @Test
    public void testEventExpires() throws Exception {
        String timerRule = "package org.drools.test\ndeclare TestEvent \n    @role( event )\n    @expires( 10s )\nend\nrule TimerRule \n    when \n        TestEvent( ) from entry-point \"Test\"\n    then \nend";
        KieBaseConfiguration kbconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kbconf.setOption((KieBaseOption)EventProcessingOption.STREAM);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)kbconf);
        Resource resource = ResourceFactory.newByteArrayResource((byte[])timerRule.getBytes());
        Collection<KnowledgePackage> kpackages = this.buildKnowledgePackage(resource, ResourceType.DRL);
        kbase.addKnowledgePackages(kpackages);
        StatefulKnowledgeSession ksession = this.createSession(kbase);
        FactType type = kbase.getFactType("org.drools.test", "TestEvent");
        Assert.assertNotNull((String)"could not get type", (Object)type);
        ksession = this.disposeAndReloadSession(ksession, kbase);
        ksession.getEntryPoint("Test").insert(type.newInstance());
        ksession.fireAllRules();
        ksession = this.disposeAndReloadSession(ksession, kbase);
        ksession = this.disposeAndReloadSession(ksession, kbase);
    }

    @Test
    public void testTimerWithRemovingRule() throws Exception {
        KieBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KieBaseOption)RuleEngineOption.RETEOO);
        KnowledgeBase kbase1 = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)kconf);
        String str1 = "package org.test; import java.util.*; global java.util.List list; rule R1\n    timer ( int: 5s )\nwhen\n    $s : String( )\nthen\n    list.add( $s );\nend\n";
        Resource resource1 = ResourceFactory.newByteArrayResource((byte[])str1.getBytes());
        Collection<KnowledgePackage> kpackages1 = this.buildKnowledgePackage(resource1, ResourceType.DRL);
        kbase1.addKnowledgePackages(kpackages1);
        StatefulKnowledgeSession ksession1 = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase1, null, (Environment)PersistenceUtil.createEnvironment(this.context));
        int ksessionId = ksession1.getId();
        ArrayList list = new ArrayList();
        ksession1.setGlobal("list", list);
        ksession1.insert((Object)"hello");
        ksession1.fireAllRules();
        ksession1.dispose();
        Assert.assertEquals((long)0L, (long)list.size());
        Thread.sleep(5000L);
        KnowledgeBase kbase2 = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)kconf);
        String str2 = "package org.test; import java.util.*; global java.util.List list; rule R2\nwhen\n    $s : Integer( )\nthen\n    list.add( $s );\nend\n";
        Resource resource2 = ResourceFactory.newByteArrayResource((byte[])str2.getBytes());
        Collection<KnowledgePackage> kpackages2 = this.buildKnowledgePackage(resource2, ResourceType.DRL);
        kbase2.addKnowledgePackages(kpackages2);
        StatefulKnowledgeSession ksession2 = JPAKnowledgeService.loadStatefulKnowledgeSession((int)ksessionId, (KieBase)kbase2, null, (Environment)PersistenceUtil.createEnvironment(this.context));
        ksession2.setGlobal("list", list);
        ksession2.fireAllRules();
        ksession2.dispose();
        Assert.assertEquals((long)0L, (long)list.size());
    }

    private StatefulKnowledgeSession createSession(KnowledgeBase kbase) {
        KieSessionConfiguration conf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        Environment env = PersistenceUtil.createEnvironment(this.context);
        if (this.locking) {
            env.set("org.kie.api.persistence.pessimistic", (Object)true);
        }
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, (KieSessionConfiguration)conf, (Environment)env);
        return ksession;
    }

    private StatefulKnowledgeSession disposeAndReloadSession(StatefulKnowledgeSession ksession, KnowledgeBase kbase) {
        int ksessionId = ksession.getId();
        ksession.dispose();
        KieSessionConfiguration conf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        StatefulKnowledgeSession newksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)ksessionId, (KieBase)kbase, (KieSessionConfiguration)conf, (Environment)PersistenceUtil.createEnvironment(this.context));
        return newksession;
    }

    private Collection<KnowledgePackage> buildKnowledgePackage(Resource resource, ResourceType resourceType) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(resource, resourceType);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (errors != null && errors.size() > 0) {
            for (KnowledgeBuilderError error : errors) {
                System.err.println("Error: " + error.getMessage());
            }
            Assert.fail((String)"KnowledgeBase did not build");
        }
        Collection packages = kbuilder.getKnowledgePackages();
        return packages;
    }
}

