/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence;

import java.util.Set;
import javax.persistence.EntityManager;
import org.drools.persistence.TransactionManager;
import org.drools.persistence.TransactionManagerHelper;
import org.drools.persistence.TransactionSynchronization;
import org.drools.persistence.Transformable;
import org.kie.api.runtime.Environment;

public class TriggerUpdateTransactionSynchronization
implements TransactionSynchronization {
    private TransactionManager txm;
    private Environment environment;

    public TriggerUpdateTransactionSynchronization(TransactionManager txm, Environment environment) {
        this.txm = txm;
        this.environment = environment;
    }

    @Override
    public void beforeCompletion() {
        EntityManager cmdScopedEM;
        Set<Transformable> toBeUpdated = TransactionManagerHelper.getUpdateableSet(this.txm);
        if (!this.isValid() || toBeUpdated == null || toBeUpdated.isEmpty()) {
            return;
        }
        EntityManager appScopedEM = (EntityManager)this.environment.get("org.kie.api.persistence.jpa.AppScopedEntityManager");
        if (appScopedEM == null) {
            appScopedEM = (EntityManager)this.txm.getResource("org.kie.api.persistence.jpa.AppScopedEntityManager");
        }
        if ((cmdScopedEM = (EntityManager)this.txm.getResource("org.kie.api.persistence.jpa.CmdScopedEntityManager")) == null) {
            cmdScopedEM = (EntityManager)this.environment.get("org.kie.api.persistence.jpa.CmdScopedEntityManager");
        }
        boolean flushApp = false;
        boolean flushCmd = false;
        for (Transformable transformable : toBeUpdated) {
            if (transformable == null) continue;
            transformable.transform();
            if (appScopedEM != null && appScopedEM.contains((Object)transformable)) {
                appScopedEM.merge((Object)transformable);
                TransactionManagerHelper.removeFromUpdatableSet(this.txm, transformable);
                flushApp = true;
                continue;
            }
            if (cmdScopedEM == null || !cmdScopedEM.contains((Object)transformable)) continue;
            cmdScopedEM.merge((Object)transformable);
            TransactionManagerHelper.removeFromUpdatableSet(this.txm, transformable);
            flushCmd = true;
        }
        if (flushApp) {
            appScopedEM.flush();
        }
        if (flushCmd) {
            cmdScopedEM.flush();
        }
    }

    @Override
    public void afterCompletion(int status) {
    }

    private boolean isValid() {
        Object appScopedEM = this.environment.get("org.kie.api.persistence.jpa.AppScopedEntityManager");
        return appScopedEM == null || appScopedEM instanceof EntityManager;
    }
}

