/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.command;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.drools.compiler.command.KBuilderBatchExecutionTest;
import org.drools.persistence.util.PersistenceUtil;
import org.junit.After;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;

@RunWith(value=Parameterized.class)
public class KBuilderBatchExecutionPersistenceTest
extends KBuilderBatchExecutionTest {
    private HashMap<String, Object> context;
    private boolean locking;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> persistence() {
        Object[][] locking = new Object[][]{{PersistenceUtil.OPTIMISTIC_LOCKING}, {PersistenceUtil.PESSIMISTIC_LOCKING}};
        return Arrays.asList(locking);
    }

    public KBuilderBatchExecutionPersistenceTest(String locking) {
        this.locking = PersistenceUtil.PESSIMISTIC_LOCKING.equals(locking);
    }

    @After
    public void cleanUpPersistence() throws Exception {
        this.disposeKSession();
        PersistenceUtil.cleanUp(this.context);
        this.context = null;
    }

    protected StatefulKnowledgeSession createKnowledgeSession(KnowledgeBase kbase) {
        if (this.context == null) {
            this.context = PersistenceUtil.setupWithPoolingDataSource("org.drools.persistence.jpa");
        }
        KieSessionConfiguration ksconf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        Environment env = PersistenceUtil.createEnvironment(this.context);
        if (this.locking) {
            env.set("org.kie.api.persistence.pessimistic", (Object)true);
        }
        return JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, (KieSessionConfiguration)ksconf, (Environment)env);
    }
}

