/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.marshalling.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.persistence.EntityManagerFactory;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.persistence.marshalling.util.CompareViaReflectionUtil;
import org.drools.persistence.marshalling.util.MarshalledData;
import org.drools.persistence.marshalling.util.MarshallingDBUtil;
import org.drools.persistence.marshalling.util.MarshallingTestUtil;
import org.drools.persistence.util.PersistenceUtil;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.conf.TimerJobFactoryOption;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMarshallingUtilsTest {
    private static Logger logger = LoggerFactory.getLogger(TestMarshallingUtilsTest.class);
    private static boolean debug = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testUnmarshallingMarshalledData() {
        HashMap<String, Object> testContext = null;
        ArrayList<MarshalledData> marshalledDataList = null;
        try {
            testContext = MarshallingDBUtil.initializeMarshalledDataEMF("org.drools.persistence.jpa", this.getClass(), true);
            EntityManagerFactory emf = (EntityManagerFactory)testContext.get("org.kie.api.persistence.jpa.EntityManagerFactory");
            marshalledDataList = MarshallingTestUtil.retrieveMarshallingData(emf);
        }
        finally {
            PersistenceUtil.cleanUp(testContext);
        }
        for (MarshalledData marshalledData : marshalledDataList) {
            String className = marshalledData.marshalledObjectClassName.substring(marshalledData.marshalledObjectClassName.lastIndexOf(46) + 1);
            try {
                MarshallingTestUtil.unmarshallObject(marshalledData);
                logger.debug("- " + className + ": " + marshalledData.getTestMethodAndSnapshotNum());
            }
            catch (Exception e) {
                logger.debug("X " + className + ": " + marshalledData.getTestMethodAndSnapshotNum());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testUnmarshallingSpecificMarshalledData() {
        String testMethodAndSnapNum = "org.drools.persistence.session.RuleFlowGroupRollbackTest.testRuleFlowGroupRollback:1";
        HashMap<String, Object> testContext = MarshallingDBUtil.initializeMarshalledDataEMF("org.drools.persistence.jpa", this.getClass(), true);
        EntityManagerFactory emf = (EntityManagerFactory)testContext.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        ArrayList<MarshalledData> marshalledDataList = MarshallingTestUtil.retrieveMarshallingData(emf);
        MarshalledData marshalledData = null;
        for (MarshalledData marshalledDataElement : marshalledDataList) {
            if (!testMethodAndSnapNum.equals(marshalledDataElement.getTestMethodAndSnapshotNum())) continue;
            marshalledData = marshalledDataElement;
        }
        try {
            Object unmarshalledObject = MarshallingTestUtil.unmarshallObject(marshalledData);
            Assert.assertNotNull((Object)unmarshalledObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("[" + e.getClass().getSimpleName() + "]: " + e.getMessage()));
        }
        finally {
            PersistenceUtil.cleanUp(testContext);
        }
    }

    @Test
    @Ignore
    public void testCompareArrays() {
        int[] testA = new int[]{1, 3};
        int[] testB = new int[]{1, 3};
        boolean same = CompareViaReflectionUtil.compareInstances(testA, testA);
        Assert.assertTrue((boolean)same);
        TestMarshallingUtilsTest.printResult(same, testA, testB);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeBase[] testArrA = new KnowledgeBase[]{kbase};
        KnowledgeBase[] testArrB = new KnowledgeBase[]{kbase, null};
        same = CompareViaReflectionUtil.compareInstances(testArrA, testArrB);
        Assert.assertTrue((!same ? 1 : 0) != 0);
        TestMarshallingUtilsTest.printResult(same, testArrA, testArrB);
        Environment[] testEnvA = new Environment[]{EnvironmentFactory.newEnvironment(), EnvironmentFactory.newEnvironment()};
        Environment[] testEnvB = new Environment[]{EnvironmentFactory.newEnvironment(), EnvironmentFactory.newEnvironment()};
        testEnvA[0].set("org.drools.persistence.jpa", (Object)"org.drools.persistence.jpa");
        same = CompareViaReflectionUtil.compareInstances(testEnvA, testEnvB);
        Assert.assertTrue((!same ? 1 : 0) != 0);
        TestMarshallingUtilsTest.printResult(same, testEnvA, testEnvB);
        PriorityQueue<Short> priShortA = new PriorityQueue<Short>();
        PriorityQueue<Short> priShortB = new PriorityQueue<Short>();
        short[] shortList = new short[]{6, 8, 6, 1, 8, 5, 9};
        for (int i = 0; i < shortList.length; ++i) {
            priShortA.add(shortList[i]);
            priShortB.add(shortList[i]);
        }
        priShortB.add((short)0);
        Assert.assertFalse((String)"Should be unequal", (boolean)CompareViaReflectionUtil.compareInstances(priShortA, priShortB));
        Assert.assertEquals((Object)new Short(0), priShortB.poll());
        Assert.assertTrue((String)"Should be equal", (boolean)CompareViaReflectionUtil.compareInstances(priShortA, priShortB));
    }

    private static void printResult(boolean same, Object objA, Object objB) {
        int i;
        if (!debug) {
            return;
        }
        logger.debug("Same: " + same);
        String outLine = "a: {";
        for (i = 0; i < Array.getLength(objA); ++i) {
            outLine = outLine + Array.get(objA, i) + ",";
        }
        outLine = outLine.substring(0, outLine.lastIndexOf(",")) + "}";
        logger.debug(outLine);
        outLine = "b: {";
        for (i = 0; i < Array.getLength(objB); ++i) {
            outLine = outLine + Array.get(objB, i) + ",";
        }
        outLine = outLine.substring(0, outLine.lastIndexOf(",")) + "}";
        logger.debug(outLine);
    }

    @Test
    @Ignore
    public void testCompareAtomicPrimitives() {
        AtomicInteger objA = new AtomicInteger(-1);
        AtomicInteger objB = new AtomicInteger(-1);
        int a = objA.get();
        int b = objB.get();
        Assert.assertFalse((String)"objs?", (boolean)objA.equals(objB));
        Assert.assertTrue((String)"ints?", (a == b ? 1 : 0) != 0);
        Assert.assertTrue((String)"compare a?", (boolean)CompareViaReflectionUtil.compareAtomicPrimitives(objA, objB));
        AtomicBoolean objC = new AtomicBoolean(false);
        AtomicBoolean objD = new AtomicBoolean(false);
        boolean c = objC.get();
        boolean d = objD.get();
        Assert.assertFalse((String)"objs?", (boolean)objC.equals(objD));
        Assert.assertTrue((String)"bools?", (c == d ? 1 : 0) != 0);
        Assert.assertTrue((String)"compare c?", (boolean)CompareViaReflectionUtil.compareAtomicPrimitives(objC, objD));
    }

    @Test
    @Ignore
    public void testCompareInstances() throws Exception {
        StatefulKnowledgeSession ksessionA = null;
        KieBaseConfiguration config = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        config.setOption((KieBaseOption)EventProcessingOption.STREAM);
        KnowledgeBase knowledgeBaseA = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)config);
        KieSessionConfiguration ksconf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ksconf.setOption((KieSessionOption)ClockTypeOption.get((String)"pseudo"));
        ksconf.setOption((KieSessionOption)TimerJobFactoryOption.get((String)"trackable"));
        ksessionA = knowledgeBaseA.newStatefulKnowledgeSession(ksconf, null);
        StatefulKnowledgeSession ksessionB = null;
        KieBaseConfiguration config2 = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        config2.setOption((KieBaseOption)EventProcessingOption.STREAM);
        KnowledgeBase knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)config2);
        KieSessionConfiguration ksconf2 = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ksconf2.setOption((KieSessionOption)ClockTypeOption.get((String)"pseudo"));
        ksconf2.setOption((KieSessionOption)TimerJobFactoryOption.get((String)"trackable"));
        ksessionB = knowledgeBase.newStatefulKnowledgeSession(ksconf2, null);
        Assert.assertTrue((String)(CompareViaReflectionUtil.class.getSimpleName() + " is broken!"), (boolean)CompareViaReflectionUtil.compareInstances(ksessionA, ksessionB));
    }
}

