/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.session;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.drools.core.command.Interceptor;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.persistence.SingleSessionCommandService;
import org.drools.persistence.jpa.OptimisticLockRetryInterceptor;
import org.drools.persistence.util.PersistenceUtil;
import org.hibernate.StaleObjectStateException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaOptLockPersistentStatefulSessionTest {
    private static Logger logger = LoggerFactory.getLogger(JpaOptLockPersistentStatefulSessionTest.class);
    private HashMap<String, Object> context;
    private Environment env;

    @Before
    public void setUp() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource("org.drools.persistence.jpa");
        this.env = PersistenceUtil.createEnvironment(this.context);
    }

    @After
    public void tearDown() throws Exception {
        PersistenceUtil.cleanUp(this.context);
    }

    @Test
    public void testOptimisticLockInterceptor() {
        String str = "";
        str = str + "package org.kie.test\n";
        str = str + "global java.util.List list\n";
        str = str + "rule rule1\n";
        str = str + "when\n";
        str = str + "  Integer(intValue > 0)\n";
        str = str + "then\n";
        str = str + "  list.add( 1 );\n";
        str = str + "end\n";
        str = str + "\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)this.env);
        ArrayList list = new ArrayList();
        for (int i = 0; i < 2; ++i) {
            new InsertAndFireThread(ksession.getIdentifier(), kbase, list).start();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Assert.assertEquals((long)6L, (long)list.size());
        ksession.dispose();
    }

    private class InsertAndFireThread
    extends Thread {
        private long ksessionId;
        private KnowledgeBase kbase;
        private List<?> list;

        InsertAndFireThread(long ksessionId, KnowledgeBase kbase, List<?> list) {
            this.ksessionId = ksessionId;
            this.kbase = kbase;
            this.list = list;
        }

        @Override
        public void run() {
            StatefulKnowledgeSession ksession2 = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)this.ksessionId, (KieBase)this.kbase, null, (Environment)PersistenceUtil.createEnvironment(JpaOptLockPersistentStatefulSessionTest.this.context));
            SingleSessionCommandService sscs = (SingleSessionCommandService)((CommandBasedStatefulKnowledgeSession)ksession2).getCommandService();
            OptimisticLockRetryInterceptor interceptor = new OptimisticLockRetryInterceptor();
            interceptor.setDelay(500L);
            sscs.addInterceptor((Interceptor)interceptor);
            ksession2.setGlobal("list", this.list);
            ksession2.insert((Object)1);
            ksession2.insert((Object)2);
            ksession2.insert((Object)3);
            ksession2.getWorkItemManager().completeWorkItem(0L, null);
            ksession2.fireAllRules();
            logger.info("The above " + StaleObjectStateException.class.getSimpleName() + "'s were expected in this test.");
            ksession2.dispose();
        }
    }
}

