/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.persistence.TransactionManager;
import org.drools.persistence.TransactionManagerFactory;
import org.drools.persistence.jta.JtaTransactionManager;
import org.drools.persistence.jta.JtaTransactionManagerFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.Environment;

public class TransactionManagerFactoryTest {
    @Before
    public void clearFactoryClassProperty() {
        System.clearProperty("org.kie.txm.factory.class");
    }

    @Test
    public void defaultsToJtaTransactionManagerFactory() throws Exception {
        Assert.assertEquals((Object)JtaTransactionManagerFactory.class.getName(), (Object)this.loadNewTransactionManagerFactory().getClass().getName());
    }

    @Test
    public void createsSystemPropertySpecifiedFactory() throws Exception {
        System.setProperty("org.kie.txm.factory.class", TestTransactionManagerFactory.class.getName());
        Assert.assertEquals((Object)TestTransactionManagerFactory.class.getName(), (Object)this.loadNewTransactionManagerFactory().getClass().getName());
    }

    @Test
    public void createsJtaTransactionManager() throws Exception {
        Assert.assertEquals(JtaTransactionManager.class, this.getTransactionManagerFromNewFactory().getClass());
    }

    @Test
    public void createsJtaTransactionManagerWithEnvironment() throws Exception {
        Environment env = EnvironmentFactory.newEnvironment();
        Assert.assertEquals(JtaTransactionManager.class, this.getTransactionManagerFromNewFactory(env).getClass());
    }

    private TransactionManager getTransactionManagerFromNewFactory() throws Exception {
        Object factory = this.loadNewTransactionManagerFactory();
        return (TransactionManager)factory.getClass().getMethod("newTransactionManager", new Class[0]).invoke(factory, new Object[0]);
    }

    private TransactionManager getTransactionManagerFromNewFactory(Environment env) throws Exception {
        Object factory = this.loadNewTransactionManagerFactory();
        return (TransactionManager)factory.getClass().getMethod("newTransactionManager", Environment.class).invoke(factory, env);
    }

    private Object loadNewTransactionManagerFactory() throws Exception {
        Class<?> factoryClass = this.createFactoryClassLoader().loadClass("org.drools.persistence.TransactionManagerFactory");
        return factoryClass.getMethod("get", new Class[0]).invoke(null, new Object[0]);
    }

    private ClassLoader createFactoryClassLoader() {
        URL[] urls;
        if (this.getClass().getClassLoader() instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)this.getClass().getClassLoader();
            urls = ucl.getURLs();
        } else {
            urls = this.getClassPathURLs();
        }
        return new URLClassLoader(urls, this.getClass().getClassLoader()){

            @Override
            public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                if (name.endsWith("TransactionManagerFactory")) {
                    Class<?> c = this.findLoadedClass(name);
                    if (c == null) {
                        c = this.findClass(name);
                    }
                    if (resolve) {
                        this.resolveClass(c);
                    }
                    return c;
                }
                return super.loadClass(name, resolve);
            }
        };
    }

    private URL[] getClassPathURLs() {
        String cp = System.getProperty("java.class.path");
        String[] elements = cp.split(File.pathSeparator);
        if (elements.length == 0) {
            elements = new String[]{""};
        }
        URL[] urls = new URL[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            try {
                URL url;
                urls[i] = url = new File(elements[i]).toURI().toURL();
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return urls;
    }

    public static final class TestTransactionManagerFactory
    extends TransactionManagerFactory {
        public TransactionManager newTransactionManager() {
            return null;
        }

        public TransactionManager newTransactionManager(Environment environment) {
            return null;
        }
    }
}

