/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.kie.persistence.session;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.drools.compiler.Person;
import org.drools.core.SessionConfiguration;
import org.drools.core.command.Interceptor;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.command.impl.FireAllRulesInterceptor;
import org.drools.core.command.impl.LoggingInterceptor;
import org.drools.core.factmodel.traits.Traitable;
import org.drools.core.time.SessionPseudoClock;
import org.drools.persistence.SingleSessionCommandService;
import org.drools.persistence.util.DroolsPersistenceUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.definition.type.FactType;
import org.kie.api.definition.type.Position;
import org.kie.api.io.Resource;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.command.CommandFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class JpaPersistentStatefulSessionTest {
    private static Logger logger = LoggerFactory.getLogger(JpaPersistentStatefulSessionTest.class);
    private Map<String, Object> context;
    private Environment env;
    private boolean locking;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> persistence() {
        Object[][] locking = new Object[][]{{DroolsPersistenceUtil.OPTIMISTIC_LOCKING}, {DroolsPersistenceUtil.PESSIMISTIC_LOCKING}};
        return Arrays.asList(locking);
    }

    public JpaPersistentStatefulSessionTest(String locking) {
        this.locking = DroolsPersistenceUtil.PESSIMISTIC_LOCKING.equals(locking);
    }

    @Before
    public void setUp() throws Exception {
        this.context = DroolsPersistenceUtil.setupWithPoolingDataSource((String)"org.drools.persistence.jpa");
        this.env = DroolsPersistenceUtil.createEnvironment(this.context);
        if (this.locking) {
            this.env.set("org.kie.api.persistence.pessimistic", (Object)true);
        }
    }

    @After
    public void tearDown() throws Exception {
        DroolsPersistenceUtil.cleanUp(this.context);
    }

    @Test
    public void testFactHandleSerialization() {
        String str = "";
        str = str + "package org.kie.test\n";
        str = str + "import java.util.concurrent.atomic.AtomicInteger\n";
        str = str + "global java.util.List list\n";
        str = str + "rule rule1\n";
        str = str + "when\n";
        str = str + " $i: AtomicInteger(intValue > 0)\n";
        str = str + "then\n";
        str = str + " list.add( $i );\n";
        str = str + "end\n";
        str = str + "\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", str);
        ks.newKieBuilder(kfs).buildAll();
        KieBase kbase = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).getKieBase();
        KieSession ksession = ks.getStoreServices().newKieSession(kbase, null, this.env);
        List list = new ArrayList();
        ksession.setGlobal("list", list);
        AtomicInteger value = new AtomicInteger(4);
        FactHandle atomicFH = ksession.insert((Object)value);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        value.addAndGet(1);
        ksession.update(atomicFH, (Object)value);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        String externalForm = atomicFH.toExternalForm();
        ksession = ks.getStoreServices().loadKieSession(Long.valueOf(ksession.getIdentifier()), kbase, null, this.env);
        atomicFH = (FactHandle)ksession.execute(CommandFactory.fromExternalFactHandleCommand((String)externalForm));
        value.addAndGet(1);
        ksession.update(atomicFH, (Object)value);
        ksession.fireAllRules();
        list = (List)ksession.getGlobal("list");
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testLocalTransactionPerStatement() {
        String str = "";
        str = str + "package org.kie.test\n";
        str = str + "global java.util.List list\n";
        str = str + "rule rule1\n";
        str = str + "when\n";
        str = str + "  Integer(intValue > 0)\n";
        str = str + "then\n";
        str = str + "  list.add( 1 );\n";
        str = str + "end\n";
        str = str + "\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", str);
        ks.newKieBuilder(kfs).buildAll();
        KieBase kbase = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).getKieBase();
        KieSession ksession = ks.getStoreServices().newKieSession(kbase, null, this.env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)2);
        ksession.insert((Object)3);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testUserTransactions() throws Exception {
        String str = "";
        str = str + "package org.kie.test\n";
        str = str + "global java.util.List list\n";
        str = str + "rule rule1\n";
        str = str + "when\n";
        str = str + "  $i : Integer(intValue > 0)\n";
        str = str + "then\n";
        str = str + "  list.add( $i );\n";
        str = str + "end\n";
        str = str + "\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", str);
        ks.newKieBuilder(kfs).buildAll();
        KieBase kbase = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).getKieBase();
        UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        KieSession ksession = ks.getStoreServices().newKieSession(kbase, null, this.env);
        ut.commit();
        ArrayList list = new ArrayList();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)2);
        ksession.fireAllRules();
        ut.commit();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.insert((Object)3);
        ut.rollback();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.fireAllRules();
        ut.commit();
        Assert.assertEquals((long)2L, (long)list.size());
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.insert((Object)3);
        ksession.insert((Object)4);
        ut.commit();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.insert((Object)5);
        ksession.insert((Object)6);
        ut.rollback();
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)list.size());
        ksession = ks.getStoreServices().loadKieSession(Long.valueOf(ksession.getIdentifier()), kbase, null, this.env);
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.insert((Object)7);
        ksession.insert((Object)8);
        ut.commit();
        ksession.fireAllRules();
        Assert.assertEquals((long)6L, (long)list.size());
    }

    @Test
    public void testInterceptor() {
        String str = "";
        str = str + "package org.kie.test\n";
        str = str + "global java.util.List list\n";
        str = str + "rule rule1\n";
        str = str + "when\n";
        str = str + "  Integer(intValue > 0)\n";
        str = str + "then\n";
        str = str + "  list.add( 1 );\n";
        str = str + "end\n";
        str = str + "\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", str);
        ks.newKieBuilder(kfs).buildAll();
        KieBase kbase = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).getKieBase();
        KieSession ksession = ks.getStoreServices().newKieSession(kbase, null, this.env);
        SingleSessionCommandService sscs = (SingleSessionCommandService)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService();
        sscs.addInterceptor((Interceptor)new LoggingInterceptor());
        sscs.addInterceptor((Interceptor)new FireAllRulesInterceptor());
        sscs.addInterceptor((Interceptor)new LoggingInterceptor());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)2);
        ksession.insert((Object)3);
        ksession.getWorkItemManager().completeWorkItem(0L, null);
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testSetFocus() {
        String str = "";
        str = str + "package org.kie.test\n";
        str = str + "global java.util.List list\n";
        str = str + "rule rule1\n";
        str = str + "agenda-group \"badfocus\"";
        str = str + "when\n";
        str = str + "  Integer(intValue > 0)\n";
        str = str + "then\n";
        str = str + "  list.add( 1 );\n";
        str = str + "end\n";
        str = str + "\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", str);
        ks.newKieBuilder(kfs).buildAll();
        KieBase kbase = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).getKieBase();
        KieSession ksession = ks.getStoreServices().newKieSession(kbase, null, this.env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)2);
        ksession.insert((Object)3);
        ksession.getAgenda().getAgendaGroup("badfocus").setFocus();
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testSharedReferences() {
        KieServices ks = KieServices.Factory.get();
        KieBase kbase = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).getKieBase();
        KieSession ksession = ks.getStoreServices().newKieSession(kbase, null, this.env);
        Person x = new Person("test");
        ArrayList<Person> test = new ArrayList<Person>();
        ArrayList<Person> test2 = new ArrayList<Person>();
        test.add(x);
        test2.add(x);
        Assert.assertSame(test.get(0), test2.get(0));
        ksession.insert(test);
        ksession.insert(test2);
        ksession.fireAllRules();
        KieSession ksession2 = ks.getStoreServices().loadKieSession(Long.valueOf(ksession.getIdentifier()), kbase, null, this.env);
        Iterator c = ksession2.getObjects().iterator();
        List ref1 = (List)c.next();
        List ref2 = (List)c.next();
        Assert.assertSame(ref1.get(0), ref2.get(0));
    }

    @Test
    public void testMergeConfig() {
        String str = "";
        str = str + "package org.kie.test\n";
        str = str + "global java.util.List list\n";
        str = str + "rule rule1\n";
        str = str + "when\n";
        str = str + "  $i : Integer(intValue > 0)\n";
        str = str + "then\n";
        str = str + "  list.add( $i );\n";
        str = str + "end\n";
        str = str + "\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", str);
        ks.newKieBuilder(kfs).buildAll();
        KieBase kbase = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).getKieBase();
        Properties properties = new Properties();
        properties.put("drools.processInstanceManagerFactory", "com.example.CustomJPAProcessInstanceManagerFactory");
        KieSessionConfiguration config = ks.newKieSessionConfiguration(properties);
        KieSession ksession = ks.getStoreServices().newKieSession(kbase, config, this.env);
        SessionConfiguration sessionConfig = (SessionConfiguration)ksession.getSessionConfiguration();
        Assert.assertEquals((Object)"com.example.CustomJPAProcessInstanceManagerFactory", (Object)sessionConfig.getProcessInstanceManagerFactory());
    }

    @Test
    public void testMoreComplexRulesSerialization() throws Exception {
        KieServices ks = KieServices.Factory.get();
        Resource drlResource = ks.getResources().newClassPathResource("collect_rules.drl", JpaPersistentStatefulSessionTest.class);
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", drlResource);
        ks.newKieBuilder(kfs).buildAll();
        KieBase kbase = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).getKieBase();
        KieSession ksession = ks.getStoreServices().newKieSession(kbase, null, this.env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactType hereType = kbase.getFactType(this.getClass().getPackage().getName(), "Here");
        Assert.assertNotNull((Object)hereType);
        Object here = hereType.newInstance();
        hereType.set(here, "place", (Object)"office");
        ksession.insert(here);
        ksession.fireAllRules();
    }

    @Test
    public void testTraitsSerialization() throws Exception {
        String drl = "package org.drools.persistence.kie.persistence.session\n\nimport java.util.List\n\nimport org.drools.persistence.kie.persistence.session.JpaPersistentStatefulSessionTest.Door\n\ndeclare trait WoodenDoor\n    from : String\n    to : String\n    wood : String\nend\n\nrule \"wooden door\"\n    no-loop\n    when\n        $door : Door()\n    then\n        WoodenDoor woodenDoor = don( $door, WoodenDoor.class );\nend";
        KieServices ks = KieServices.Factory.get();
        Resource drlResource = ks.getResources().newByteArrayResource(drl.getBytes());
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", drlResource);
        ks.newKieBuilder(kfs).buildAll();
        KieBase kbase = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).getKieBase();
        KieSession ksession = ks.getStoreServices().newKieSession(kbase, null, this.env);
        ksession.insert((Object)new Door());
        ksession.fireAllRules();
    }

    @Test
    public void testGetCount() {
        String str = "";
        str = str + "package org.kie.test\n";
        str = str + "rule rule1\n";
        str = str + "when\n";
        str = str + "then\n";
        str = str + " insertLogical( new String(\"a\") );\n";
        str = str + "end\n";
        str = str + "\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", str);
        ks.newKieBuilder(kfs).buildAll();
        KieBase kbase = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).getKieBase();
        KieSession ksession = ks.getStoreServices().newKieSession(kbase, null, this.env);
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        Assert.assertEquals((long)1L, (long)ksession.getFactCount());
    }

    @Test
    public void testSessionConfigurationFromContainer() {
        String str = "rule R when then end";
        KieServices ks = KieServices.Factory.get();
        KieModuleModel kmodel = ks.newKieModuleModel();
        kmodel.newKieBaseModel("kbase1").newKieSessionModel("ksession1").setClockType(ClockTypeOption.get((String)"pseudo"));
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", str).writeKModuleXML(kmodel.toXML());
        ks.newKieBuilder(kfs).buildAll();
        KieContainer kcontainer = ks.newKieContainer(ks.getRepository().getDefaultReleaseId());
        KieSessionConfiguration conf = kcontainer.getKieSessionConfiguration("ksession1");
        Assert.assertEquals((Object)"pseudo", (Object)((ClockTypeOption)conf.getOption(ClockTypeOption.class)).getClockType());
        KieSession ksession = ks.getStoreServices().newKieSession(kcontainer.getKieBase("kbase1"), conf, this.env);
        Assert.assertTrue((boolean)(ksession.getSessionClock() instanceof SessionPseudoClock));
    }

    @Test
    public void testGetFactHandles() {
        String str = "package org.kie.test\nrule rule1 when\n  String(this == \"A\")\nthen\n  insertLogical( \"B\" );\nend\n\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", str);
        ks.newKieBuilder(kfs).buildAll();
        KieBase kbase = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).getKieBase();
        KieSession ksession = ks.getStoreServices().newKieSession(kbase, null, this.env);
        ksession.insert((Object)"A");
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)ksession.getFactCount());
        for (FactHandle fh : ksession.getFactHandles()) {
            System.out.println(fh);
            if (!fh.toString().contains("String:A")) continue;
            ksession.delete(fh);
        }
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)ksession.getFactCount());
    }

    public static class Edible
    implements Serializable {
        private static final long serialVersionUID = -7102636642802292131L;
        @Position(value=0)
        private String thing;

        public Edible() {
            this(null);
        }

        public Edible(String thing) {
            this.thing = thing;
        }

        public String getThing() {
            return this.thing;
        }

        public void setThing(String thing) {
            this.thing = thing;
        }
    }

    @Traitable
    public static class Door
    implements Serializable {
        private static final long serialVersionUID = 4173662501120948262L;
        @Position(value=0)
        private String fromLocation;
        @Position(value=1)
        private String toLocation;

        public Door() {
            this(null, null);
        }

        public Door(String fromLocation, String toLocation) {
            this.fromLocation = fromLocation;
            this.toLocation = toLocation;
        }

        public String getFromLocation() {
            return this.fromLocation;
        }

        public void setFromLocation(String fromLocation) {
            this.fromLocation = fromLocation;
        }

        public String getToLocation() {
            return this.toLocation;
        }

        public void setToLocation(String toLocation) {
            this.toLocation = toLocation;
        }
    }

    public static class ListHolder
    implements Serializable {
        private static final long serialVersionUID = -3058814255413392428L;
        private List<String> things = new ArrayList<String>();
        private List<String> food = new ArrayList<String>();
        private List<String> exits = new ArrayList<String>();

        ListHolder() {
        }

        public void setThings(List<String> things) {
            this.things = things;
        }

        public List<String> getThings() {
            return this.things;
        }

        public void setFood(List<String> food) {
            this.food = food;
        }

        public List<String> getFood() {
            return this.food;
        }

        public void setExits(List<String> exits) {
            this.exits = exits;
        }

        public List<String> getExits() {
            return this.exits;
        }
    }
}

