/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.jta;

import bitronix.tm.BitronixTransactionManager;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.persistence.jta.JtaTransactionManager;
import org.drools.persistence.jta.JtaTransactionManagerFactory;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.Environment;

public class JtaTransactionManagerFactoryTest {
    private static final UserTransaction DUMMY_UT = new UserTransaction(){

        public void setTransactionTimeout(int arg0) throws SystemException {
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
        }

        public int getStatus() throws SystemException {
            return 0;
        }

        public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        }

        public void begin() throws NotSupportedException, SystemException {
        }

        public boolean equals(Object obj) {
            return this == obj;
        }
    };

    @Test
    public void usesEnvironmentToCreateTransactionManager() throws Exception {
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("org.kie.transaction.Transaction", (Object)DUMMY_UT);
        JtaTransactionManager txm = (JtaTransactionManager)new JtaTransactionManagerFactory().newTransactionManager(env);
        Assert.assertEquals((Object)DUMMY_UT, (Object)txm.ut);
    }

    @Test
    public void createsWithoutEnvironment() throws Exception {
        JtaTransactionManager txm = (JtaTransactionManager)new JtaTransactionManagerFactory().newTransactionManager();
        Assert.assertEquals(BitronixTransactionManager.class, txm.ut.getClass());
    }
}

