/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.session;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.command.impl.ExecutableCommand;
import org.drools.core.command.impl.RegistryContext;
import org.drools.core.common.InternalAgenda;
import org.drools.core.io.impl.ClassPathResource;
import org.drools.core.spi.AgendaGroup;
import org.drools.persistence.util.DroolsPersistenceUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.api.command.Command;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.utils.KieHelper;

@RunWith(value=Parameterized.class)
public class AgendaRuleFlowGroupsTest {
    private Map<String, Object> context;
    private boolean locking = true;

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] locking = new Object[][]{{false}, {true}};
        return Arrays.asList(locking);
    }

    public AgendaRuleFlowGroupsTest(boolean locking) {
    }

    @Before
    public void setUp() throws Exception {
        this.context = DroolsPersistenceUtil.setupWithPoolingDataSource((String)"org.drools.persistence.jpa");
    }

    @After
    public void tearDown() {
        DroolsPersistenceUtil.cleanUp(this.context);
    }

    @Test
    public void testRuleFlowGroupOnly() throws Exception {
        CommandBasedStatefulKnowledgeSession ksession = this.createSession(-1L, "ruleflow-groups.drl");
        AgendaGroup[] groups = ((InternalAgenda)this.stripSession((KieSession)ksession).getAgenda()).getAgendaGroups();
        Assert.assertEquals((long)1L, (long)groups.length);
        Assert.assertEquals((Object)"MAIN", (Object)groups[0].getName());
        long id = ksession.getIdentifier();
        ArrayList<String> list = new ArrayList<String>();
        list.add("Test");
        ksession.insert(list);
        ksession.execute((Command)new ActivateRuleFlowCommand("ruleflow-group"));
        ksession.dispose();
        ksession = this.createSession(id, "ruleflow-groups.drl");
        groups = ((InternalAgenda)this.stripSession((KieSession)ksession).getAgenda()).getAgendaGroups();
        Assert.assertEquals((long)2L, (long)groups.length);
        Assert.assertEquals((Object)"MAIN", (Object)groups[0].getName());
        Assert.assertEquals((Object)"ruleflow-group", (Object)groups[1].getName());
    }

    @Test
    public void testAgendaGroupOnly() throws Exception {
        CommandBasedStatefulKnowledgeSession ksession = this.createSession(-1L, "agenda-groups.drl");
        AgendaGroup[] groups = ((InternalAgenda)this.stripSession((KieSession)ksession).getAgenda()).getAgendaGroups();
        Assert.assertEquals((long)1L, (long)groups.length);
        Assert.assertEquals((Object)"MAIN", (Object)groups[0].getName());
        long id = ksession.getIdentifier();
        ArrayList<String> list = new ArrayList<String>();
        list.add("Test");
        ksession.insert(list);
        ksession.execute((Command)new ActivateAgendaGroupCommand("agenda-group"));
        ksession.dispose();
        ksession = this.createSession(id, "agenda-groups.drl");
        groups = ((InternalAgenda)this.stripSession((KieSession)ksession).getAgenda()).getAgendaGroups();
        Assert.assertEquals((long)2L, (long)groups.length);
        Assert.assertEquals((Object)"MAIN", (Object)groups[0].getName());
        Assert.assertEquals((Object)"agenda-group", (Object)groups[1].getName());
    }

    @Test
    public void testAgendaGroupAndRuleFlowGroup() throws Exception {
        CommandBasedStatefulKnowledgeSession ksession = this.createSession(-1L, "agenda-groups.drl", "ruleflow-groups.drl");
        AgendaGroup[] groups = ((InternalAgenda)this.stripSession((KieSession)ksession).getAgenda()).getAgendaGroups();
        Assert.assertEquals((long)1L, (long)groups.length);
        Assert.assertEquals((Object)"MAIN", (Object)groups[0].getName());
        long id = ksession.getIdentifier();
        ArrayList<String> list = new ArrayList<String>();
        list.add("Test");
        ksession.insert(list);
        ksession.execute((Command)new ActivateAgendaGroupCommand("agenda-group"));
        ksession.execute((Command)new ActivateRuleFlowCommand("ruleflow-group"));
        ksession.dispose();
        ksession = this.createSession(id, "agenda-groups.drl", "ruleflow-groups.drl");
        groups = ((InternalAgenda)this.stripSession((KieSession)ksession).getAgenda()).getAgendaGroups();
        Assert.assertEquals((long)3L, (long)groups.length);
        Assert.assertEquals((Object)"MAIN", (Object)groups[0].getName());
        Assert.assertEquals((Object)"ruleflow-group", (Object)groups[1].getName());
        Assert.assertEquals((Object)"agenda-group", (Object)groups[2].getName());
    }

    private KieSession stripSession(KieSession ksession) {
        if (ksession instanceof CommandBasedStatefulKnowledgeSession) {
            return (KieSession)((RegistryContext)((CommandBasedStatefulKnowledgeSession)ksession).getRunner().createContext()).lookup(KieSession.class);
        }
        return ksession;
    }

    private CommandBasedStatefulKnowledgeSession createSession(long id, String ... rules) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        for (String rule : rules) {
            kbuilder.add((Resource)new ClassPathResource(rule), ResourceType.DRL);
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        Environment env = DroolsPersistenceUtil.createEnvironment(this.context);
        if (this.locking) {
            env.set("org.kie.api.persistence.pessimistic", (Object)true);
        }
        if (id == -1L) {
            return (CommandBasedStatefulKnowledgeSession)JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)env);
        }
        return (CommandBasedStatefulKnowledgeSession)JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)env);
    }

    @Test
    public void testConflictingAgendaAndRuleflowGroups() throws Exception {
        String drl = "package org.drools.test; rule Test   agenda-group 'ag'   ruleflow-group 'rf' when then end ";
        KieHelper helper = new KieHelper();
        helper.addContent(drl, ResourceType.DRL);
        Results res = helper.verify();
        System.err.println(res.getMessages());
        Assert.assertEquals((long)1L, (long)res.getMessages(new Message.Level[]{Message.Level.WARNING}).size());
        Assert.assertEquals((long)0L, (long)res.getMessages(new Message.Level[]{Message.Level.ERROR}).size());
    }

    public class ExceptionCommand
    implements ExecutableCommand<Object> {
        public Void execute(Context context) {
            throw new RuntimeException();
        }
    }

    public class ActivateAgendaGroupCommand
    implements ExecutableCommand<Object> {
        private String agendaGroupName;

        public ActivateAgendaGroupCommand(String agendaGroupName) {
            this.agendaGroupName = agendaGroupName;
        }

        public Void execute(Context context) {
            KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
            ((InternalAgenda)ksession.getAgenda()).getAgendaGroup(this.agendaGroupName).setFocus();
            return null;
        }
    }

    public class ActivateRuleFlowCommand
    implements ExecutableCommand<Object> {
        private String ruleFlowGroupName;

        public ActivateRuleFlowCommand(String ruleFlowGroupName) {
            this.ruleFlowGroupName = ruleFlowGroupName;
        }

        public Void execute(Context context) {
            KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
            ((InternalAgenda)ksession.getAgenda()).activateRuleFlowGroup(this.ruleFlowGroupName);
            return null;
        }
    }
}

