/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.session;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.drools.compiler.Address;
import org.drools.compiler.Person;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.command.impl.FireAllRulesInterceptor;
import org.drools.core.command.impl.LoggingInterceptor;
import org.drools.core.runtime.ChainableRunner;
import org.drools.persistence.PersistableRunner;
import org.drools.persistence.util.DroolsPersistenceUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.command.CommandFactory;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.utils.KieHelper;

@RunWith(value=Parameterized.class)
public class JpaPersistentStatefulSessionWithOOPathTest {
    private static final boolean PESSIMISTIC_LOCKING = true;
    private static final boolean OPTIMISTIC_LOCKING = false;
    private static final boolean WITH_OOPATH = true;
    private static final boolean NO_OOPATH = false;
    private Map<String, Object> context;
    private Environment env;
    private final boolean locking;
    private final boolean oopath;

    public JpaPersistentStatefulSessionWithOOPathTest(boolean locking, boolean oopath) {
        this.locking = locking;
        this.oopath = oopath;
    }

    @Parameterized.Parameters(name="pessimistic-locking={0}, with-oopath={1}")
    public static Collection<Object[]> persistence() {
        Object[][] params = new Object[][]{{false, false}, {false, true}, {true, false}, {true, true}};
        return Arrays.asList(params);
    }

    @Before
    public void setUp() throws Exception {
        this.context = DroolsPersistenceUtil.setupWithPoolingDataSource((String)"org.drools.persistence.jpa");
        this.env = DroolsPersistenceUtil.createEnvironment(this.context);
        if (this.locking) {
            this.env.set("org.kie.api.persistence.pessimistic", (Object)true);
        }
    }

    @After
    public void tearDown() throws Exception {
        DroolsPersistenceUtil.cleanUp(this.context);
    }

    @Test
    public void testFactHandleSerialization() {
        String str = "package org.kie.test\nimport java.util.concurrent.atomic.AtomicInteger\nglobal java.util.List list\nrule rule1\nwhen\n" + (this.oopath ? " AtomicInteger($i: /intValue{this > 0})\n" : " $i: AtomicInteger(intValue > 0)\n") + "then\n list.add( $i );\nend\n";
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = KieServices.get().getStoreServices().newKieSession(kbase, null, this.env);
        List list = new ArrayList();
        ksession.setGlobal("list", list);
        AtomicInteger value = new AtomicInteger(4);
        FactHandle atomicFH = ksession.insert((Object)value);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        value.addAndGet(1);
        ksession.update(atomicFH, (Object)value);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        String externalForm = atomicFH.toExternalForm();
        ksession = KieServices.get().getStoreServices().loadKieSession(Long.valueOf(ksession.getIdentifier()), kbase, null, this.env);
        atomicFH = (FactHandle)ksession.execute(CommandFactory.fromExternalFactHandleCommand((String)externalForm));
        value.addAndGet(1);
        ksession.update(atomicFH, (Object)value);
        ksession.fireAllRules();
        list = (List)ksession.getGlobal("list");
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testLocalTransactionPerStatement() {
        String str = this.getSimpleRule();
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = KieServices.get().getStoreServices().newKieSession(kbase, null, this.env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)2);
        ksession.insert((Object)3);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testUserTransactions() throws Exception {
        String str = "package org.kie.test\nglobal java.util.List list\nrule rule1\nwhen\n" + (this.oopath ? " $i: Integer( /intValue{this > 0})\n" : " $i : Integer(intValue > 0)\n") + "then\n list.add( $i );\nend\n";
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        KieSession ksession = KieServices.get().getStoreServices().newKieSession(kbase, null, this.env);
        ut.commit();
        ArrayList list = new ArrayList();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)2);
        ksession.fireAllRules();
        ut.commit();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.insert((Object)3);
        ut.rollback();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.fireAllRules();
        ut.commit();
        Assert.assertEquals((long)2L, (long)list.size());
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.insert((Object)3);
        ksession.insert((Object)4);
        ut.commit();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.insert((Object)5);
        ksession.insert((Object)6);
        ut.rollback();
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)list.size());
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)ksession.getIdentifier(), (KieBase)kbase, null, (Environment)this.env);
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.insert((Object)7);
        ksession.insert((Object)8);
        ut.commit();
        ksession.fireAllRules();
        Assert.assertEquals((long)6L, (long)list.size());
    }

    @Test
    public void testInterceptor() {
        String str = this.getSimpleRule();
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = KieServices.get().getStoreServices().newKieSession(kbase, null, this.env);
        PersistableRunner sscs = (PersistableRunner)((CommandBasedStatefulKnowledgeSession)ksession).getRunner();
        sscs.addInterceptor((ChainableRunner)new LoggingInterceptor());
        sscs.addInterceptor((ChainableRunner)new FireAllRulesInterceptor());
        sscs.addInterceptor((ChainableRunner)new LoggingInterceptor());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)2);
        ksession.insert((Object)3);
        ksession.getWorkItemManager().completeWorkItem(0L, null);
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testInterceptorOnRollback() throws Exception {
        String str = this.getSimpleRule();
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = KieServices.get().getStoreServices().newKieSession(kbase, null, this.env);
        PersistableRunner sscs = (PersistableRunner)((CommandBasedStatefulKnowledgeSession)ksession).getRunner();
        sscs.addInterceptor((ChainableRunner)new LoggingInterceptor());
        sscs.addInterceptor((ChainableRunner)new FireAllRulesInterceptor());
        sscs.addInterceptor((ChainableRunner)new LoggingInterceptor());
        ChainableRunner runner = sscs.getChainableRunner();
        Assert.assertEquals(LoggingInterceptor.class, runner.getClass());
        runner = (ChainableRunner)runner.getNext();
        Assert.assertEquals(FireAllRulesInterceptor.class, runner.getClass());
        runner = (ChainableRunner)runner.getNext();
        Assert.assertEquals(LoggingInterceptor.class, runner.getClass());
        UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        ut.begin();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ut.rollback();
        ksession.insert((Object)3);
        runner = sscs.getChainableRunner();
        Assert.assertEquals(LoggingInterceptor.class, runner.getClass());
        runner = (ChainableRunner)runner.getNext();
        Assert.assertEquals(FireAllRulesInterceptor.class, runner.getClass());
        runner = (ChainableRunner)runner.getNext();
        Assert.assertEquals(LoggingInterceptor.class, runner.getClass());
    }

    @Test
    public void testSetFocus() {
        String str = this.oopath ? "package org.kie.test\nglobal java.util.List list\nrule rule1\nagenda-group \"badfocus\"when\n  Integer(/intValue{this > 0})\nthen\n  list.add( 1 );\nend\n" : "package org.kie.test\nglobal java.util.List list\nrule rule1\nagenda-group \"badfocus\"when\n  Integer(intValue > 0)\nthen\n  list.add( 1 );\nend\n";
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = KieServices.get().getStoreServices().newKieSession(kbase, null, this.env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)2);
        ksession.insert((Object)3);
        ksession.getAgenda().getAgendaGroup("badfocus").setFocus();
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testCreateAndDestroySession() {
        String str = this.getSimpleRule();
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = KieServices.get().getStoreServices().newKieSession(kbase, null, this.env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)2);
        ksession.insert((Object)3);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        long ksessionId = ksession.getIdentifier();
        ksession.destroy();
        try {
            JPAKnowledgeService.loadStatefulKnowledgeSession((Long)ksessionId, (KieBase)kbase, null, (Environment)this.env);
            Assert.fail((String)("There should not be any session with id " + ksessionId));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCreateAndDestroyNonPersistentSession() {
        String str = this.getSimpleRule();
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)2);
        ksession.insert((Object)3);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        long ksessionId = ksession.getIdentifier();
        ksession.destroy();
        try {
            ksession.fireAllRules();
            Assert.fail((String)("Session should already be disposed " + ksessionId));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testFromNodeWithModifiedCollection() {
        String str = this.oopath ? "package org.drools.test\nimport org.drools.compiler.Person\nimport org.drools.compiler.Address\nrule rule1\nwhen\n $p: Person($list : addresses, /addresses{street == \"y\"})\nthen\n $list.add( new Address(\"z\") );\n $list.add( new Address(\"w\") );\nend\n" : "package org.drools.test\nimport org.drools.compiler.Person\nimport org.drools.compiler.Address\nrule rule1\nwhen\n $p: Person($list : addresses)\n $a: Address(street == \"y\") from $list\nthen\n $list.add( new Address(\"z\") );\n $list.add( new Address(\"w\") );\nend\n";
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = KieServices.get().getStoreServices().newKieSession(kbase, null, this.env);
        long sessionId = ksession.getIdentifier();
        Person p1 = new Person("John");
        p1.addAddress(new Address("x"));
        p1.addAddress(new Address("y"));
        ksession.insert((Object)p1);
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)p1.getAddresses().size());
        ksession.dispose();
        KieServices.get().getStoreServices().loadKieSession(Long.valueOf(sessionId), kbase, null, this.env);
    }

    private String getSimpleRule() {
        if (this.oopath) {
            return "package org.kie.test\nglobal java.util.List list\nrule rule1\nwhen\n  Integer(/intValue{this > 0})\nthen\n  list.add( 1 );\nend\n\n";
        }
        return "package org.kie.test\nglobal java.util.List list\nrule rule1\nwhen\n  Integer(intValue > 0)\nthen\n  list.add( 1 );\nend\n";
    }
}

