/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.map.impl;

import java.util.HashMap;
import java.util.Map;
import org.drools.persistence.api.PersistentSession;
import org.drools.persistence.api.PersistentWorkItem;
import org.drools.persistence.map.KnowledgeSessionStorage;
import org.drools.persistence.map.KnowledgeSessionStorageEnvironmentBuilder;
import org.drools.persistence.map.impl.MapPersistenceTest;
import org.junit.Before;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.runtime.Environment;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class MapBasedPersistenceTest
extends MapPersistenceTest {
    private SimpleKnowledgeSessionStorage storage;

    @Before
    public void createStorage() {
        this.storage = new SimpleKnowledgeSessionStorage();
    }

    @Override
    protected StatefulKnowledgeSession createSession(KnowledgeBase kbase) {
        KnowledgeSessionStorageEnvironmentBuilder envBuilder = new KnowledgeSessionStorageEnvironmentBuilder((KnowledgeSessionStorage)this.storage);
        Environment env = KieServices.Factory.get().newEnvironment();
        env.set("org.kie.transaction.TransactionManager", (Object)envBuilder.getTransactionManager());
        env.set("org.kie.api.persistence.PersistenceContextManager", (Object)envBuilder.getPersistenceContextManager());
        return JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)env);
    }

    @Override
    protected StatefulKnowledgeSession disposeAndReloadSession(StatefulKnowledgeSession ksession, KnowledgeBase kbase) {
        long sessionId = ksession.getIdentifier();
        ksession.dispose();
        KnowledgeSessionStorageEnvironmentBuilder envBuilder = new KnowledgeSessionStorageEnvironmentBuilder((KnowledgeSessionStorage)this.storage);
        Environment env = KieServices.Factory.get().newEnvironment();
        env.set("org.kie.transaction.TransactionManager", (Object)envBuilder.getTransactionManager());
        env.set("org.kie.api.persistence.PersistenceContextManager", (Object)envBuilder.getPersistenceContextManager());
        return JPAKnowledgeService.loadStatefulKnowledgeSession((Long)sessionId, (KieBase)kbase, null, (Environment)env);
    }

    @Override
    protected long getSavedSessionsCount() {
        return this.storage.ksessions.size();
    }

    private static class SimpleKnowledgeSessionStorage
    implements KnowledgeSessionStorage {
        public Map<Long, PersistentSession> ksessions = new HashMap<Long, PersistentSession>();
        public Map<Long, PersistentWorkItem> workItems = new HashMap<Long, PersistentWorkItem>();

        private SimpleKnowledgeSessionStorage() {
        }

        public PersistentSession findSessionInfo(Long id) {
            return this.ksessions.get(id);
        }

        public void saveOrUpdate(PersistentSession storedObject) {
            this.ksessions.put(storedObject.getId(), storedObject);
        }

        public void saveOrUpdate(PersistentWorkItem workItem) {
            this.workItems.put(workItem.getId(), workItem);
        }

        public Long getNextWorkItemId() {
            return new Long(this.workItems.size() + 1);
        }

        public PersistentWorkItem findWorkItemInfo(Long id) {
            return this.workItems.get(id);
        }

        public void remove(PersistentWorkItem workItem) {
            this.workItems.remove(workItem.getId());
        }

        public Long getNextStatefulKnowledgeSessionId() {
            return new Long(this.ksessions.size() + 1);
        }

        public void lock(PersistentSession session) {
            throw new UnsupportedOperationException("Map based persistence does not support locking.");
        }

        public void lock(PersistentWorkItem workItem) {
            throw new UnsupportedOperationException("Map based persistence does not support locking.");
        }
    }
}

