/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.marshalling.util;

import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Table;
import org.drools.persistence.marshalling.util.MarshalledData;
import org.drools.persistence.util.DroolsPersistenceUtil;
import org.junit.Assert;

public class MarshallingDBUtil {
    protected static String MARSHALLING_TEST_DB = "testData";
    protected static final String MARSHALLING_BASE_DB = "baseData-current";
    protected static boolean clearMarshallingTestDb = true;

    public static String initializeTestDb(Properties jdbcProps, Class<?> testClass) {
        String makeBaseDb = jdbcProps.getProperty("makeBaseDb");
        if ("true".equals(makeBaseDb)) {
            MARSHALLING_TEST_DB = MARSHALLING_BASE_DB;
            clearMarshallingTestDb = false;
        }
        String dbPath = MarshallingDBUtil.generatePathToTestDb(testClass);
        if (clearMarshallingTestDb) {
            clearMarshallingTestDb = false;
            URL dbUrl = Object.class.getResource("/" + MARSHALLING_TEST_DB + ".h2.db");
            MarshallingDBUtil.deleteTestDatabase(dbUrl, dbPath);
            MarshallingDBUtil.createMarshallingTestDatabase(dbPath, jdbcProps.getProperty("driverClassName"));
        }
        String jdbcURLBase = jdbcProps.getProperty("url");
        return jdbcURLBase + dbPath;
    }

    protected static String generatePathToTestDb(Class<?> testClass) {
        URL classUrl = testClass.getResource(testClass.getSimpleName() + ".class");
        String projectPath = classUrl.getPath().replaceFirst("target.*", "");
        String resourcesPath = projectPath + "target/test-classes/marshalling/";
        new File(resourcesPath).mkdirs();
        String dbPath = resourcesPath + MARSHALLING_TEST_DB;
        return dbPath;
    }

    private static void deleteTestDatabase(URL dbUrl, String dbPath) {
        if (dbUrl != null) {
            new File(dbUrl.getPath()).delete();
        }
        new File(dbPath + ".h2.db").delete();
    }

    private static void createMarshallingTestDatabase(String dbPath, String driverClass) {
        try {
            Class.forName(driverClass);
            Connection conn = DriverManager.getConnection("jdbc:h2:" + dbPath);
            conn.setAutoCommit(true);
            Statement stat = conn.createStatement();
            String dropTableQuery = "drop table if exists " + MarshallingDBUtil.getTableName(MarshalledData.class);
            stat.executeUpdate(dropTableQuery);
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Unable to create marshalling database: " + dbPath));
        }
    }

    private static String getTableName(Class<?> dataClass) {
        String tableName = null;
        Annotation[] anno = dataClass.getDeclaredAnnotations();
        for (int i = 0; i < anno.length; ++i) {
            int a;
            Class<? extends Annotation> annoClass = anno[i].annotationType();
            if (!annoClass.equals(Table.class)) continue;
            Method[] annoMethod = annoClass.getMethods();
            for (a = 0; a < annoMethod.length && !annoMethod[a].getName().equals("name"); ++a) {
            }
            try {
                tableName = (String)annoMethod[a].invoke((Object)anno[i], new Object[0]);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Unable to generate HQL query - could not get table name: " + e.getMessage()));
            }
        }
        if (tableName == null) {
            tableName = dataClass.getName();
            tableName = tableName.substring(tableName.lastIndexOf(46) + 1).toLowerCase();
        }
        return tableName;
    }

    public static HashMap<String, Object> initializeMarshalledDataEMF(String persistenceUnitName, Class<?> testClass, boolean useBaseDb) {
        return MarshallingDBUtil.initializeMarshalledDataEMF(persistenceUnitName, testClass, useBaseDb, null);
    }

    public static HashMap<String, Object> initializeMarshalledDataEMF(String persistenceUnitName, Class<?> testClass, boolean useBaseDb, String baseDbVer) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        Properties dsProps = DroolsPersistenceUtil.getDatasourceProperties();
        String driverClass = dsProps.getProperty("driverClassName");
        if (!driverClass.startsWith("org.h2")) {
            return null;
        }
        String dbFilePath = MarshallingDBUtil.generatePathToTestDb(testClass);
        if (useBaseDb) {
            dbFilePath = dbFilePath.replace(MARSHALLING_TEST_DB, MARSHALLING_BASE_DB);
            if (baseDbVer != null && baseDbVer.length() > 0) {
                dbFilePath = dbFilePath.replace("current", baseDbVer);
            }
        }
        String jdbcURLBase = dsProps.getProperty("url");
        String jdbcUrl = jdbcURLBase + dbFilePath;
        PoolingDataSource ds1 = DroolsPersistenceUtil.setupPoolingDataSource((Properties)dsProps);
        ds1.getDriverProperties().setProperty("url", jdbcUrl);
        ds1.init();
        context.put(DroolsPersistenceUtil.DATASOURCE, ds1);
        Properties overrideProperties = new Properties();
        overrideProperties.setProperty("hibernate.connection.url", jdbcUrl);
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)persistenceUnitName, (Map)overrideProperties);
        context.put("org.kie.api.persistence.jpa.EntityManagerFactory", emf);
        return context;
    }

    protected static String[] getListOfBaseDbVers(Class<?> testClass) {
        ArrayList<String> versionList = new ArrayList<String>();
        String path = MarshallingDBUtil.generatePathToTestDb(testClass);
        path = path.replace("target" + File.separatorChar + "test-classes" + File.separatorChar + "marshalling" + File.separatorChar + "testData", "src" + File.separatorChar + "test" + File.separatorChar + "resources" + File.separatorChar + "marshalling" + File.separatorChar);
        File marshallingDir = new File(path);
        FilenameFilter baseDatafilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("baseData");
            }
        };
        String[] dbFiles = marshallingDir.list(baseDatafilter);
        Assert.assertTrue((String)("No files found in marshalling directory [" + marshallingDir + "]!"), (dbFiles != null && dbFiles.length > 0 ? 1 : 0) != 0);
        for (int i = 0; i < dbFiles.length; ++i) {
            String ver = dbFiles[i];
            ver = ver.replace(".h2.db", "");
            ver = ver.replace("baseData", "");
            ver = ver.replace("-", "");
            versionList.add(ver);
        }
        String[] versions = new String[versionList.size()];
        for (int v = 0; v < versions.length; ++v) {
            versions[v] = (String)versionList.get(v);
        }
        return versions;
    }
}

