/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.map.impl;

import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.io.impl.ByteArrayResource;
import org.drools.persistence.jpa.marshaller.JPAPlaceholderResolverStrategy;
import org.drools.persistence.map.impl.Buddy;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderErrors;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MapPersistenceTest {
    private static Logger logger = LoggerFactory.getLogger(JPAPlaceholderResolverStrategy.class);

    @Test
    public void createPersistentSession() {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KieSession crmPersistentSession = this.createSession((KieBase)kbase);
        crmPersistentSession.fireAllRules();
        crmPersistentSession = this.createSession((KieBase)kbase);
        Assert.assertNotNull((Object)crmPersistentSession);
    }

    @Test
    public void createPersistentSessionWithRules() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        String rule = "package org.drools.persistence.map.impl\n";
        rule = rule + "import org.drools.persistence.map.impl.Buddy;\n";
        rule = rule + "rule \"echo2\" \n";
        rule = rule + "dialect \"mvel\"\n";
        rule = rule + "when\n";
        rule = rule + "    $m : Buddy()\n";
        rule = rule + "then\n";
        rule = rule + "    System.out.println(\"buddy inserted\")";
        rule = rule + "end\n";
        kbuilder.add((Resource)new ByteArrayResource(rule.getBytes()), ResourceType.DRL);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (errors != null && errors.size() > 0) {
            for (KnowledgeBuilderError error : errors) {
                logger.warn("Error: " + error.getMessage());
            }
            Assert.fail((String)"KnowledgeBase did not build");
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession ksession = this.createSession((KieBase)kbase);
        FactHandle buddyFactHandle = ksession.insert((Object)new Buddy());
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)ksession.getObjects().size());
        ksession = this.disposeAndReloadSession(ksession, (KieBase)kbase);
        Assert.assertNotNull((Object)ksession);
        Assert.assertEquals((long)1L, (long)ksession.getObjects().size());
        Assert.assertNull((String)"An object can't be retrieved with a FactHandle from a disposed session", (Object)ksession.getObject(buddyFactHandle));
    }

    @Test
    public void dontCreateMoreSessionsThanNecessary() {
        long initialNumberOfSavedSessions = this.getSavedSessionsCount();
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KieSession crmPersistentSession = this.createSession((KieBase)kbase);
        long ksessionId = crmPersistentSession.getIdentifier();
        crmPersistentSession.fireAllRules();
        crmPersistentSession = this.disposeAndReloadSession(crmPersistentSession, (KieBase)kbase);
        Assert.assertEquals((long)ksessionId, (long)crmPersistentSession.getIdentifier());
        ksessionId = crmPersistentSession.getIdentifier();
        crmPersistentSession.fireAllRules();
        crmPersistentSession = this.disposeAndReloadSession(crmPersistentSession, (KieBase)kbase);
        crmPersistentSession.fireAllRules();
        Assert.assertEquals((long)(initialNumberOfSavedSessions + 1L), (long)this.getSavedSessionsCount());
        crmPersistentSession.dispose();
    }

    @Test
    public void insertObjectIntoKsessionAndRetrieve() {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KieSession crmPersistentSession = this.createSession((KieBase)kbase);
        Buddy bestBuddy = new Buddy("john");
        crmPersistentSession.insert((Object)bestBuddy);
        crmPersistentSession = this.disposeAndReloadSession(crmPersistentSession, (KieBase)kbase);
        Object obtainedBuddy = crmPersistentSession.getObjects().iterator().next();
        Assert.assertNotSame((Object)bestBuddy, obtainedBuddy);
        Assert.assertEquals((Object)bestBuddy, obtainedBuddy);
        crmPersistentSession.dispose();
    }

    protected abstract KieSession createSession(KieBase var1);

    protected abstract KieSession disposeAndReloadSession(KieSession var1, KieBase var2);

    protected abstract long getSavedSessionsCount();
}

