/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.session;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.runtime.ChainableRunner;
import org.drools.persistence.PersistableRunner;
import org.drools.persistence.jpa.OptimisticLockRetryInterceptor;
import org.drools.persistence.util.DroolsPersistenceUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.event.rule.DefaultRuleRuntimeEventListener;
import org.kie.api.event.rule.ObjectInsertedEvent;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaOptLockPersistentStatefulSessionTest {
    private static Logger logger = LoggerFactory.getLogger(JpaOptLockPersistentStatefulSessionTest.class);
    private Map<String, Object> context;
    private Environment env;
    private static CountDownLatch ksession1latch = new CountDownLatch(1);
    private static CountDownLatch ksession2latch = new CountDownLatch(1);
    private static volatile boolean isKsession1finished = false;

    @Before
    public void setUp() throws Exception {
        this.context = DroolsPersistenceUtil.setupWithPoolingDataSource((String)"org.drools.persistence.jpa");
        this.env = DroolsPersistenceUtil.createEnvironment(this.context);
    }

    @After
    public void tearDown() throws Exception {
        DroolsPersistenceUtil.cleanUp(this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOptimisticLockInterceptorMaxRetry() {
        String str = "";
        str = str + "package org.kie.test\n";
        str = str + "rule rule1\n";
        str = str + "when\n";
        str = str + "  Integer(intValue == 1)\n";
        str = str + "then\n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        kbase.addPackages(kbuilder.getKnowledgePackages());
        final AtomicInteger attempts = new AtomicInteger(0);
        StatefulKnowledgeSession ksession1 = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)this.env);
        PersistableRunner sscs1 = (PersistableRunner)((CommandBasedStatefulKnowledgeSession)ksession1).getRunner();
        OptimisticLockRetryInterceptor interceptor1 = new OptimisticLockRetryInterceptor();
        sscs1.addInterceptor((ChainableRunner)interceptor1);
        ksession1.addEventListener((RuleRuntimeEventListener)new DefaultRuleRuntimeEventListener(){

            public void objectInserted(ObjectInsertedEvent event) {
                attempts.incrementAndGet();
                try {
                    ksession1latch = new CountDownLatch(1);
                    ksession2latch.countDown();
                    ksession1latch.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        long ksessionId = ksession1.getIdentifier();
        StatefulKnowledgeSession ksession2 = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)ksessionId, (KieBase)kbase, null, (Environment)DroolsPersistenceUtil.createEnvironment(this.context));
        PersistableRunner sscs2 = (PersistableRunner)((CommandBasedStatefulKnowledgeSession)ksession2).getRunner();
        OptimisticLockRetryInterceptor interceptor2 = new OptimisticLockRetryInterceptor();
        sscs2.addInterceptor((ChainableRunner)interceptor2);
        ExecutorService executor = Executors.newFixedThreadPool(1);
        executor.execute(() -> {
            try {
                ksession1.insert((Object)1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                ksession1.dispose();
                isKsession1finished = true;
                ksession2latch.countDown();
            }
        });
        try {
            while (!isKsession1finished) {
                try {
                    ksession2latch.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ksession2latch = new CountDownLatch(1);
                ksession2.insert((Object)2);
                ksession1latch.countDown();
            }
        }
        finally {
            ksession2.dispose();
            executor.shutdown();
        }
        try {
            executor.awaitTermination(300L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Assert.assertEquals((long)4L, (long)attempts.get());
    }
}

