/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.session;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.assertj.core.api.Assertions;
import org.drools.core.SessionConfiguration;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.command.impl.FireAllRulesInterceptor;
import org.drools.core.command.impl.LoggingInterceptor;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.core.runtime.ChainableRunner;
import org.drools.mvel.compiler.Address;
import org.drools.mvel.compiler.Person;
import org.drools.persistence.PersistableRunner;
import org.drools.persistence.util.DroolsPersistenceUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.command.CommandFactory;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.internal.utils.KieHelper;

@RunWith(value=Parameterized.class)
public class JpaPersistentStatefulSessionTest {
    private Map<String, Object> context;
    private Environment env;
    private final boolean locking;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> persistence() {
        Object[][] locking = new Object[][]{{DroolsPersistenceUtil.OPTIMISTIC_LOCKING}, {DroolsPersistenceUtil.PESSIMISTIC_LOCKING}};
        return Arrays.asList(locking);
    }

    public JpaPersistentStatefulSessionTest(String locking) {
        this.locking = DroolsPersistenceUtil.PESSIMISTIC_LOCKING.equals(locking);
    }

    @Before
    public void setUp() throws Exception {
        this.context = DroolsPersistenceUtil.setupWithPoolingDataSource((String)"org.drools.persistence.jpa");
        this.env = DroolsPersistenceUtil.createEnvironment(this.context);
        if (this.locking) {
            this.env.set("org.kie.api.persistence.pessimistic", (Object)true);
        }
    }

    @After
    public void tearDown() throws Exception {
        DroolsPersistenceUtil.cleanUp(this.context);
    }

    @Test
    public void testFactHandleSerialization() {
        this.factHandleSerialization(false);
    }

    @Test
    public void testFactHandleSerializationWithOOPath() {
        this.factHandleSerialization(true);
    }

    private void factHandleSerialization(boolean withOOPath) {
        String str = "package org.kie.test\nimport java.util.concurrent.atomic.AtomicInteger\nglobal java.util.List list\nrule rule1\nwhen\n" + (withOOPath ? " AtomicInteger($i: /intValue[this > 0])\n" : " $i: AtomicInteger(intValue > 0)\n") + "then\n list.add( $i );\nend\n\n";
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = kbase.newKieSession();
        List list = new ArrayList();
        ksession.setGlobal("list", list);
        AtomicInteger value = new AtomicInteger(4);
        FactHandle atomicFH = ksession.insert((Object)value);
        ksession.fireAllRules();
        Assertions.assertThat(list).hasSize(1);
        value.addAndGet(1);
        ksession.update(atomicFH, (Object)value);
        ksession.fireAllRules();
        Assertions.assertThat(list).hasSize(2);
        String externalForm = atomicFH.toExternalForm();
        atomicFH = (FactHandle)ksession.execute(CommandFactory.fromExternalFactHandleCommand((String)externalForm));
        value.addAndGet(1);
        ksession.update(atomicFH, (Object)value);
        ksession.fireAllRules();
        list = (List)ksession.getGlobal("list");
        Assertions.assertThat(list).hasSize(3);
    }

    @Test
    public void testLocalTransactionPerStatement() {
        this.localTransactionPerStatement(false);
    }

    @Test
    public void testLocalTransactionPerStatementWithOOPath() {
        this.localTransactionPerStatement(true);
    }

    private void localTransactionPerStatement(boolean withOOPath) {
        String rule = this.getSimpleRule(withOOPath);
        KieBase kbase = new KieHelper().addContent(rule, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = KieServices.get().getStoreServices().newKieSession(kbase, null, this.env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        this.insertIntRange(ksession, 1, 3);
        ksession.fireAllRules();
        Assertions.assertThat(list).hasSize(3);
    }

    @Test
    public void testUserTransactions() throws Exception {
        this.userTransactions(false);
    }

    @Test
    public void testUserTransactionsWithOOPath() throws Exception {
        this.userTransactions(true);
    }

    private void userTransactions(boolean withOOPath) throws Exception {
        String str = "package org.kie.test\nglobal java.util.List list\nrule rule1\nwhen\n" + (withOOPath ? " $i: Integer( /intValue[this > 0])\n" : " $i : Integer(intValue > 0)\n") + "then\n list.add( $i );\nend\n";
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        KieSession ksession = KieServices.get().getStoreServices().newKieSession(kbase, null, this.env);
        ut.commit();
        ArrayList list = new ArrayList();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.setGlobal("list", list);
        this.insertIntRange(ksession, 1, 2);
        ksession.fireAllRules();
        ut.commit();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.insert((Object)3);
        ut.rollback();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.fireAllRules();
        ut.commit();
        Assertions.assertThat(list).hasSize(2);
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        this.insertIntRange(ksession, 3, 4);
        ut.commit();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        this.insertIntRange(ksession, 5, 6);
        ut.rollback();
        ksession.fireAllRules();
        Assertions.assertThat(list).hasSize(4);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)ksession.getIdentifier(), (KieBase)kbase, null, (Environment)this.env);
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        this.insertIntRange(ksession, 7, 8);
        ut.commit();
        ksession.fireAllRules();
        Assertions.assertThat(list).hasSize(6);
    }

    @Test
    public void testInterceptor() {
        this.interceptor(false);
    }

    @Test
    public void testInterceptorWithOOPath() {
        this.interceptor(true);
    }

    private void interceptor(boolean withOOPath) {
        String str = this.getSimpleRule(withOOPath);
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = KieServices.get().getStoreServices().newKieSession(kbase, null, this.env);
        PersistableRunner sscs = (PersistableRunner)((CommandBasedStatefulKnowledgeSession)ksession).getRunner();
        sscs.addInterceptor((ChainableRunner)new LoggingInterceptor());
        sscs.addInterceptor((ChainableRunner)new FireAllRulesInterceptor());
        sscs.addInterceptor((ChainableRunner)new LoggingInterceptor());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        this.insertIntRange(ksession, 1, 3);
        ksession.getWorkItemManager().completeWorkItem(0L, null);
        Assertions.assertThat(list).hasSize(3);
    }

    @Test
    public void testInterceptorOnRollback() throws Exception {
        this.interceptorOnRollback(false);
    }

    @Test
    public void testInterceptorOnRollbackWithOOPAth() throws Exception {
        this.interceptorOnRollback(true);
    }

    private void interceptorOnRollback(boolean withOOPath) throws Exception {
        String str = this.getSimpleRule(withOOPath);
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = KieServices.get().getStoreServices().newKieSession(kbase, null, this.env);
        PersistableRunner sscs = (PersistableRunner)((CommandBasedStatefulKnowledgeSession)ksession).getRunner();
        sscs.addInterceptor((ChainableRunner)new LoggingInterceptor());
        sscs.addInterceptor((ChainableRunner)new FireAllRulesInterceptor());
        sscs.addInterceptor((ChainableRunner)new LoggingInterceptor());
        ChainableRunner runner = sscs.getChainableRunner();
        Assertions.assertThat(runner.getClass()).isEqualTo(LoggingInterceptor.class);
        runner = (ChainableRunner)runner.getNext();
        Assertions.assertThat(runner.getClass()).isEqualTo(FireAllRulesInterceptor.class);
        runner = (ChainableRunner)runner.getNext();
        Assertions.assertThat(runner.getClass()).isEqualTo(LoggingInterceptor.class);
        UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        ut.begin();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ut.rollback();
        ksession.insert((Object)3);
        runner = sscs.getChainableRunner();
        Assertions.assertThat(runner.getClass()).isEqualTo(LoggingInterceptor.class);
        runner = (ChainableRunner)runner.getNext();
        Assertions.assertThat(runner.getClass()).isEqualTo(FireAllRulesInterceptor.class);
        runner = (ChainableRunner)runner.getNext();
        Assertions.assertThat(runner.getClass()).isEqualTo(LoggingInterceptor.class);
    }

    @Test
    public void testSetFocus() {
        this.testFocus(false);
    }

    @Test
    public void testSetFocusWithOOPath() {
        this.testFocus(true);
    }

    private void testFocus(boolean withOOPath) {
        String str = "package org.kie.test\nglobal java.util.List list\nrule rule1\nagenda-group \"badfocus\"when\n" + (withOOPath ? "  Integer(/intValue[this > 0])\n" : "  Integer(intValue > 0)\n") + "then\n  list.add( 1 );\nend\n\n";
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = KieServices.get().getStoreServices().newKieSession(kbase, null, this.env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        this.insertIntRange(ksession, 1, 3);
        ksession.getAgenda().getAgendaGroup("badfocus").setFocus();
        ksession.fireAllRules();
        Assertions.assertThat(list).hasSize(3);
    }

    @Test
    public void testSharedReferences() {
        KieBase kbase = new KieHelper().getKieContainer().getKieBase();
        KieSession ksession = KieServices.get().getStoreServices().newKieSession(kbase, null, this.env);
        Person x = new Person("test");
        ArrayList<Person> test = new ArrayList<Person>();
        ArrayList<Person> test2 = new ArrayList<Person>();
        test.add(x);
        test2.add(x);
        Assertions.assertThat((Object)((Person)test.get(0))).isSameAs(test2.get(0));
        ksession.insert(test);
        ksession.insert(test2);
        ksession.fireAllRules();
        StatefulKnowledgeSession ksession2 = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)ksession.getIdentifier(), (KieBase)kbase, null, (Environment)this.env);
        Iterator c = ksession2.getObjects().iterator();
        List ref1 = (List)c.next();
        List ref2 = (List)c.next();
        Assertions.assertThat(ref1.get(0)).isSameAs(ref2.get(0));
    }

    @Test
    public void testMergeConfig() {
        KieBase kbase = new KieHelper().getKieContainer().getKieBase();
        Properties properties = new Properties();
        properties.put("drools.processInstanceManagerFactory", "com.example.CustomJPAProcessInstanceManagerFactory");
        KieSessionConfiguration config = RuleBaseFactory.newKnowledgeSessionConfiguration((Properties)properties);
        KieSession ksession = KieServices.get().getStoreServices().newKieSession(kbase, config, this.env);
        SessionConfiguration sessionConfig = (SessionConfiguration)ksession.getSessionConfiguration();
        Assertions.assertThat((String)sessionConfig.getProcessInstanceManagerFactory()).isEqualTo("com.example.CustomJPAProcessInstanceManagerFactory");
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateAndDestroySession() {
        this.createAndDestroySession(false);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateAndDestroySessionWithOOPath() {
        this.createAndDestroySession(true);
    }

    public void createAndDestroySession(boolean withOOPath) {
        String str = this.getSimpleRule(withOOPath);
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = KieServices.get().getStoreServices().newKieSession(kbase, null, this.env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        this.insertIntRange(ksession, 1, 3);
        ksession.fireAllRules();
        Assertions.assertThat(list).hasSize(3);
        long ksessionId = ksession.getIdentifier();
        ksession.destroy();
        JPAKnowledgeService.loadStatefulKnowledgeSession((Long)ksessionId, (KieBase)kbase, null, (Environment)this.env);
        Assertions.fail((String)("There should not be any session with id " + ksessionId));
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateAndDestroyNonPersistentSession() {
        this.createAndDestroyNonPersistentSession(false);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateAndDestroyNonPersistentSessionWithOOPath() {
        this.createAndDestroyNonPersistentSession(true);
    }

    private void createAndDestroyNonPersistentSession(boolean withOOPath) {
        String str = this.getSimpleRule(withOOPath);
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        this.insertIntRange(ksession, 1, 3);
        ksession.fireAllRules();
        Assertions.assertThat(list).hasSize(3);
        long ksessionId = ksession.getIdentifier();
        ksession.destroy();
        ksession.fireAllRules();
        Assertions.fail((String)("Session should already be disposed " + ksessionId));
    }

    @Test
    public void testFromNodeWithModifiedCollection() {
        this.fromNodeWithModifiedCollection(false);
    }

    @Test
    public void testFromNodeWithModifiedCollectionWithOOPath() {
        this.fromNodeWithModifiedCollection(true);
    }

    private void fromNodeWithModifiedCollection(boolean withOOPath) {
        String str = "package org.drools.test\nimport org.drools.mvel.compiler.Person\nimport org.drools.mvel.compiler.Address\nrule rule1\nwhen\n" + (withOOPath ? " $p: Person($list : addresses, /addresses[street == \"y\"])\n" : " $p: Person($list : addresses)\n $a: Address(street == \"y\") from $list\n") + "then\n $list.add( new Address(\"z\") );\n $list.add( new Address(\"w\") );\nend\n";
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = KieServices.get().getStoreServices().newKieSession(kbase, null, this.env);
        Person p1 = new Person("John");
        p1.addAddress(new Address("x"));
        p1.addAddress(new Address("y"));
        ksession.insert((Object)p1);
        ksession.fireAllRules();
        Assertions.assertThat((List)p1.getAddresses()).hasSize(4);
        ksession.dispose();
    }

    private String getSimpleRule(boolean withOOPath) {
        return "package org.kie.test\nglobal java.util.List list\nrule rule1\nwhen\n" + (withOOPath ? "  Integer(/intValue[this > 0])\n" : "  Integer(intValue > 0)\n") + "then\n  list.add( 1 );\nend\n\n";
    }

    private void insertIntRange(KieSession ksession, int from, int to) {
        IntStream.rangeClosed(from, to).forEach(arg_0 -> ((KieSession)ksession).insert(arg_0));
    }
}

