/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.command;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.mvel.compiler.command.MoreBatchExecutionTest;
import org.drools.persistence.util.DroolsPersistenceUtil;
import org.junit.After;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;

@RunWith(value=Parameterized.class)
public class MoreBatchExecutionPersistenceTest
extends MoreBatchExecutionTest {
    private Map<String, Object> context;
    private boolean locking;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> persistence() {
        Object[][] locking = new Object[][]{{DroolsPersistenceUtil.OPTIMISTIC_LOCKING}, {DroolsPersistenceUtil.PESSIMISTIC_LOCKING}};
        return Arrays.asList(locking);
    }

    public MoreBatchExecutionPersistenceTest(String locking) {
        this.locking = DroolsPersistenceUtil.PESSIMISTIC_LOCKING.equals(locking);
    }

    @After
    public void cleanUpPersistence() throws Exception {
        this.disposeKSession();
        DroolsPersistenceUtil.cleanUp(this.context);
        this.context = null;
    }

    protected StatefulKnowledgeSession createKnowledgeSession(KieBase kbase) {
        if (this.context == null) {
            this.context = DroolsPersistenceUtil.setupWithPoolingDataSource((String)"org.drools.persistence.jpa");
        }
        KieSessionConfiguration ksconf = RuleBaseFactory.newKnowledgeSessionConfiguration();
        Environment env = DroolsPersistenceUtil.createEnvironment(this.context);
        if (this.locking) {
            env.set("org.kie.api.persistence.pessimistic", (Object)true);
        }
        return JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, (KieSessionConfiguration)ksconf, (Environment)env);
    }
}

