/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.jta;

import com.arjuna.ats.jta.TransactionManager;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.drools.core.base.MapGlobalResolver;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.persistence.jta.JtaTransactionManagerTest;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.internal.command.RegistryContext;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class TransactionTestCommand
implements ExecutableCommand<Void> {
    private static final long serialVersionUID = -7640078670024414748L;
    private Object mainObject;
    private Object subObject;
    private EntityManager em;
    private EntityManagerFactory emf;

    public TransactionTestCommand(Object mainObject, Object subObject, HashMap<String, Object> env) {
        this.mainObject = mainObject;
        this.subObject = subObject;
        this.setPersistenceFields(env);
    }

    public TransactionTestCommand(Object mainObject, HashMap<String, Object> env) {
        this.mainObject = mainObject;
        this.subObject = null;
        this.setPersistenceFields(env);
    }

    private void setPersistenceFields(HashMap<String, Object> env) {
        this.em = (EntityManager)env.get(JtaTransactionManagerTest.COMMAND_ENTITY_MANAGER);
        assert (this.em != null) : "Command Entity Manager is null";
        this.emf = (EntityManagerFactory)env.get(JtaTransactionManagerTest.COMMAND_ENTITY_MANAGER_FACTORY);
    }

    private HashMap<String, Object> getPersistenceEnvironment() {
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put(JtaTransactionManagerTest.COMMAND_ENTITY_MANAGER, this.em);
        env.put(JtaTransactionManagerTest.COMMAND_ENTITY_MANAGER_FACTORY, this.emf);
        return env;
    }

    public Void execute(Context context) {
        this.em.joinTransaction();
        this.em.persist(this.mainObject);
        if (this.subObject != null) {
            KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
            InternalKnowledgeBase cleanKBase = KnowledgeBaseFactory.newKnowledgeBase();
            cleanKBase.addPackages(ksession.getKieBase().getKiePackages());
            StatefulKnowledgeSession commandKSession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)cleanKBase, null, (Environment)this.initializeEnvironment());
            TransactionTestCommand transactionTestSubCommand = new TransactionTestCommand(this.subObject, this.getPersistenceEnvironment());
            commandKSession.execute((Command)transactionTestSubCommand);
        }
        return null;
    }

    private Environment initializeEnvironment() {
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("org.kie.api.persistence.jpa.EntityManagerFactory", (Object)this.emf);
        env.set("org.kie.Globals", (Object)new MapGlobalResolver());
        env.set("org.kie.transaction.TransactionManager", (Object)TransactionManager.transactionManager());
        return env;
    }
}

