/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.session;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.drools.commands.impl.CommandBasedStatefulKnowledgeSessionImpl;
import org.drools.core.common.InternalAgenda;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.persistence.util.DroolsPersistenceUtil;
import org.drools.util.io.ClassPathResource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.command.RegistryContext;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class RuleFlowGroupRollbackTest {
    private static Logger logger = LoggerFactory.getLogger(RuleFlowGroupRollbackTest.class);
    private Map<String, Object> context;
    private boolean locking;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> persistence() {
        Object[][] locking = new Object[][]{{DroolsPersistenceUtil.OPTIMISTIC_LOCKING}, {DroolsPersistenceUtil.PESSIMISTIC_LOCKING}};
        return Arrays.asList(locking);
    }

    public RuleFlowGroupRollbackTest(String locking) {
        this.locking = DroolsPersistenceUtil.PESSIMISTIC_LOCKING.equals(locking);
    }

    @Before
    public void setUp() throws Exception {
        this.context = DroolsPersistenceUtil.setupWithPoolingDataSource((String)"org.drools.persistence.jpa");
    }

    @After
    public void tearDown() {
        DroolsPersistenceUtil.cleanUp(this.context);
    }

    @Test
    public void testRuleFlowGroupRollback() throws Exception {
        CommandBasedStatefulKnowledgeSessionImpl ksession = this.createSession();
        ArrayList<String> list = new ArrayList<String>();
        list.add("Test");
        ksession.insert(list);
        ksession.execute((Command)new ActivateRuleFlowCommand("ruleflow-group"));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        try {
            ksession.execute((Command)new ExceptionCommand());
            Assert.fail((String)"Process must throw an exception");
        }
        catch (Exception e) {
            logger.info("The above " + RuntimeException.class.getSimpleName() + " was expected in this test.");
        }
        ksession.insert(list);
        ksession.execute((Command)new ActivateRuleFlowCommand("ruleflow-group"));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    private CommandBasedStatefulKnowledgeSessionImpl createSession() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ClassPathResource("ruleflowgroup_rollback.drl"), ResourceType.DRL);
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        kbase.addPackages(kbuilder.getKnowledgePackages());
        Environment env = DroolsPersistenceUtil.createEnvironment(this.context);
        if (this.locking) {
            env.set("org.kie.api.persistence.pessimistic", (Object)true);
        }
        return (CommandBasedStatefulKnowledgeSessionImpl)JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)env);
    }

    public class ExceptionCommand
    implements ExecutableCommand<Object> {
        public Void execute(Context context) {
            throw new RuntimeException("(Expected) exception thrown by test");
        }
    }

    public class ActivateRuleFlowCommand
    implements ExecutableCommand<Object> {
        private String ruleFlowGroupName;

        public ActivateRuleFlowCommand(String ruleFlowGroupName) {
            this.ruleFlowGroupName = ruleFlowGroupName;
        }

        public Void execute(Context context) {
            KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
            ((InternalAgenda)ksession.getAgenda()).activateRuleFlowGroup(this.ruleFlowGroupName);
            return null;
        }
    }
}

