/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.jta;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.transaction.RollbackException;
import javax.transaction.UserTransaction;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.drools.commands.impl.CommandBasedStatefulKnowledgeSessionImpl;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.persistence.PersistableRunner;
import org.drools.persistence.jpa.JpaPersistenceContextManager;
import org.drools.persistence.jta.JtaTransactionManager;
import org.drools.persistence.jta.TransactionTestCommand;
import org.drools.persistence.jta.TransactionTestObject;
import org.drools.persistence.util.DroolsPersistenceUtil;
import org.hibernate.TransientObjectException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.command.Command;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JtaTransactionManagerTest {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, Object> context;
    private EntityManagerFactory emf;
    private static String simpleRule = "package org.kie.test\nglobal java.util.List list\nrule rule1\nwhen\n  Integer(intValue > 0)\nthen\n  list.add( 1 );\nend\n\n";
    public static final String DEFAULT_USER_TRANSACTION_NAME = "java:comp/UserTransaction";
    public static String COMMAND_ENTITY_MANAGER = "drools.persistence.test.command.EntityManager";
    public static String COMMAND_ENTITY_MANAGER_FACTORY = "drools.persistence.test.EntityManagerFactory";

    @Before
    public void setup() {
        boolean testMarshalling = false;
        this.context = DroolsPersistenceUtil.setupWithPoolingDataSource((String)"org.drools.persistence.jpa", (boolean)testMarshalling);
        this.emf = (EntityManagerFactory)this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
    }

    @After
    public void tearDown() {
        DroolsPersistenceUtil.cleanUp(this.context);
    }

    private KieBase initializeKnowledgeBase(String rule) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assertions.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    protected UserTransaction findUserTransaction() {
        try {
            InitialContext context = new InitialContext();
            return (UserTransaction)context.lookup(DEFAULT_USER_TRANSACTION_NAME);
        }
        catch (NamingException ex) {
            this.logger.debug("No UserTransaction found at JNDI location [{}]", (Object)DEFAULT_USER_TRANSACTION_NAME, (Object)ex);
            return null;
        }
    }

    private String getTestName() {
        StackTraceElement[] ste = Thread.currentThread().getStackTrace();
        String methodName = ste[2].getMethodName();
        return methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
    }

    @Test
    public void showingTransactionTestObjectsNeedTransactions() throws Exception {
        boolean rollBackExceptionthrown;
        UserTransaction tx;
        EntityManager em;
        TransactionTestObject subObject;
        String testName;
        block4: {
            testName = this.getTestName();
            TransactionTestObject badMainObject = new TransactionTestObject();
            badMainObject.setName("bad" + testName);
            subObject = new TransactionTestObject();
            subObject.setName("sub" + testName);
            badMainObject.setSubObject(subObject);
            em = this.emf.createEntityManager();
            tx = this.findUserTransaction();
            tx.begin();
            em.joinTransaction();
            em.persist((Object)badMainObject);
            rollBackExceptionthrown = false;
            try {
                this.logger.info("The following " + IllegalStateException.class.getSimpleName() + " SHOULD be thrown.");
                tx.commit();
            }
            catch (Exception e) {
                if (!(e instanceof RollbackException) && !(e.getCause() instanceof TransientObjectException)) break block4;
                rollBackExceptionthrown = true;
                if (tx.getStatus() != 1) break block4;
                tx.rollback();
            }
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)rollBackExceptionthrown).as("A rollback exception should have been thrown because of foreign key violations.", new Object[0])).isTrue();
        TransactionTestObject mainObject = new TransactionTestObject();
        mainObject.setName("main" + testName);
        mainObject.setSubObject(subObject);
        tx.begin();
        em.joinTransaction();
        em.persist((Object)mainObject);
        em.persist((Object)subObject);
        try {
            tx.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("No exception should have been thrown: " + e.getMessage()));
        }
    }

    @Test
    public void basicTransactionManagerTest() {
        String testName = this.getTestName();
        Environment env = DroolsPersistenceUtil.createEnvironment(this.context);
        Object tm = env.get("org.kie.transaction.TransactionManager");
        JtaTransactionManager txm = new JtaTransactionManager(env.get("org.kie.transaction.Transaction"), env.get("org.kie.transaction.TransactionSynchronizationRegistry"), tm);
        TransactionTestObject mainObject = new TransactionTestObject();
        mainObject.setName("main" + testName);
        TransactionTestObject subObject = new TransactionTestObject();
        subObject.setName("sub" + testName);
        mainObject.setSubObject(subObject);
        EntityManager em = this.emf.createEntityManager();
        try {
            boolean txOwner = txm.begin();
            boolean notTxOwner = txm.begin();
            em.persist((Object)mainObject);
            txm.commit(notTxOwner);
            em.persist((Object)subObject);
            txm.commit(txOwner);
        }
        catch (Throwable t) {
            Assertions.fail((String)("No exception should have been thrown: " + t.getMessage()));
        }
    }

    @Test
    public void basicTransactionRollbackTest() {
        Environment env = DroolsPersistenceUtil.createEnvironment(this.context);
        Object tm = env.get("org.kie.transaction.TransactionManager");
        JtaTransactionManager txm = new JtaTransactionManager(env.get("org.kie.transaction.Transaction"), env.get("org.kie.transaction.TransactionSynchronizationRegistry"), tm);
        TransactionTestObject mainObject = new TransactionTestObject();
        mainObject.setName("main");
        TransactionTestObject subObject = new TransactionTestObject();
        subObject.setName("sub");
        mainObject.setSubObject(subObject);
        EntityManager em = this.emf.createEntityManager();
        try {
            boolean txOwner = txm.begin();
            boolean notTxOwner = txm.begin();
            em.persist((Object)mainObject);
            txm.rollback(notTxOwner);
            em.persist((Object)subObject);
            txm.rollback(txOwner);
        }
        catch (Exception e) {
            Assertions.fail((String)("There should not be an exception thrown here: " + e.getMessage()));
        }
    }

    @Test
    public void testSingleSessionCommandServiceAndJtaTransactionManagerTogether() throws Exception {
        Environment env = DroolsPersistenceUtil.createEnvironment(this.context);
        KieBase kbase = this.initializeKnowledgeBase(simpleRule);
        KieSession commandKSession = KieServices.get().getStoreServices().newKieSession(kbase, null, env);
        commandKSession.getIdentifier();
        PersistableRunner commandService = (PersistableRunner)((CommandBasedStatefulKnowledgeSessionImpl)commandKSession).getRunner();
        JpaPersistenceContextManager jpm = (JpaPersistenceContextManager)JtaTransactionManagerTest.getValueOfField("jpm", commandService);
        TransactionTestObject mainObject = new TransactionTestObject();
        mainObject.setName("mainCommand");
        TransactionTestObject subObject = new TransactionTestObject();
        subObject.setName("subCommand");
        mainObject.setSubObject(subObject);
        UserTransaction ut = (UserTransaction)InitialContext.doLookup(DEFAULT_USER_TRANSACTION_NAME);
        ut.begin();
        HashMap<String, Object> emEnv = new HashMap<String, Object>();
        emEnv.put(COMMAND_ENTITY_MANAGER_FACTORY, this.emf);
        emEnv.put(COMMAND_ENTITY_MANAGER, jpm.getCommandScopedEntityManager());
        TransactionTestCommand txTestCmd = new TransactionTestCommand(mainObject, subObject, emEnv);
        commandKSession.execute((Command)txTestCmd);
        ut.commit();
    }

    public static Object getValueOfField(String fieldname, Object source) {
        String sourceClassName = source.getClass().getSimpleName();
        Field field = null;
        try {
            field = source.getClass().getDeclaredField(fieldname);
            field.setAccessible(true);
        }
        catch (SecurityException e) {
            Assertions.fail((String)("Unable to retrieve " + fieldname + " field from " + sourceClassName + ": " + e.getCause()));
        }
        catch (NoSuchFieldException e) {
            Assertions.fail((String)("Unable to retrieve " + fieldname + " field from " + sourceClassName + ": " + e.getCause()));
        }
        ((ObjectAssert)Assertions.assertThat((Object)field).as("." + fieldname + " field is null!?!", new Object[0])).isNotNull();
        Object fieldValue = null;
        try {
            fieldValue = field.get(source);
        }
        catch (IllegalArgumentException e) {
            Assertions.fail((String)("Unable to retrieve value of " + fieldname + " from " + sourceClassName + ": " + e.getCause()));
        }
        catch (IllegalAccessException e) {
            Assertions.fail((String)("Unable to retrieve value of " + fieldname + " from " + sourceClassName + ": " + e.getCause()));
        }
        return fieldValue;
    }
}

