/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.map.impl;

import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.drools.io.ByteArrayResource;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.persistence.jpa.marshaller.JPAPlaceholderResolverStrategy;
import org.drools.persistence.map.impl.Buddy;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderErrors;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MapPersistenceTest {
    private static Logger logger = LoggerFactory.getLogger(JPAPlaceholderResolverStrategy.class);

    @Test
    public void createPersistentSession() {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KieSession crmPersistentSession = this.createSession((KieBase)kbase);
        crmPersistentSession.fireAllRules();
        crmPersistentSession = this.createSession((KieBase)kbase);
        Assertions.assertThat((Object)crmPersistentSession).isNotNull();
    }

    @Test
    public void createPersistentSessionWithRules() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Object rule = "package org.drools.persistence.map.impl\n";
        rule = (String)rule + "import org.drools.persistence.map.impl.Buddy;\n";
        rule = (String)rule + "rule \"echo2\" \n";
        rule = (String)rule + "dialect \"mvel\"\n";
        rule = (String)rule + "when\n";
        rule = (String)rule + "    $m : Buddy()\n";
        rule = (String)rule + "then\n";
        rule = (String)rule + "    System.out.println(\"buddy inserted\")";
        rule = (String)rule + "end\n";
        kbuilder.add((Resource)new ByteArrayResource(((String)rule).getBytes()), ResourceType.DRL);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (errors != null && errors.size() > 0) {
            for (KnowledgeBuilderError error : errors) {
                logger.warn("Error: " + error.getMessage());
            }
            Assertions.fail((String)"KnowledgeBase did not build");
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession ksession = this.createSession((KieBase)kbase);
        FactHandle buddyFactHandle = ksession.insert((Object)new Buddy());
        ksession.fireAllRules();
        Assertions.assertThat((int)ksession.getObjects().size()).isEqualTo(1);
        ksession = this.disposeAndReloadSession(ksession, (KieBase)kbase);
        Assertions.assertThat((Object)ksession).isNotNull();
        Assertions.assertThat((int)ksession.getObjects().size()).isEqualTo(1);
        ((ObjectAssert)Assertions.assertThat((Object)ksession.getObject(buddyFactHandle)).as("An object can't be retrieved with a FactHandle from a disposed session", new Object[0])).isNull();
    }

    @Test
    public void dontCreateMoreSessionsThanNecessary() {
        long initialNumberOfSavedSessions = this.getSavedSessionsCount();
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KieSession crmPersistentSession = this.createSession((KieBase)kbase);
        long ksessionId = crmPersistentSession.getIdentifier();
        crmPersistentSession.fireAllRules();
        crmPersistentSession = this.disposeAndReloadSession(crmPersistentSession, (KieBase)kbase);
        Assertions.assertThat((long)crmPersistentSession.getIdentifier()).isEqualTo(ksessionId);
        ksessionId = crmPersistentSession.getIdentifier();
        crmPersistentSession.fireAllRules();
        crmPersistentSession = this.disposeAndReloadSession(crmPersistentSession, (KieBase)kbase);
        crmPersistentSession.fireAllRules();
        Assertions.assertThat((long)this.getSavedSessionsCount()).isEqualTo(initialNumberOfSavedSessions + 1L);
        crmPersistentSession.dispose();
    }

    @Test
    public void insertObjectIntoKsessionAndRetrieve() {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KieSession crmPersistentSession = this.createSession((KieBase)kbase);
        Buddy bestBuddy = new Buddy("john");
        crmPersistentSession.insert((Object)bestBuddy);
        crmPersistentSession = this.disposeAndReloadSession(crmPersistentSession, (KieBase)kbase);
        Object obtainedBuddy = crmPersistentSession.getObjects().iterator().next();
        Assertions.assertThat(obtainedBuddy).isNotSameAs((Object)bestBuddy);
        Assertions.assertThat(obtainedBuddy).isEqualTo((Object)bestBuddy);
        crmPersistentSession.dispose();
    }

    protected abstract KieSession createSession(KieBase var1);

    protected abstract KieSession disposeAndReloadSession(KieSession var1, KieBase var2);

    protected abstract long getSavedSessionsCount();
}

