/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.monitoring;

import java.lang.management.ManagementFactory;
import java.util.Map;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.assertj.core.api.Assertions;
import org.drools.compiler.kie.builder.impl.KieServicesImpl;
import org.drools.core.management.DroolsManagementAgent;
import org.drools.persistence.util.DroolsPersistenceUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.conf.MBeansOption;
import org.kie.api.management.KieContainerMonitorMXBean;
import org.kie.api.management.KieSessionMonitoringMXBean;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieContainer;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoringWithJPAKnowledgeServiceTest {
    private static Logger LOG = LoggerFactory.getLogger(MonitoringWithJPAKnowledgeServiceTest.class);
    private Map<String, Object> context;
    private Environment env;
    private String mbeansprop;

    @Before
    public void setUp() throws Exception {
        ((KieServicesImpl)KieServices.Factory.get()).nullKieClasspathContainer();
        ((KieServicesImpl)KieServices.Factory.get()).nullAllContainerIds();
        this.mbeansprop = System.getProperty("kie.mbeans");
        System.setProperty("kie.mbeans", "enabled");
        this.context = DroolsPersistenceUtil.setupWithPoolingDataSource((String)"org.drools.persistence.jpa");
        this.env = DroolsPersistenceUtil.createEnvironment(this.context);
    }

    @After
    public void tearDown() throws Exception {
        ((KieServicesImpl)KieServices.Factory.get()).nullKieClasspathContainer();
        ((KieServicesImpl)KieServices.Factory.get()).nullAllContainerIds();
        if (this.mbeansprop != null) {
            System.setProperty("kie.mbeans", this.mbeansprop);
        } else {
            System.setProperty("kie.mbeans", MBeansOption.DISABLED.toString());
        }
        DroolsPersistenceUtil.cleanUp(this.context);
    }

    @Test
    public void testBasic() throws MalformedObjectNameException {
        MBeanServer mbserver = ManagementFactory.getPlatformMBeanServer();
        KieServices ks = KieServices.Factory.get();
        String containerId = "testcontainer-" + System.currentTimeMillis();
        KieContainer kc = ks.newKieClasspathContainer(containerId);
        KieContainerMonitorMXBean c1Monitor = JMX.newMXBeanProxy(mbserver, DroolsManagementAgent.createObjectNameBy((String)containerId), KieContainerMonitorMXBean.class);
        KieBase kb = kc.getKieBase("org.kie.monitoring.kbase1");
        StatefulKnowledgeSession statefulKieSession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kb, null, (Environment)this.env);
        long sessionIdentifier = statefulKieSession.getIdentifier();
        statefulKieSession.insert((Object)"String1");
        statefulKieSession.fireAllRules();
        KieSessionMonitoringMXBean statefulKieSessionMonitor = JMX.newMXBeanProxy(mbserver, DroolsManagementAgent.createObjectNameBy((String)containerId, (String)"org.kie.monitoring.kbase1", (KieSessionModel.KieSessionType)KieSessionModel.KieSessionType.STATEFUL, (String)"persistent"), KieSessionMonitoringMXBean.class);
        Assertions.assertThat((long)statefulKieSessionMonitor.getTotalMatchesFired()).isEqualTo(1L);
        Assertions.assertThat((int)mbserver.queryNames(new ObjectName("org.kie:kcontainerId=" + ObjectName.quote(containerId) + ",*"), null).size()).isEqualTo(3);
        statefulKieSession.dispose();
        StatefulKnowledgeSession deserialized = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)sessionIdentifier, (KieBase)kb, null, (Environment)DroolsPersistenceUtil.createEnvironment(this.context));
        deserialized.insert((Object)"String2");
        deserialized.fireAllRules();
        Assertions.assertThat((long)statefulKieSessionMonitor.getTotalMatchesFired()).isEqualTo(2L);
        kc.dispose();
    }
}

