/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.drools.serialization.protobuf.marshalling.InternalMarshaller;
import org.drools.serialization.protobuf.marshalling.KieSessionInitializer;
import org.kie.api.KieBase;
import org.kie.api.marshalling.Marshaller;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.internal.marshalling.MarshallerFactory;

public class SessionMarshallingHelper {
    private KieBase kbase;
    private KieSessionConfiguration conf;
    private KieSession ksession;
    private InternalMarshaller marshaller;
    private Environment env;

    public SessionMarshallingHelper(KieBase kbase, KieSessionConfiguration conf, Environment env) {
        this.kbase = kbase;
        this.conf = conf;
        this.env = env;
        ObjectMarshallingStrategy[] strategies = (ObjectMarshallingStrategy[])env.get("org.kie.api.marshalling.ObjectMarshallingStrategies");
        this.marshaller = strategies != null ? (InternalMarshaller)MarshallerFactory.newMarshaller((KieBase)kbase, (ObjectMarshallingStrategy[])strategies) : (InternalMarshaller)MarshallerFactory.newMarshaller((KieBase)kbase);
    }

    public SessionMarshallingHelper(KieSession ksession, KieSessionConfiguration conf) {
        this.ksession = ksession;
        this.kbase = ksession.getKieBase();
        this.conf = conf;
        this.env = ksession.getEnvironment();
        ObjectMarshallingStrategy[] strategies = (ObjectMarshallingStrategy[])this.env.get("org.kie.api.marshalling.ObjectMarshallingStrategies");
        this.marshaller = strategies != null ? (InternalMarshaller)MarshallerFactory.newMarshaller((KieBase)this.kbase, (ObjectMarshallingStrategy[])strategies) : (InternalMarshaller)MarshallerFactory.newMarshaller((KieBase)this.kbase);
    }

    public byte[] getSnapshot() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.marshaller.marshall((OutputStream)baos, this.ksession);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get session snapshot", e);
        }
        return baos.toByteArray();
    }

    public KieSession loadSnapshot(byte[] bytes, KieSession ksession, KieSessionInitializer initializer) {
        this.ksession = ksession;
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try {
            this.marshaller.setInitializer(initializer);
            if (this.ksession != null) {
                this.marshaller.unmarshall((InputStream)bais, this.ksession);
            } else {
                this.ksession = this.marshaller.unmarshall((InputStream)bais, this.conf, this.env);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load session snapshot", e);
        }
        finally {
            this.marshaller.setInitializer(null);
        }
        return this.ksession;
    }

    public KieSession getObject() {
        return this.ksession;
    }

    public KieBase getKbase() {
        return this.kbase;
    }

    public KieSessionConfiguration getConf() {
        return this.conf;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }
}

