/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.jta;

import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionSynchronizationRegistryImple;
import com.arjuna.ats.jta.TransactionManager;
import com.arjuna.ats.jta.UserTransaction;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.assertj.core.api.Assertions;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.persistence.jta.JtaTransactionManager;
import org.drools.persistence.jta.JtaTransactionManagerFactory;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.runtime.Environment;

public class JtaTransactionManagerFactoryTest {
    private static final jakarta.transaction.UserTransaction DUMMY_UT = new jakarta.transaction.UserTransaction(){

        public void setTransactionTimeout(int arg0) throws SystemException {
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
        }

        public int getStatus() throws SystemException {
            return 0;
        }

        public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        }

        public void begin() throws NotSupportedException, SystemException {
        }

        public boolean equals(Object obj) {
            return this == obj;
        }
    };

    @BeforeClass
    public static void setupOnce() throws NamingException {
        InitialContext initContext = new InitialContext();
        initContext.rebind("java:comp/UserTransaction", (Object)UserTransaction.userTransaction());
        initContext.rebind("java:comp/TransactionManager", (Object)TransactionManager.transactionManager());
        initContext.rebind("java:comp/TransactionSynchronizationRegistry", (Object)new TransactionSynchronizationRegistryImple());
    }

    @Test
    public void usesEnvironmentToCreateTransactionManager() throws Exception {
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("org.kie.transaction.Transaction", (Object)DUMMY_UT);
        JtaTransactionManager txm = (JtaTransactionManager)new JtaTransactionManagerFactory().newTransactionManager(env);
        Assertions.assertThat((Object)txm.ut).isEqualTo((Object)DUMMY_UT);
    }

    @Test
    public void createsWithoutEnvironment() throws Exception {
        JtaTransactionManager txm = (JtaTransactionManager)new JtaTransactionManagerFactory().newTransactionManager();
        Assertions.assertThat((boolean)jakarta.transaction.TransactionManager.class.isAssignableFrom(txm.tm.getClass())).isTrue();
    }
}

