/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.map.impl;

import jakarta.persistence.EntityManagerFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.drools.persistence.jpa.marshaller.JPAPlaceholderResolverStrategy;
import org.drools.persistence.jta.JtaTransactionManager;
import org.drools.persistence.map.impl.MapPersistenceTest;
import org.drools.persistence.util.DroolsPersistenceUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class JpaBasedPersistenceTest
extends MapPersistenceTest {
    private static Logger logger = LoggerFactory.getLogger(JPAPlaceholderResolverStrategy.class);
    private Map<String, Object> context;
    private EntityManagerFactory emf;
    private JtaTransactionManager txm;
    private boolean useTransactions = false;
    private boolean locking;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> persistence() {
        Object[][] locking = new Object[][]{{DroolsPersistenceUtil.OPTIMISTIC_LOCKING}, {DroolsPersistenceUtil.PESSIMISTIC_LOCKING}};
        return Arrays.asList(locking);
    }

    public JpaBasedPersistenceTest(String locking) {
        this.locking = DroolsPersistenceUtil.PESSIMISTIC_LOCKING.equals(locking);
    }

    @Before
    public void setUp() throws Exception {
        this.context = DroolsPersistenceUtil.setupWithPoolingDataSource((String)"org.drools.persistence.jpa");
        this.emf = (EntityManagerFactory)this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        if (DroolsPersistenceUtil.useTransactions()) {
            this.useTransactions = true;
            Environment env = DroolsPersistenceUtil.createEnvironment(this.context);
            Object tm = env.get("org.kie.transaction.TransactionManager");
            this.txm = new JtaTransactionManager(env.get("org.kie.transaction.Transaction"), env.get("org.kie.transaction.TransactionSynchronizationRegistry"), tm);
        }
    }

    @After
    public void tearDown() throws Exception {
        DroolsPersistenceUtil.cleanUp(this.context);
    }

    @Override
    protected KieSession createSession(KieBase kbase) {
        Environment env = DroolsPersistenceUtil.createEnvironment(this.context);
        if (this.locking) {
            env.set("org.kie.api.persistence.pessimistic", (Object)true);
        }
        return JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)env);
    }

    @Override
    protected KieSession disposeAndReloadSession(KieSession ksession, KieBase kbase) {
        long ksessionId = ksession.getIdentifier();
        ksession.dispose();
        return JPAKnowledgeService.loadStatefulKnowledgeSession((Long)ksessionId, (KieBase)kbase, null, (Environment)DroolsPersistenceUtil.createEnvironment(this.context));
    }

    @Override
    protected long getSavedSessionsCount() {
        logger.info("quering number of saved sessions.");
        boolean transactionOwner = false;
        if (this.useTransactions) {
            transactionOwner = this.txm.begin();
        }
        long savedSessionsCount = this.emf.createEntityManager().createQuery("FROM SessionInfo").getResultList().size();
        if (this.useTransactions) {
            this.txm.commit(transactionOwner);
        }
        return savedSessionsCount;
    }
}

