/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.info;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Transient;
import jakarta.persistence.Version;
import java.util.Date;
import org.drools.persistence.SessionMarshallingHelper;
import org.drools.persistence.api.PersistentSession;

@Entity
@SequenceGenerator(name="sessionInfoIdSeq", sequenceName="SESSIONINFO_ID_SEQ")
public class SessionInfo
implements PersistentSession {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="sessionInfoIdSeq")
    private Long id;
    @Version
    @Column(name="OPTLOCK")
    private int version;
    private Date startDate = new Date();
    private Date lastModificationDate;
    @Lob
    @Column(length=0x7FFFFFFF)
    private byte[] rulesByteArray;
    @Transient
    SessionMarshallingHelper helper;

    public Long getId() {
        return this.id;
    }

    public int getVersion() {
        return this.version;
    }

    public void setJPASessionMashallingHelper(SessionMarshallingHelper helper) {
        this.helper = helper;
    }

    public SessionMarshallingHelper getJPASessionMashallingHelper() {
        return this.helper;
    }

    public void setData(byte[] data) {
        this.rulesByteArray = data;
    }

    public byte[] getData() {
        return this.rulesByteArray;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getLastModificationDate() {
        return this.lastModificationDate;
    }

    public void setLastModificationDate(Date date) {
        this.lastModificationDate = date;
    }

    public void transform() {
        this.rulesByteArray = this.helper.getSnapshot();
    }

    public void setId(Long ksessionId) {
        this.id = ksessionId;
    }
}

