/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.jpa.marshaller;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Version;
import java.io.Serializable;

@Entity
@SequenceGenerator(name="mappedVarIdSeq", sequenceName="MAPPED_VAR_ID_SEQ")
public class MappedVariable
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="mappedVarIdSeq")
    private Long mappedVarId;
    @Version
    @Column(name="OPTLOCK")
    private int version;
    private Long variableId;
    private String variableType;
    private String processInstanceId;
    private Long taskId;
    private Long workItemId;

    public MappedVariable() {
    }

    public MappedVariable(Long variableId, String variableType, String processInstanceId) {
        this.variableId = variableId;
        this.variableType = variableType;
        this.processInstanceId = processInstanceId;
    }

    public MappedVariable(Long variableId, String variableType, String processInstanceId, Long taskId, Long workItemId) {
        this.variableId = variableId;
        this.variableType = variableType;
        this.processInstanceId = processInstanceId;
        this.taskId = taskId;
        this.workItemId = workItemId;
    }

    public Long getMappedVarId() {
        return this.mappedVarId;
    }

    public void setMappedVarId(Long mappedVarId) {
        this.mappedVarId = mappedVarId;
    }

    public Long getVariableId() {
        return this.variableId;
    }

    public void setVariableId(Long variableId) {
        this.variableId = variableId;
    }

    public String getVariableType() {
        return this.variableType;
    }

    public void setVariableType(String variableType) {
        this.variableType = variableType;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public Long getWorkItemId() {
        return this.workItemId;
    }

    public void setWorkItemId(Long workItemId) {
        this.workItemId = workItemId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappedVariable that = (MappedVariable)o;
        if (this.processInstanceId != null ? !this.processInstanceId.equals(that.processInstanceId) : that.processInstanceId != null) {
            return false;
        }
        if (this.taskId != null ? !this.taskId.equals(that.taskId) : that.taskId != null) {
            return false;
        }
        if (this.variableId != null ? !this.variableId.equals(that.variableId) : that.variableId != null) {
            return false;
        }
        if (this.variableType != null ? !this.variableType.equals(that.variableType) : that.variableType != null) {
            return false;
        }
        return !(this.workItemId != null ? !this.workItemId.equals(that.workItemId) : that.workItemId != null);
    }

    public int hashCode() {
        int result = this.variableId != null ? this.variableId.hashCode() : 0;
        result = 31 * result + (this.variableType != null ? this.variableType.hashCode() : 0);
        result = 31 * result + (this.processInstanceId != null ? this.processInstanceId.hashCode() : 0);
        result = 31 * result + (this.taskId != null ? this.taskId.hashCode() : 0);
        result = 31 * result + (this.workItemId != null ? this.workItemId.hashCode() : 0);
        return result;
    }
}

