/*
 * Decompiled with CFR 0.152.
 */
package org.drools.runtime.pipeline.impl;

import com.sun.tools.xjc.Language;
import com.sun.tools.xjc.Options;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import junit.framework.TestCase;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.JaxbConfiguration;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceConfiguration;
import org.drools.builder.ResourceType;
import org.drools.builder.help.KnowledgeBuilderHelper;
import org.drools.core.util.StringUtils;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.pipeline.Action;
import org.drools.runtime.pipeline.KnowledgeRuntimeCommand;
import org.drools.runtime.pipeline.Pipeline;
import org.drools.runtime.pipeline.PipelineFactory;
import org.drools.runtime.pipeline.Receiver;
import org.drools.runtime.pipeline.ResultHandler;
import org.drools.runtime.pipeline.Transformer;

public class JaxbGlobalTest
extends TestCase {
    public void testGlobal() throws Exception {
        Options xjcOpts = new Options();
        xjcOpts.setSchemaLanguage(Language.XMLSCHEMA);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        JaxbConfiguration jaxbConf = KnowledgeBuilderFactory.newJaxbConfiguration((Options)xjcOpts, (String)"xsd");
        kbuilder.add(ResourceFactory.newClassPathResource((String)"order.xsd", ((Object)((Object)this)).getClass()), ResourceType.XSD, (ResourceConfiguration)jaxbConf);
        JaxbGlobalTest.assertFalse((boolean)kbuilder.hasErrors());
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_Jaxb.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        JaxbGlobalTest.assertFalse((boolean)kbuilder.hasErrors());
        JaxbGlobalTest.assertFalse((boolean)kbuilder.hasErrors());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        KnowledgeRuntimeCommand setGlobalStage = PipelineFactory.newStatefulKnowledgeSessionSetGlobal((String)"order");
        JAXBContext jaxbCtx = KnowledgeBuilderHelper.newJAXBContext((String[])jaxbConf.getClasses().toArray(new String[jaxbConf.getClasses().size()]), (KnowledgeBase)kbase);
        Unmarshaller unmarshaller = jaxbCtx.createUnmarshaller();
        Transformer transformer = PipelineFactory.newJaxbFromXmlTransformer((Unmarshaller)unmarshaller);
        transformer.setReceiver((Receiver)setGlobalStage);
        Pipeline pipeline = PipelineFactory.newStatefulKnowledgeSessionPipeline((StatefulKnowledgeSession)ksession);
        pipeline.setReceiver((Receiver)transformer);
        String xml = StringUtils.readFileAsString((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("order.xml")));
        ResultHandlerImpl resultHandler = new ResultHandlerImpl();
        pipeline.insert((Object)xml, (ResultHandler)resultHandler);
        Action executeResult = PipelineFactory.newExecuteResultHandler();
        Action assignAsResult = PipelineFactory.newAssignObjectAsResult();
        assignAsResult.setReceiver((Receiver)executeResult);
        Marshaller marshaller = jaxbCtx.createMarshaller();
        transformer = PipelineFactory.newJaxbToXmlTransformer((Marshaller)marshaller);
        transformer.setReceiver((Receiver)assignAsResult);
        KnowledgeRuntimeCommand getGlobalStage = PipelineFactory.newStatefulKnowledgeSessionGetGlobal();
        getGlobalStage.setReceiver((Receiver)transformer);
        pipeline = PipelineFactory.newStatefulKnowledgeSessionPipeline((StatefulKnowledgeSession)ksession);
        pipeline.setReceiver((Receiver)getGlobalStage);
        resultHandler = new ResultHandlerImpl();
        pipeline.insert((Object)"order", (ResultHandler)resultHandler);
        JaxbGlobalTest.assertEqualsIgnoreWhitespace(xml, (String)resultHandler.getObject());
    }

    private static void assertEqualsIgnoreWhitespace(String expected, String actual) {
        String cleanExpected = expected.replaceAll("\\s+", "");
        String cleanActual = actual.replaceAll("\\s+", "");
        JaxbGlobalTest.assertEquals((String)cleanExpected, (String)cleanActual);
    }

    public static class ResultHandlerImpl
    implements ResultHandler {
        Object object;

        public void handleResult(Object object) {
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }
    }
}

