/*
 * Decompiled with CFR 0.152.
 */
package org.drools.runtime.pipeline.impl;

import com.sun.tools.xjc.Language;
import com.sun.tools.xjc.Options;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import junit.framework.TestCase;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.JaxbConfiguration;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceConfiguration;
import org.drools.builder.ResourceType;
import org.drools.builder.help.KnowledgeBuilderHelper;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.pipeline.Action;
import org.drools.runtime.pipeline.Expression;
import org.drools.runtime.pipeline.KnowledgeRuntimeCommand;
import org.drools.runtime.pipeline.Pipeline;
import org.drools.runtime.pipeline.PipelineFactory;
import org.drools.runtime.pipeline.Receiver;
import org.drools.runtime.pipeline.ResultHandler;
import org.drools.runtime.pipeline.Splitter;
import org.drools.runtime.pipeline.Transformer;

public class JaxbTest
extends TestCase {
    public void testDirectRoot() throws Exception {
        Options xjcOpts = new Options();
        xjcOpts.setSchemaLanguage(Language.XMLSCHEMA);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        JaxbConfiguration jaxbConf = KnowledgeBuilderFactory.newJaxbConfiguration((Options)xjcOpts, (String)"xsd");
        kbuilder.add(ResourceFactory.newClassPathResource((String)"order.xsd", ((Object)((Object)this)).getClass()), ResourceType.XSD, (ResourceConfiguration)jaxbConf);
        JaxbTest.assertFalse((boolean)kbuilder.hasErrors());
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_Jaxb.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list1 = new ArrayList();
        ksession.setGlobal("list1", list1);
        Action executeResultHandler = PipelineFactory.newExecuteResultHandler();
        KnowledgeRuntimeCommand insertStage = PipelineFactory.newStatefulKnowledgeSessionInsert();
        insertStage.setReceiver((Receiver)executeResultHandler);
        JAXBContext jaxbCtx = KnowledgeBuilderHelper.newJAXBContext((String[])jaxbConf.getClasses().toArray(new String[jaxbConf.getClasses().size()]), (KnowledgeBase)kbase);
        Unmarshaller unmarshaller = jaxbCtx.createUnmarshaller();
        Transformer transformer = PipelineFactory.newJaxbFromXmlTransformer((Unmarshaller)unmarshaller);
        transformer.setReceiver((Receiver)insertStage);
        Pipeline pipeline = PipelineFactory.newStatefulKnowledgeSessionPipeline((StatefulKnowledgeSession)ksession);
        pipeline.setReceiver((Receiver)transformer);
        ResultHandlerImpl resultHandler = new ResultHandlerImpl();
        pipeline.insert((Object)new StreamSource(((Object)((Object)this)).getClass().getResourceAsStream("order.xml")), (ResultHandler)resultHandler);
        ksession.fireAllRules();
        Map handles = (Map)resultHandler.getObject();
        ksession.fireAllRules();
        JaxbTest.assertEquals((int)1, (int)handles.size());
        JaxbTest.assertEquals((int)1, (int)list1.size());
        JaxbTest.assertEquals((String)"org.drools.model.order.Order", (String)list1.get(0).getClass().getName());
    }

    public void testNestedIterable() throws Exception {
        Options xjcOpts = new Options();
        xjcOpts.setSchemaLanguage(Language.XMLSCHEMA);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        JaxbConfiguration jaxbConf = KnowledgeBuilderFactory.newJaxbConfiguration((Options)xjcOpts, (String)"xsd");
        kbuilder.add(ResourceFactory.newClassPathResource((String)"order.xsd", ((Object)((Object)this)).getClass()), ResourceType.XSD, (ResourceConfiguration)jaxbConf);
        JaxbTest.assertFalse((boolean)kbuilder.hasErrors());
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_Jaxb.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list1 = new ArrayList();
        ArrayList list2 = new ArrayList();
        ksession.setGlobal("list1", list1);
        ksession.setGlobal("list2", list2);
        Action executeResultHandler = PipelineFactory.newExecuteResultHandler();
        KnowledgeRuntimeCommand insertStage = PipelineFactory.newStatefulKnowledgeSessionInsert();
        insertStage.setReceiver((Receiver)executeResultHandler);
        Splitter splitter = PipelineFactory.newIterateSplitter();
        splitter.setReceiver((Receiver)insertStage);
        Expression expression = PipelineFactory.newMvelExpression((String)"this.orderItem");
        expression.setReceiver((Receiver)splitter);
        JAXBContext jaxbCtx = KnowledgeBuilderHelper.newJAXBContext((String[])jaxbConf.getClasses().toArray(new String[jaxbConf.getClasses().size()]), (KnowledgeBase)kbase);
        Unmarshaller unmarshaller = jaxbCtx.createUnmarshaller();
        Transformer transformer = PipelineFactory.newJaxbFromXmlTransformer((Unmarshaller)unmarshaller);
        transformer.setReceiver((Receiver)expression);
        Pipeline pipeline = PipelineFactory.newStatefulKnowledgeSessionPipeline((StatefulKnowledgeSession)ksession);
        pipeline.setReceiver((Receiver)transformer);
        ResultHandlerImpl resultHandler = new ResultHandlerImpl();
        pipeline.insert((Object)new StreamSource(((Object)((Object)this)).getClass().getResourceAsStream("order.xml")), (ResultHandler)resultHandler);
        Map handles = (Map)resultHandler.getObject();
        ksession.fireAllRules();
        JaxbTest.assertEquals((int)2, (int)handles.size());
        JaxbTest.assertEquals((int)1, (int)list1.size());
        JaxbTest.assertEquals((int)1, (int)list2.size());
        JaxbTest.assertEquals((String)"org.drools.model.order.Order$OrderItem", (String)list1.get(0).getClass().getName());
        JaxbTest.assertEquals((String)"org.drools.model.order.Order$OrderItem", (String)list2.get(0).getClass().getName());
        JaxbTest.assertNotSame(list1.get(0), list2.get(0));
    }

    public static class ResultHandlerImpl
    implements ResultHandler {
        Object object;

        public void handleResult(Object object) {
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }
    }
}

