/*
 * Decompiled with CFR 0.152.
 */
package org.drools.runtime.pipeline.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import junit.framework.TestCase;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.pipeline.Action;
import org.drools.runtime.pipeline.Expression;
import org.drools.runtime.pipeline.KnowledgeRuntimeCommand;
import org.drools.runtime.pipeline.Pipeline;
import org.drools.runtime.pipeline.PipelineFactory;
import org.drools.runtime.pipeline.Receiver;
import org.drools.runtime.pipeline.ResultHandler;
import org.drools.runtime.pipeline.Splitter;
import org.drools.runtime.pipeline.Transformer;
import org.milyn.Smooks;
import org.milyn.io.StreamUtils;

public class SmookStatefulSessionTest
extends TestCase {
    public void testDirectRoot() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_SmooksDirectRoot.drl", SmookStatefulSessionTest.class), ResourceType.DRL);
        SmookStatefulSessionTest.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Action executeResultHandler = PipelineFactory.newExecuteResultHandler();
        KnowledgeRuntimeCommand insertStage = PipelineFactory.newStatefulKnowledgeSessionInsert();
        insertStage.setReceiver((Receiver)executeResultHandler);
        Smooks smooks = new Smooks(((Object)((Object)this)).getClass().getResourceAsStream("smooks-config.xml"));
        Transformer transformer = PipelineFactory.newSmooksFromSourceTransformer((Smooks)smooks, (String)"orderItem");
        transformer.setReceiver((Receiver)insertStage);
        Pipeline pipeline = PipelineFactory.newStatefulKnowledgeSessionPipeline((StatefulKnowledgeSession)ksession);
        pipeline.setReceiver((Receiver)transformer);
        ResultHandlerImpl resultHandler = new ResultHandlerImpl();
        pipeline.insert((Object)((Object)((Object)this)).getClass().getResourceAsStream("SmooksDirectRoot.xml"), (ResultHandler)resultHandler);
        ksession.fireAllRules();
        Map handles = (Map)resultHandler.getObject();
        SmookStatefulSessionTest.assertEquals((int)1, (int)handles.size());
        SmookStatefulSessionTest.assertEquals((int)1, (int)list.size());
        SmookStatefulSessionTest.assertEquals((String)"example.OrderItem", (String)list.get(0).getClass().getName());
    }

    public void testNestedIterable() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_SmooksNestedIterable.drl", SmookStatefulSessionTest.class), ResourceType.DRL);
        SmookStatefulSessionTest.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Action executeResultHandler = PipelineFactory.newExecuteResultHandler();
        KnowledgeRuntimeCommand insertStage = PipelineFactory.newStatefulKnowledgeSessionInsert();
        insertStage.setReceiver((Receiver)executeResultHandler);
        Splitter splitter = PipelineFactory.newIterateSplitter();
        splitter.setReceiver((Receiver)insertStage);
        Expression expression = PipelineFactory.newMvelExpression((String)"children");
        expression.setReceiver((Receiver)splitter);
        Smooks smooks = new Smooks(((Object)((Object)this)).getClass().getResourceAsStream("smooks-config.xml"));
        Transformer transformer = PipelineFactory.newSmooksFromSourceTransformer((Smooks)smooks, (String)"root");
        transformer.setReceiver((Receiver)expression);
        Pipeline pipeline = PipelineFactory.newStatefulKnowledgeSessionPipeline((StatefulKnowledgeSession)ksession);
        pipeline.setReceiver((Receiver)transformer);
        ResultHandlerImpl resultHandler = new ResultHandlerImpl();
        pipeline.insert((Object)new StreamSource(((Object)((Object)this)).getClass().getResourceAsStream("SmooksNestedIterable.xml")), (ResultHandler)resultHandler);
        Map handles = (Map)resultHandler.getObject();
        ksession.fireAllRules();
        SmookStatefulSessionTest.assertEquals((int)2, (int)handles.size());
        SmookStatefulSessionTest.assertEquals((int)2, (int)list.size());
        SmookStatefulSessionTest.assertEquals((String)"example.OrderItem", (String)list.get(0).getClass().getName());
        SmookStatefulSessionTest.assertEquals((String)"example.OrderItem", (String)list.get(1).getClass().getName());
        SmookStatefulSessionTest.assertNotSame(list.get(0), list.get(1));
    }

    private static byte[] readInputMessage(InputStream stream) {
        try {
            return StreamUtils.readStream((InputStream)stream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "<no-message/>".getBytes();
        }
    }

    public static class ResultHandlerImpl
    implements ResultHandler {
        Object object;

        public void handleResult(Object object) {
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }
    }
}

