/*
 * Decompiled with CFR 0.152.
 */
package org.drools.runtime.pipeline.impl;

import com.thoughtworks.xstream.XStream;
import java.util.Map;
import junit.framework.TestCase;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.ElementQualifier;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.examples.RecursiveElementNameAndTextQualifier;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.pipeline.Action;
import org.drools.runtime.pipeline.KnowledgeRuntimeCommand;
import org.drools.runtime.pipeline.Pipeline;
import org.drools.runtime.pipeline.PipelineFactory;
import org.drools.runtime.pipeline.Receiver;
import org.drools.runtime.pipeline.ResultHandler;
import org.drools.runtime.pipeline.Transformer;
import org.drools.runtime.pipeline.impl.XStreamStatefulSessionTest;
import org.drools.runtime.rule.FactHandle;

public class XStreamFactTest
extends TestCase {
    protected void setUp() throws Exception {
        XMLUnit.setIgnoreComments((boolean)true);
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreAttributeOrder((boolean)true);
        XMLUnit.setNormalizeWhitespace((boolean)true);
        XMLUnit.setNormalize((boolean)true);
    }

    private void assertXMLEqual(String expectedXml, String resultXml) {
        try {
            Diff diff = new Diff(expectedXml, resultXml);
            diff.overrideElementQualifier((ElementQualifier)new RecursiveElementNameAndTextQualifier());
            XMLAssert.assertXMLEqual((Diff)diff, (boolean)true);
        }
        catch (Exception e) {
            throw new RuntimeException("XML Assertion failure", e);
        }
    }

    public void testFact() throws Exception {
        String xml = "";
        xml = xml + "<list>\n";
        xml = xml + "  <example.OrderItem>\n";
        xml = xml + "    <price>8.9</price>\n";
        xml = xml + "    <productId>111</productId>\n";
        xml = xml + "    <quantity>2</quantity>\n";
        xml = xml + "  </example.OrderItem>\n";
        xml = xml + "</list>\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_XStreamDirectRoot.drl", XStreamStatefulSessionTest.class), ResourceType.DRL);
        XStreamFactTest.assertFalse((boolean)kbuilder.hasErrors());
        XStreamFactTest.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Action executeResultHandler = PipelineFactory.newExecuteResultHandler();
        KnowledgeRuntimeCommand insertStage = PipelineFactory.newStatefulKnowledgeSessionInsert();
        insertStage.setReceiver((Receiver)executeResultHandler);
        XStream xstream = new XStream();
        Transformer transformer = PipelineFactory.newXStreamFromXmlTransformer((XStream)xstream);
        transformer.setReceiver((Receiver)insertStage);
        Pipeline pipeline = PipelineFactory.newStatefulKnowledgeSessionPipeline((StatefulKnowledgeSession)ksession);
        pipeline.setReceiver((Receiver)transformer);
        XStreamStatefulSessionTest.ResultHandlerImpl resultHandler = new XStreamStatefulSessionTest.ResultHandlerImpl();
        pipeline.insert((Object)xml, (ResultHandler)resultHandler);
        FactHandle factHandle = (FactHandle)((Map)resultHandler.getObject()).keySet().iterator().next();
        XStreamFactTest.assertNotNull((Object)factHandle);
        Action executeResult = PipelineFactory.newExecuteResultHandler();
        Action assignAsResult = PipelineFactory.newAssignObjectAsResult();
        assignAsResult.setReceiver((Receiver)executeResult);
        transformer = PipelineFactory.newXStreamToXmlTransformer((XStream)xstream);
        transformer.setReceiver((Receiver)assignAsResult);
        KnowledgeRuntimeCommand getObject = PipelineFactory.newStatefulKnowledgeSessionGetObject();
        getObject.setReceiver((Receiver)transformer);
        pipeline = PipelineFactory.newStatefulKnowledgeSessionPipeline((StatefulKnowledgeSession)ksession);
        pipeline.setReceiver((Receiver)getObject);
        resultHandler = new XStreamStatefulSessionTest.ResultHandlerImpl();
        pipeline.insert((Object)factHandle, (ResultHandler)resultHandler);
        this.assertXMLEqual(xml, (String)resultHandler.getObject());
    }

    private static void assertEqualsIgnoreWhitespace(String expected, String actual) {
        String cleanExpected = expected.replaceAll("\\s+", "");
        String cleanActual = actual.replaceAll("\\s+", "");
        XStreamFactTest.assertEquals((String)cleanExpected, (String)cleanActual);
    }
}

