/*
 * Decompiled with CFR 0.152.
 */
package org.drools.runtime.pipeline.impl;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatelessKnowledgeSession;
import org.drools.runtime.pipeline.Action;
import org.drools.runtime.pipeline.Expression;
import org.drools.runtime.pipeline.KnowledgeRuntimeCommand;
import org.drools.runtime.pipeline.Pipeline;
import org.drools.runtime.pipeline.PipelineFactory;
import org.drools.runtime.pipeline.Receiver;
import org.drools.runtime.pipeline.ResultHandler;
import org.drools.runtime.pipeline.Transformer;
import org.drools.runtime.pipeline.impl.XStreamStatefulSessionTest;

public class XStreamStatelessSessionTest
extends TestCase {
    public void testXstreamDirectRoot() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_XStreamDirectRoot.drl", XStreamStatefulSessionTest.class), ResourceType.DRL);
        XStreamStatelessSessionTest.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatelessKnowledgeSession ksession = kbase.newStatelessKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Action executeResultHandler = PipelineFactory.newExecuteResultHandler();
        Action assignResult = PipelineFactory.newAssignObjectAsResult();
        assignResult.setReceiver((Receiver)executeResultHandler);
        KnowledgeRuntimeCommand batchExecution = PipelineFactory.newCommandExecutor();
        batchExecution.setReceiver((Receiver)assignResult);
        KnowledgeRuntimeCommand insertStage = PipelineFactory.newInsertObjectCommand();
        insertStage.setReceiver((Receiver)batchExecution);
        XStream xstream = new XStream();
        Transformer transformer = PipelineFactory.newXStreamFromXmlTransformer((XStream)xstream);
        transformer.setReceiver((Receiver)insertStage);
        Pipeline pipeline = PipelineFactory.newStatelessKnowledgeSessionPipeline((StatelessKnowledgeSession)ksession);
        pipeline.setReceiver((Receiver)transformer);
        ResultHandlerImpl resultHandler = new ResultHandlerImpl();
        pipeline.insert((Object)((Object)((Object)this)).getClass().getResourceAsStream("XStreamDirectRoot.xml"), (ResultHandler)resultHandler);
        XStreamStatelessSessionTest.assertEquals((int)1, (int)list.size());
        XStreamStatelessSessionTest.assertEquals((String)"example.OrderItem", (String)list.get(0).getClass().getName());
    }

    public void testXstreamNestedIterable() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_XStreamNestedIterable.drl", XStreamStatefulSessionTest.class), ResourceType.DRL);
        XStreamStatelessSessionTest.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatelessKnowledgeSession ksession = kbase.newStatelessKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Action executeResultHandler = PipelineFactory.newExecuteResultHandler();
        Action assignResult = PipelineFactory.newAssignObjectAsResult();
        assignResult.setReceiver((Receiver)executeResultHandler);
        KnowledgeRuntimeCommand batchExecution = PipelineFactory.newCommandExecutor();
        batchExecution.setReceiver((Receiver)assignResult);
        KnowledgeRuntimeCommand insertElementsStage = PipelineFactory.newInsertElementsCommand();
        insertElementsStage.setReceiver((Receiver)batchExecution);
        Expression mvelExpression = PipelineFactory.newMvelExpression((String)"this.children");
        mvelExpression.setReceiver((Receiver)insertElementsStage);
        XStream xstream = new XStream();
        Transformer transformer = PipelineFactory.newXStreamFromXmlTransformer((XStream)xstream);
        transformer.setReceiver((Receiver)insertElementsStage);
        Pipeline pipeline = PipelineFactory.newStatelessKnowledgeSessionPipeline((StatelessKnowledgeSession)ksession);
        pipeline.setReceiver((Receiver)transformer);
        ResultHandlerImpl resultHandler = new ResultHandlerImpl();
        pipeline.insert((Object)((Object)((Object)this)).getClass().getResourceAsStream("XStreamNestedIterable.xml"), (ResultHandler)resultHandler);
        XStreamStatelessSessionTest.assertEquals((String)"example.OrderItem", (String)list.get(0).getClass().getName());
        XStreamStatelessSessionTest.assertEquals((String)"example.OrderItem", (String)list.get(1).getClass().getName());
        XStreamStatelessSessionTest.assertNotSame(list.get(0), list.get(1));
    }

    public static class ResultHandlerImpl
    implements ResultHandler {
        Object object;

        public void handleResult(Object object) {
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }
    }
}

