/*
 * Decompiled with CFR 0.152.
 */
package org.drools.runtime.pipeline.impl;

import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.activemq.broker.BrokerService;

public class SimpleConsumer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        BrokerService broker = new BrokerService();
        broker.setBrokerName("consumer");
        broker.addConnector("tcp://localhost:61616");
        broker.start();
        InitialContext jndiContext = null;
        ConnectionFactory connectionFactory = null;
        Connection connection = null;
        Session session = null;
        Destination destination = null;
        MessageConsumer consumer = null;
        TextMessage message = null;
        String destinationName = "dynamicQueues/FOO.BAR";
        int NUM_MSGS = 50;
        try {
            Properties props = new Properties();
            props.setProperty("java.naming.factory.initial", "org.apache.activemq.jndi.ActiveMQInitialContextFactory");
            props.setProperty("java.naming.provider.url", "tcp://localhost:61616");
            jndiContext = new InitialContext(props);
        }
        catch (NamingException e) {
            System.out.println("Could not create JNDI API context: " + e.toString());
            System.exit(1);
        }
        try {
            connectionFactory = (ConnectionFactory)jndiContext.lookup("ConnectionFactory");
            destination = (Destination)jndiContext.lookup(destinationName);
        }
        catch (NamingException e) {
            e.printStackTrace();
            System.out.println("JNDI API lookup failed: " + e);
            System.exit(1);
        }
        try {
            connection = connectionFactory.createConnection();
            session = connection.createSession(false, 1);
            consumer = session.createConsumer(destination);
            connection.start();
            for (int i = 0; i < 50; ++i) {
                Message msg = consumer.receive();
                System.out.println("received : " + msg);
                if (!(msg instanceof TextMessage)) continue;
                message = (TextMessage)msg;
                System.out.println(message.getText());
            }
        }
        catch (JMSException e) {
            System.out.println("Exception occurred: " + (Object)((Object)e));
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {}
            }
        }
    }
}

