/*
 * Decompiled with CFR 0.152.
 */
package org.drools.runtime.pipeline.impl;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.ElementQualifier;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.examples.RecursiveElementNameAndTextQualifier;
import org.drools.ChangeCollector;
import org.drools.Cheese;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.KnowledgeBaseFactoryService;
import org.drools.Person;
import org.drools.TestVariable;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.KnowledgeBuilderFactoryService;
import org.drools.builder.ResourceType;
import org.drools.command.runtime.rule.ModifyCommand;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.grid.GridNode;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.io.Resource;
import org.drools.io.ResourceFactory;
import org.drools.runtime.ExecutionResults;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.StatelessKnowledgeSession;
import org.drools.runtime.help.BatchExecutionHelper;
import org.drools.runtime.pipeline.Action;
import org.drools.runtime.pipeline.KnowledgeRuntimeCommand;
import org.drools.runtime.pipeline.Pipeline;
import org.drools.runtime.pipeline.PipelineFactory;
import org.drools.runtime.pipeline.Receiver;
import org.drools.runtime.pipeline.ResultHandler;
import org.drools.runtime.pipeline.Transformer;
import org.drools.runtime.pipeline.impl.ExecutionNodePipelineImpl;
import org.drools.runtime.pipeline.impl.XStreamFromXmlGridTransformer;
import org.drools.runtime.pipeline.impl.XStreamResolverStrategy;
import org.drools.runtime.pipeline.impl.XStreamToXmlGridTransformer;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;
import org.drools.runtime.process.WorkflowProcessInstance;
import org.drools.runtime.rule.FactHandle;
import org.drools.runtime.rule.QueryResults;
import org.drools.runtime.rule.QueryResultsRow;
import org.drools.util.CompositeClassLoader;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXException;

public class JSonBatchExecutionTest {
    @Before
    public void setUp() throws Exception {
        XMLUnit.setIgnoreComments((boolean)true);
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreAttributeOrder((boolean)true);
        XMLUnit.setNormalizeWhitespace((boolean)true);
        XMLUnit.setNormalize((boolean)true);
    }

    private void assertXMLEqual(String expectedXml, String resultXml) {
        try {
            Diff diff = new Diff(expectedXml, resultXml);
            diff.overrideElementQualifier((ElementQualifier)new RecursiveElementNameAndTextQualifier());
            XMLAssert.assertXMLEqual((Diff)diff, (boolean)true);
        }
        catch (Exception e) {
            throw new RuntimeException("XML Assertion failure", e);
        }
    }

    @Test
    public void testListenForChanges() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import org.drools.Cheese \n";
        str = str + "import org.drools.ChangeCollector \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese(price==25) \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "end\n";
        str = str + "rule rule2 \n";
        str = str + "  when \n";
        str = str + "    p : Person(name=='mic') \n";
        str = str + "    c : Cheese(price != 42) \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    c.setPrice( 42 ); \n";
        str = str + "    update(c); \n";
        str = str + "end\n";
        str = str + "rule rule3 \n";
        str = str + "  when \n";
        str = str + "    p : Person(name=='mark') \n";
        str = str + "    c : Cheese(price == 42) \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    retract(c); \n";
        str = str + "end\n";
        str = str + "rule ruleBootStrap \n";
        str = str + "salience 10000\n";
        str = str + "  when \n";
        str = str + "    $c : ChangeCollector() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    kcontext.getKnowledgeRuntime().addEventListener($c); \n";
        str = str + "end\n";
        str = str + "rule ruleCleanup \n";
        str = str + "salience -10000\n";
        str = str + "  when \n";
        str = str + "    $c : ChangeCollector() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    kcontext.getKnowledgeRuntime().removeEventListener($c); \n";
        str = str + "    retract($c); \n";
        str = str + "end\n";
        String inXml = "";
        inXml = inXml + "{\"batch-execution\":{\"commands\":[";
        inXml = inXml + "{\"insert\":{\"object\":{\"org.drools.Cheese\":{\"type\":\"stilton\",\"price\":25,\"oldPrice\":0}}, \"out-identifier\":\"outStilton\" } }";
        inXml = inXml + ", {\"fire-all-rules\":\"\"}";
        inXml = inXml + "]}}";
        inXml = this.roundTripFromXml(inXml);
        StatefulKnowledgeSession ksession = this.getSessionStateful(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        ResultHandlerImpl resultHandler = new ResultHandlerImpl();
        this.getPipelineStateful(ksession).insert((Object)inXml, (ResultHandler)resultHandler);
        inXml = "";
        inXml = inXml + "{\"batch-execution\":{\"commands\":[";
        inXml = inXml + "   {\"insert\":{\"object\":{\"org.drools.Person\":{\"name\":\"mic\"} }, \"out-identifier\":\"person\" } }";
        inXml = inXml + ",  {\"insert\":{\"object\":{\"org.drools.ChangeCollector\":{} }, \"out-identifier\":\"changes\" } }";
        inXml = inXml + ",  {\"fire-all-rules\":\"\"}";
        inXml = inXml + "]}}";
        inXml = this.roundTripFromXml(inXml);
        resultHandler = new ResultHandlerImpl();
        this.getPipelineStateful(ksession).insert((Object)inXml, (ResultHandler)resultHandler);
        String outXml = (String)resultHandler.getObject();
        outXml = this.roundTripFromXml(outXml);
        ExecutionResults result = (ExecutionResults)BatchExecutionHelper.newJSonMarshaller().fromXML(outXml);
        result = (ExecutionResults)this.roundTripFromObject(result);
        ChangeCollector collector = (ChangeCollector)result.getValue("changes");
        Cheese c = (Cheese)collector.getChanges().get(0);
        Assert.assertEquals((long)42L, (long)c.getPrice());
        inXml = "";
        inXml = inXml + "{\"batch-execution\":{\"commands\":[";
        inXml = inXml + "   {\"insert\":{\"object\":{\"org.drools.Person\":{\"name\":\"mark\"} }, \"out-identifier\":\"person\" } }";
        inXml = inXml + ",  {\"insert\":{\"object\":{\"org.drools.ChangeCollector\":{} }, \"out-identifier\":\"changes\" } }";
        inXml = inXml + ",  {\"fire-all-rules\":\"\"}";
        inXml = inXml + "]}}";
        inXml = this.roundTripFromXml(inXml);
        resultHandler = new ResultHandlerImpl();
        this.getPipelineStateful(ksession).insert((Object)inXml, (ResultHandler)resultHandler);
        outXml = (String)resultHandler.getObject();
        outXml = this.roundTripFromXml(outXml);
        result = (ExecutionResults)BatchExecutionHelper.newJSonMarshaller().fromXML(outXml);
        result = (ExecutionResults)this.roundTripFromObject(result);
        collector = (ChangeCollector)result.getValue("changes");
        Assert.assertEquals((Object)"stilton", (Object)collector.getRetracted().get(0));
    }

    @Test
    public void testInsertWithDefaults() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import org.drools.Cheese \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n";
        str = str + "end\n";
        String inXml = "";
        inXml = inXml + "{\"batch-execution\":{\"commands\":[";
        inXml = inXml + "{\"insert\":{\"object\":{\"org.drools.Cheese\":{\"type\":\"stilton\",\"price\":25,\"oldPrice\":0}}, \"out-identifier\":\"outStilton\" } }";
        inXml = inXml + ", {\"fire-all-rules\":\"\"}";
        inXml = inXml + "]}}";
        inXml = this.roundTripFromXml(inXml);
        StatefulKnowledgeSession ksession = this.getSessionStateful(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        ResultHandlerImpl resultHandler = new ResultHandlerImpl();
        this.getPipelineStateful(ksession).insert((Object)inXml, (ResultHandler)resultHandler);
        String outXml = (String)resultHandler.getObject();
        outXml = this.roundTripFromXml(outXml);
        ExecutionResults result = (ExecutionResults)BatchExecutionHelper.newJSonMarshaller().fromXML(outXml);
        result = (ExecutionResults)this.roundTripFromObject(result);
        Cheese stilton = (Cheese)result.getValue("outStilton");
        Assert.assertEquals((long)30L, (long)stilton.getPrice());
        FactHandle factHandle = (FactHandle)result.getFactHandle("outStilton");
        stilton = (Cheese)ksession.getObject(factHandle);
        Assert.assertEquals((long)30L, (long)stilton.getPrice());
    }

    @Test
    public void testInsertWithReturnObjectFalse() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import org.drools.Cheese \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n";
        str = str + "end\n";
        String inXml = "";
        inXml = inXml + "{\"batch-execution\":{\"commands\":[";
        inXml = inXml + "{\"insert\":{\"object\":{\"org.drools.Cheese\":{\"type\":\"stilton\",\"price\":25,\"oldPrice\":0}}, \"return-object\":false, \"out-identifier\":\"outStilton\" } }";
        inXml = inXml + ", {\"fire-all-rules\":\"\"}";
        inXml = inXml + "]}}";
        inXml = this.roundTripFromXml(inXml);
        StatefulKnowledgeSession ksession = this.getSessionStateful(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        ResultHandlerImpl resultHandler = new ResultHandlerImpl();
        this.getPipelineStateful(ksession).insert((Object)inXml, (ResultHandler)resultHandler);
        String outXml = (String)resultHandler.getObject();
        outXml = this.roundTripFromXml(outXml);
        ExecutionResults result = (ExecutionResults)BatchExecutionHelper.newJSonMarshaller().fromXML(outXml);
        result = (ExecutionResults)this.roundTripFromObject(result);
        Assert.assertNull((Object)result.getValue("outStilton"));
        FactHandle factHandle = (FactHandle)result.getFactHandle("outStilton");
        Cheese stilton = (Cheese)ksession.getObject(factHandle);
        Assert.assertEquals((long)30L, (long)stilton.getPrice());
    }

    @Test
    public void testGetObject() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import org.drools.Cheese \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n";
        str = str + "end\n";
        String inXml = "";
        inXml = inXml + "{\"batch-execution\":{\"commands\":[";
        inXml = inXml + "{\"insert\":{\"object\":{\"org.drools.Cheese\":{\"type\":\"stilton\",\"price\":25,\"oldPrice\":0}}, \"out-identifier\":\"outStilton\" } }";
        inXml = inXml + ", {\"fire-all-rules\":{\"max\":10}}";
        inXml = inXml + "]}}";
        inXml = this.roundTripFromXml(inXml);
        StatefulKnowledgeSession ksession = this.getSessionStateful(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        ResultHandlerImpl resultHandler = new ResultHandlerImpl();
        this.getPipelineStateful(ksession).insert((Object)inXml, (ResultHandler)resultHandler);
        String outXml = (String)resultHandler.getObject();
        outXml = this.roundTripFromXml(outXml);
        ExecutionResults result = (ExecutionResults)BatchExecutionHelper.newJSonMarshaller().fromXML(outXml);
        result = (ExecutionResults)this.roundTripFromObject(result);
        Cheese stilton = (Cheese)result.getValue("outStilton");
        Assert.assertEquals((long)30L, (long)stilton.getPrice());
        FactHandle factHandle = (FactHandle)result.getFactHandle("outStilton");
        inXml = "";
        inXml = inXml + "{\"batch-execution\":{\"commands\":[";
        inXml = inXml + "  {\"get-object\":{ ";
        inXml = inXml + "      \"out-identifier\":'outStilton',";
        inXml = inXml + "      \"fact-handle\":'" + factHandle.toExternalForm() + "'}}";
        inXml = inXml + "]}}";
        inXml = this.roundTripFromXml(inXml);
        this.getPipelineStateful(ksession).insert((Object)inXml, (ResultHandler)resultHandler);
        outXml = (String)resultHandler.getObject();
        outXml = this.roundTripFromXml(outXml);
        result = (ExecutionResults)BatchExecutionHelper.newJSonMarshaller().fromXML(outXml);
        result = (ExecutionResults)this.roundTripFromObject(result);
        stilton = (Cheese)result.getValue("outStilton");
        Assert.assertEquals((long)30L, (long)stilton.getPrice());
    }

    @Test
    public void testRetractObject() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import org.drools.Cheese \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n";
        str = str + "end\n";
        String inXml = "";
        inXml = inXml + "{\"batch-execution\":{\"commands\":[";
        inXml = inXml + "{\"insert\":{\"object\":{\"org.drools.Cheese\":{\"type\":\"stilton\",\"price\":25,\"oldPrice\":0}}, \"out-identifier\":\"outStilton\" } }";
        inXml = inXml + ", {\"fire-all-rules\":{\"max\":10}}";
        inXml = inXml + "]}}";
        inXml = this.roundTripFromXml(inXml);
        StatefulKnowledgeSession ksession = this.getSessionStateful(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        ResultHandlerImpl resultHandler = new ResultHandlerImpl();
        this.getPipelineStateful(ksession).insert((Object)inXml, (ResultHandler)resultHandler);
        String outXml = (String)resultHandler.getObject();
        outXml = this.roundTripFromXml(outXml);
        ExecutionResults result = (ExecutionResults)BatchExecutionHelper.newJSonMarshaller().fromXML(outXml);
        result = (ExecutionResults)this.roundTripFromObject(result);
        Cheese stilton = (Cheese)result.getValue("outStilton");
        Assert.assertEquals((long)30L, (long)stilton.getPrice());
        FactHandle factHandle = (FactHandle)result.getFactHandle("outStilton");
        inXml = "";
        inXml = inXml + "{\"batch-execution\":{\"commands\":[";
        inXml = inXml + "  { \"retract\":{\"fact-handle\":'" + factHandle.toExternalForm() + "'}}";
        inXml = inXml + "]}}";
        inXml = this.roundTripFromXml(inXml);
        this.getPipelineStateful(ksession).insert((Object)inXml, (ResultHandler)resultHandler);
        inXml = "";
        inXml = inXml + "{\"batch-execution\":{\"commands\":[";
        inXml = inXml + "  {\"get-object\":{ ";
        inXml = inXml + "      \"out-identifier\":'outStilton',";
        inXml = inXml + "      \"fact-handle\":'" + factHandle.toExternalForm() + "'}}";
        inXml = inXml + "]}}";
        inXml = this.roundTripFromXml(inXml);
        this.getPipelineStateful(ksession).insert((Object)inXml, (ResultHandler)resultHandler);
        outXml = (String)resultHandler.getObject();
        result = (ExecutionResults)BatchExecutionHelper.newJSonMarshaller().fromXML(outXml);
        result = (ExecutionResults)this.roundTripFromObject(result);
        Assert.assertNull((Object)result.getValue("outStilton"));
    }

    @Test
    public void testModifyObject() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import org.drools.Cheese \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n";
        str = str + "end\n";
        String inXml = "";
        inXml = inXml + "{\"batch-execution\":{\"commands\":[";
        inXml = inXml + "{\"insert\":{\"object\":{\"org.drools.Cheese\":{\"type\":\"stilton\",\"price\":25,\"oldPrice\":0}}, \"out-identifier\":\"outStilton\" } }";
        inXml = inXml + ", {\"fire-all-rules\":\"\"}";
        inXml = inXml + "]}}";
        inXml = this.roundTripFromXml(inXml);
        StatefulKnowledgeSession ksession = this.getSessionStateful(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        ResultHandlerImpl resultHandler = new ResultHandlerImpl();
        this.getPipelineStateful(ksession).insert((Object)inXml, (ResultHandler)resultHandler);
        String outXml = (String)resultHandler.getObject();
        outXml = this.roundTripFromXml(outXml);
        ExecutionResults result = (ExecutionResults)BatchExecutionHelper.newJSonMarshaller().fromXML(outXml);
        result = (ExecutionResults)this.roundTripFromObject(result);
        Cheese stilton = (Cheese)result.getValue("outStilton");
        Assert.assertEquals((long)30L, (long)stilton.getPrice());
        FactHandle factHandle = (FactHandle)result.getFactHandle("outStilton");
        inXml = "";
        inXml = inXml + "{\"batch-execution\":{\"commands\":[";
        inXml = inXml + "  {\"modify\":{\"fact-handle\":'" + factHandle.toExternalForm() + "'";
        inXml = inXml + ",                \"setters\":[{\"accessor\":\"oldPrice\",\"set\":42}, {\"accessor\":\"price\",\"set\":50}]";
        inXml = inXml + "} }";
        inXml = inXml + ", {\"fire-all-rules\":\"\"}";
        inXml = inXml + "]}}";
        inXml = this.roundTripFromXml(inXml);
        this.getPipelineStateful(ksession).insert((Object)inXml, (ResultHandler)resultHandler);
        inXml = "";
        inXml = inXml + "{\"batch-execution\":{\"commands\":[";
        inXml = inXml + "  {\"get-object\":{ ";
        inXml = inXml + "      \"out-identifier\":'outCheddar',";
        inXml = inXml + "      \"fact-handle\":'" + factHandle.toExternalForm() + "'}}";
        inXml = inXml + "]}}";
        inXml = this.roundTripFromXml(inXml);
        this.getPipelineStateful(ksession).insert((Object)inXml, (ResultHandler)resultHandler);
        outXml = (String)resultHandler.getObject();
        outXml = this.roundTripFromXml(outXml);
        result = (ExecutionResults)BatchExecutionHelper.newJSonMarshaller().fromXML(outXml);
        result = (ExecutionResults)this.roundTripFromObject(result);
        Cheese cheddar = (Cheese)result.getValue("outCheddar");
        Assert.assertEquals((long)42L, (long)cheddar.getOldPrice());
        Assert.assertEquals((long)55L, (long)cheddar.getPrice());
        ModifyCommand.ALLOW_MODIFY_EXPRESSIONS = false;
        inXml = "";
        inXml = inXml + "{\"batch-execution\":{\"commands\":[";
        inXml = inXml + "  {\"modify\":{\"fact-handle\":'" + factHandle.toExternalForm() + "'";
        inXml = inXml + ",                \"setters\":[{\"accessor\":\"type\",\"set\":\"44; System.exit(1);\"}, {\"accessor\":\"price\",\"set\":50}]";
        inXml = inXml + "} }";
        inXml = inXml + ", {\"fire-all-rules\":\"\"}";
        inXml = inXml + "]}}";
        inXml = this.roundTripFromXml(inXml);
        this.getPipelineStateful(ksession).insert((Object)inXml, (ResultHandler)resultHandler);
        outXml = (String)resultHandler.getObject();
        result = (ExecutionResults)BatchExecutionHelper.newJSonMarshaller().fromXML(outXml);
        ModifyCommand.ALLOW_MODIFY_EXPRESSIONS = true;
    }

    @Test
    public void testInsertElements() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import org.drools.Cheese \n";
        str = str + "global java.util.List list1 \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n";
        str = str + "     list1.add( $c );";
        str = str + "end\n";
        String inXml = "";
        inXml = inXml + "{\"batch-execution\":{\"commands\":[";
        inXml = inXml + "   {\"set-global\":{\"identifier\":\"list1\",\"out\"=true";
        inXml = inXml + "                   ,\"object\":{\"list\":{\"object\":[]}}";
        inXml = inXml + "   } } ";
        inXml = inXml + ",  {\"insert-elements\":{\"objects\":[";
        inXml = inXml + "   {   \"org.drools.Cheese\":{\"type\":\"stilton\",\"price\":25,\"oldPrice\":0}}, ";
        inXml = inXml + "   {   \"org.drools.Cheese\":{\"type\":\"stilton\",\"price\":30,\"oldPrice\":0}} ";
        inXml = inXml + "   ]}}";
        inXml = inXml + "]}}";
        inXml = this.roundTripFromXml(inXml);
        StatelessKnowledgeSession ksession = this.getSession2(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        ResultHandlerImpl resultHandler = new ResultHandlerImpl();
        this.getPipeline(ksession).insert((Object)inXml, (ResultHandler)resultHandler);
        String outXml = (String)resultHandler.getObject();
        outXml = this.roundTripFromXml(outXml);
        ExecutionResults result = (ExecutionResults)BatchExecutionHelper.newJSonMarshaller().fromXML(outXml);
        result = (ExecutionResults)this.roundTripFromObject(result);
        List list = (List)result.getValue("list1");
        Cheese stilton25 = new Cheese("stilton", 30);
        Cheese stilton30 = new Cheese("stilton", 35);
        HashSet<Cheese> expectedList = new HashSet<Cheese>();
        expectedList.add(stilton25);
        expectedList.add(stilton30);
        Assert.assertEquals(expectedList, new HashSet(list));
    }

    @Test
    public void testFactHandleReturn() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import org.drools.Cheese \n";
        str = str + "global java.util.List list1 \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    System.err.println(42); \n";
        str = str + "end\n";
        String inXml = "";
        inXml = inXml + "{\"batch-execution\":{\"commands\":[";
        inXml = inXml + "  {\"get-global\":{\"identifier\":\"list1\",\"out-identifier\":\"out-list\"}}";
        inXml = inXml + "]}}";
        inXml = this.roundTripFromXml(inXml);
        StatefulKnowledgeSession ksession = this.getSessionStateful(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        FactHandle fh = ksession.insert((Object)new Person("mic", 42));
        ArrayList<FactHandle> list = new ArrayList<FactHandle>();
        list.add(fh);
        ksession.setGlobal("list1", list);
        ResultHandlerImpl resultHandler = new ResultHandlerImpl();
        this.getPipelineStateful(ksession).insert((Object)inXml, (ResultHandler)resultHandler);
        this.getPipelineStateful(ksession).insert((Object)inXml, (ResultHandler)resultHandler);
        String outXml = (String)resultHandler.getObject();
        outXml = this.roundTripFromXml(outXml);
        ExecutionResults result = (ExecutionResults)BatchExecutionHelper.newJSonMarshaller().fromXML(outXml);
        result = (ExecutionResults)this.roundTripFromObject(result);
        List outList = (List)result.getValue("out-list");
        Assert.assertEquals((long)1L, (long)outList.size());
        Assert.assertEquals((Object)fh.toExternalForm(), (Object)((FactHandle)outList.get(0)).toExternalForm());
        Assert.assertNotSame((Object)fh, outList.get(0));
    }

    @Test
    public void testInsertElementsWithReturnObjects() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import org.drools.Cheese \n";
        str = str + "global java.util.List list1 \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n";
        str = str + "    list1.add( $c );";
        str = str + "end\n";
        String inXml = "";
        inXml = inXml + "{\"batch-execution\":{\"commands\":[";
        inXml = inXml + "   {\"set-global\":{\"identifier\":\"list1\",\"out\"=true";
        inXml = inXml + "                   ,\"object\":{\"list\":{\"object\":[]}}";
        inXml = inXml + "   } } ";
        inXml = inXml + ",  {\"insert-elements\":{\"out-identifier\":\"myfacts\",\"return-objects\":true,\"objects\":[";
        inXml = inXml + "   {   \"org.drools.Cheese\":{\"type\":\"stilton\",\"price\":25,\"oldPrice\":0}}, ";
        inXml = inXml + "   {   \"org.drools.Cheese\":{\"type\":\"stilton\",\"price\":30,\"oldPrice\":0}} ";
        inXml = inXml + "   ]}}";
        inXml = inXml + ", {\"fire-all-rules\":\"\"}";
        inXml = inXml + "]}}";
        inXml = this.roundTripFromXml(inXml);
        StatefulKnowledgeSession ksession = this.getSessionStateful(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        ResultHandlerImpl resultHandler = new ResultHandlerImpl();
        this.getPipelineStateful(ksession).insert((Object)inXml, (ResultHandler)resultHandler);
        String outXml = (String)resultHandler.getObject();
        outXml = this.roundTripFromXml(outXml);
        ExecutionResults result = (ExecutionResults)BatchExecutionHelper.newJSonMarshaller().fromXML(outXml);
        result = (ExecutionResults)this.roundTripFromObject(result);
        List list1 = (List)result.getValue("list1");
        Assert.assertEquals((long)2L, (long)list1.size());
        Assert.assertTrue((boolean)list1.contains(new Cheese("stilton", 35)));
        Assert.assertTrue((boolean)list1.contains(new Cheese("stilton", 30)));
        List myFacts = (List)result.getValue("myfacts");
        Assert.assertEquals((long)2L, (long)list1.size());
        Assert.assertTrue((boolean)myFacts.contains(new Cheese("stilton", 35)));
        Assert.assertTrue((boolean)myFacts.contains(new Cheese("stilton", 30)));
        List factHandles = (List)result.getFactHandle("myfacts");
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(ksession.getObject((FactHandle)((InternalFactHandle)factHandles.get(0))));
        list.add(ksession.getObject((FactHandle)((InternalFactHandle)factHandles.get(1))));
        Assert.assertTrue((boolean)list.contains(new Cheese("stilton", 35)));
        Assert.assertTrue((boolean)list.contains(new Cheese("stilton", 30)));
    }

    @Test
    public void testSetGlobal() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import org.drools.Cheese \n";
        str = str + "global java.util.List list1 \n";
        str = str + "global java.util.List list2 \n";
        str = str + "global java.util.List list3 \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( 30 ); \n";
        str = str + "    list1.add( $c ); \n";
        str = str + "    list2.add( $c ); \n";
        str = str + "    list3.add( $c ); \n";
        str = str + "end\n";
        String inXml = "";
        inXml = inXml + "{\"batch-execution\":{\"commands\":[";
        inXml = inXml + " {\"set-global\":{\"identifier\":\"list1\"";
        inXml = inXml + "                  ,\"object\":{\"list\":{\"object\":[]}}";
        inXml = inXml + "} } ";
        inXml = inXml + ", {\"set-global\":{\"identifier\":\"list2\",\"out\"=true";
        inXml = inXml + "                  ,\"object\":{\"list\":{\"object\":[]}}";
        inXml = inXml + "} } ";
        inXml = inXml + ", {\"set-global\":{\"identifier\":\"list3\",\"out-identifier\"=\"outList3\"";
        inXml = inXml + "                  ,\"object\":{\"list\":{\"object\":[]}}";
        inXml = inXml + "} } ";
        inXml = inXml + ", {\"insert\":{\"object\":{\"org.drools.Cheese\":{\"type\":\"stilton\",\"price\":5}}, \"out-identifier\":\"outStilton\" } }";
        inXml = inXml + "]}}";
        inXml = this.roundTripFromXml(inXml);
        StatelessKnowledgeSession ksession = this.getSession2(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        ResultHandlerImpl resultHandler = new ResultHandlerImpl();
        this.getPipeline(ksession).insert((Object)inXml, (ResultHandler)resultHandler);
        String outXml = (String)resultHandler.getObject();
        outXml = this.roundTripFromXml(outXml);
        ExecutionResults result = (ExecutionResults)BatchExecutionHelper.newJSonMarshaller().fromXML(outXml);
        Cheese stilton = new Cheese("stilton", 30);
        Assert.assertNull((Object)result.getValue("list1"));
        List list2 = (List)result.getValue("list2");
        Assert.assertEquals((long)1L, (long)list2.size());
        Assert.assertEquals((Object)stilton, list2.get(0));
        List list3 = (List)result.getValue("outList3");
        Assert.assertEquals((long)1L, (long)list3.size());
        Assert.assertEquals((Object)stilton, list3.get(0));
    }

    @Test
    public void testGetGlobal() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import org.drools.Cheese \n";
        str = str + "global java.util.List list1 \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    list1.add( $c ); \n";
        str = str + "end\n";
        String inXml = "";
        inXml = inXml + "{\"batch-execution\":{\"commands\":[";
        inXml = inXml + "   {\"set-global\":{\"identifier\":\"list1\",\"out\"=true";
        inXml = inXml + "                   ,\"object\":{\"list\":{\"object\":[]}}";
        inXml = inXml + "   } } ";
        inXml = inXml + ",  {\"insert\":{\"object\":{\"org.drools.Cheese\":{\"type\":\"stilton\",\"price\":25,\"oldPrice\":0}}, \"out-identifier\":\"outStilton\" } }";
        inXml = inXml + ",  {\"get-global\":{\"identifier\":\"list1\",\"out-identifier\"=\"out-list\"}}";
        inXml = inXml + "]}}";
        inXml = this.roundTripFromXml(inXml);
        StatelessKnowledgeSession ksession = this.getSession2(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        ResultHandlerImpl resultHandler = new ResultHandlerImpl();
        this.getPipeline(ksession).insert((Object)inXml, (ResultHandler)resultHandler);
        String outXml = (String)resultHandler.getObject();
        outXml = this.roundTripFromXml(outXml);
        ExecutionResults result = (ExecutionResults)BatchExecutionHelper.newJSonMarshaller().fromXML(outXml);
        result = (ExecutionResults)this.roundTripFromObject(result);
        List resultsList = (List)result.getValue("out-list");
        Assert.assertEquals((long)1L, (long)resultsList.size());
        Assert.assertEquals((Object)new Cheese("stilton", 25), resultsList.get(0));
    }

    @Test
    public void testGetObjects() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import org.drools.Cheese \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n";
        str = str + "end\n";
        String inXml = "";
        inXml = "{\"batch-execution\":{\"commands\":[";
        inXml = inXml + "  {\"insert-elements\":{\"objects\":[";
        inXml = inXml + "   {   \"org.drools.Cheese\":{\"type\":\"stilton\",\"price\":25,\"oldPrice\":0}}, ";
        inXml = inXml + "   {   \"org.drools.Cheese\":{\"type\":\"stilton\",\"price\":30,\"oldPrice\":0}} ";
        inXml = inXml + "   ]}}";
        inXml = inXml + ",  {\"get-objects\":{\"out-identifier\":\"list1\"}}";
        inXml = inXml + "]}}";
        inXml = this.roundTripFromXml(inXml);
        StatelessKnowledgeSession ksession = this.getSession2(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        ResultHandlerImpl resultHandler = new ResultHandlerImpl();
        this.getPipeline(ksession).insert((Object)inXml, (ResultHandler)resultHandler);
        String outXml = (String)resultHandler.getObject();
        outXml = this.roundTripFromXml(outXml);
        ExecutionResults result = (ExecutionResults)BatchExecutionHelper.newJSonMarshaller().fromXML(outXml);
        result = (ExecutionResults)this.roundTripFromObject(result);
        List list = (List)result.getValue("list1");
        Cheese stilton25 = new Cheese("stilton", 30);
        Cheese stilton30 = new Cheese("stilton", 35);
        HashSet<Cheese> expectedList = new HashSet<Cheese>();
        expectedList.add(stilton25);
        expectedList.add(stilton30);
        Assert.assertEquals(expectedList, new HashSet(list));
    }

    @Test
    public void testQuery() throws Exception {
        String str = "";
        str = str + "package org.drools.test  \n";
        str = str + "import org.drools.Cheese \n";
        str = str + "query cheeses \n";
        str = str + "    stilton : Cheese(type == 'stilton') \n";
        str = str + "    cheddar : Cheese(type == 'cheddar', price == stilton.price) \n";
        str = str + "end\n";
        str = str + "query cheesesWithParams(String a, String b) \n";
        str = str + "    stilton : Cheese(type == a) \n";
        str = str + "    cheddar : Cheese(type == b, price == stilton.price) \n";
        str = str + "end\n";
        String inXml = "";
        inXml = "{\"batch-execution\":{\"commands\":[";
        inXml = inXml + "  {\"insert-elements\":{\"objects\":[";
        inXml = inXml + "   {   \"org.drools.Cheese\":{\"type\":\"stilton\",\"price\":2}}, ";
        inXml = inXml + "   {   \"org.drools.Cheese\":{\"type\":\"cheddar\",\"price\":1}}, ";
        inXml = inXml + "   {   \"org.drools.Cheese\":{\"type\":\"cheddar\",\"price\":2}}, ";
        inXml = inXml + "   {   \"org.drools.Cheese\":{\"type\":\"stilton\",\"price\":1}}  ";
        inXml = inXml + "   ]}}";
        inXml = inXml + ",  {\"query\":{\"out-identifier\":\"cheeses\",\"name\":\"cheeses\"}}";
        inXml = inXml + "]}}";
        inXml = this.roundTripFromXml(inXml);
        StatefulKnowledgeSession ksession = this.getSessionStateful(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        ResultHandlerImpl resultHandler = new ResultHandlerImpl();
        this.getPipelineStateful(ksession).insert((Object)inXml, (ResultHandler)resultHandler);
        String outXml = (String)resultHandler.getObject();
        outXml = this.roundTripFromXml(outXml);
        ExecutionResults batchResult = (ExecutionResults)BatchExecutionHelper.newJSonMarshaller().fromXML(outXml);
        batchResult = (ExecutionResults)this.roundTripFromObject(batchResult);
        Cheese stilton1 = new Cheese("stilton", 1);
        Cheese cheddar1 = new Cheese("cheddar", 1);
        Cheese stilton2 = new Cheese("stilton", 2);
        Cheese cheddar2 = new Cheese("cheddar", 2);
        HashSet set = new HashSet();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(stilton1);
        list.add(cheddar1);
        set.add(list);
        list = new ArrayList();
        list.add(stilton2);
        list.add(cheddar2);
        set.add(list);
        QueryResults results = (QueryResults)batchResult.getValue("cheeses");
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((long)2L, (long)results.getIdentifiers().length);
        HashSet<ArrayList<Object>> newSet = new HashSet<ArrayList<Object>>();
        for (QueryResultsRow result : results) {
            list = new ArrayList();
            list.add(result.get("stilton"));
            list.add(result.get("cheddar"));
            newSet.add(list);
        }
        Assert.assertEquals(set, newSet);
    }

    @Test
    public void testManualFireAllRules() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import org.drools.Cheese \n";
        str = str + "global java.util.List list1 \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n";
        str = str + "    list1.add( $c );";
        str = str + "end\n";
        String inXml = "";
        inXml = inXml + "{\"batch-execution\":{\"commands\":[";
        inXml = inXml + "   {\"set-global\":{\"identifier\":\"list1\",\"out\"=true";
        inXml = inXml + "                   ,\"object\":{\"list\":{\"object\":[]}}";
        inXml = inXml + "   } } ";
        inXml = inXml + ",  {\"insert-elements\":{\"objects\":[";
        inXml = inXml + "   {   \"org.drools.Cheese\":{\"type\":\"stilton\",\"price\":25,\"oldPrice\":0}}, ";
        inXml = inXml + "   {   \"org.drools.Cheese\":{\"type\":\"stilton\",\"price\":30,\"oldPrice\":0}} ";
        inXml = inXml + "   ]}}";
        inXml = inXml + ", {\"fire-all-rules\":\"\"}";
        inXml = inXml + ", {\"insert\":{\"object\":{\"org.drools.Cheese\":{\"type\":\"brie\",\"price\":10,\"oldPrice\":0}}, \"out-identifier\":\"outBrie\" } }";
        inXml = inXml + "]}}";
        inXml = this.roundTripFromXml(inXml);
        StatelessKnowledgeSession ksession = this.getSession2(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        ResultHandlerImpl resultHandler = new ResultHandlerImpl();
        this.getPipeline(ksession).insert((Object)inXml, (ResultHandler)resultHandler);
        String outXml = (String)resultHandler.getObject();
        FactHandle factHandle = (FactHandle)((ExecutionResults)BatchExecutionHelper.newJSonMarshaller().fromXML(outXml)).getFactHandle("outBrie");
        ExecutionResults result = (ExecutionResults)BatchExecutionHelper.newJSonMarshaller().fromXML(outXml);
        result = (ExecutionResults)this.roundTripFromObject(result);
        List list = (List)result.getValue("list1");
        Cheese stilton25 = new Cheese("stilton", 30);
        Cheese stilton30 = new Cheese("stilton", 35);
        HashSet<Cheese> expectedList = new HashSet<Cheese>();
        expectedList.add(stilton25);
        expectedList.add(stilton30);
        Assert.assertEquals(expectedList, new HashSet(list));
        Cheese brie10 = new Cheese("brie", 10);
        brie10.setOldPrice(5);
        Assert.assertEquals((Object)brie10, (Object)result.getValue("outBrie"));
    }

    @Test
    public void testProcess() throws SAXException, IOException {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        String str = "";
        str = str + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        str = str + "<process xmlns=\"http://drools.org/drools-5.0/process\"\n";
        str = str + "         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n";
        str = str + "         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n";
        str = str + "         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions\" package-name=\"org.drools\" version=\"1\" >\n";
        str = str + "\n";
        str = str + "  <header>\n";
        str = str + "    <imports>\n";
        str = str + "      <import name=\"org.drools.TestVariable\" />\n";
        str = str + "    </imports>\n";
        str = str + "    <globals>\n";
        str = str + "      <global identifier=\"list1\" type=\"java.util.List\" />\n";
        str = str + "    </globals>\n";
        str = str + "    <variables>\n";
        str = str + "      <variable name=\"person\" >\n";
        str = str + "        <type name=\"org.drools.process.core.datatype.impl.type.ObjectDataType\" className=\"TestVariable\" />\n";
        str = str + "      </variable>\n";
        str = str + "    </variables>\n";
        str = str + "  </header>\n";
        str = str + "\n";
        str = str + "  <nodes>\n";
        str = str + "    <start id=\"1\" name=\"Start\" />\n";
        str = str + "    <actionNode id=\"2\" name=\"MyActionNode\" >\n";
        str = str + "      <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Triggered\");\n";
        str = str + "list1.add(person.name);\n";
        str = str + "</action>\n";
        str = str + "    </actionNode>\n";
        str = str + "    <end id=\"3\" name=\"End\" />\n";
        str = str + "  </nodes>\n";
        str = str + "\n";
        str = str + "  <connections>\n";
        str = str + "    <connection from=\"1\" to=\"2\" />\n";
        str = str + "    <connection from=\"2\" to=\"3\" />\n";
        str = str + "  </connections>\n\n";
        str = str + "</process>";
        StringReader source = new StringReader(str);
        kbuilder.add(ResourceFactory.newReaderResource((Reader)source), ResourceType.DRF);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatelessKnowledgeSession ksession = kbase.newStatelessKnowledgeSession();
        List list = new ArrayList();
        ksession.setGlobal("list1", list);
        TestVariable person = new TestVariable("John Doe");
        String inXml = "";
        inXml = inXml + "{\"batch-execution\":{\"commands\":[";
        inXml = inXml + "   {\"start-process\":";
        inXml = inXml + "      {\"process-id\":\"org.drools.actions\",";
        inXml = inXml + "     \"parameters\":[";
        inXml = inXml + "        {\"identifier\":\"person\",";
        inXml = inXml + "         \"object\":{\"@class\":\"org.drools.TestVariable\",";
        inXml = inXml + "                     \"name\":\"John Doe\"}}]}},";
        inXml = inXml + "    {\"get-global\":{\"identifier\":\"list1\",\"out-identifier\":\"out-list\"}}]}}";
        inXml = this.roundTripFromXml(inXml);
        ResultHandlerImpl resultHandler = new ResultHandlerImpl();
        this.getPipeline(ksession).insert((Object)inXml, (ResultHandler)resultHandler);
        String outXml = (String)resultHandler.getObject();
        outXml = this.roundTripFromXml(outXml);
        ExecutionResults result = (ExecutionResults)BatchExecutionHelper.newJSonMarshaller().fromXML(outXml);
        result = (ExecutionResults)this.roundTripFromObject(result);
        list = (List)result.getValue("out-list");
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"John Doe", list.get(0));
    }

    @Test
    public void testProcessInstanceSignalEvent() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        String str = "";
        str = str + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        str = str + "<process xmlns=\"http://drools.org/drools-5.0/process\"\n";
        str = str + "         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n";
        str = str + "         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n";
        str = str + "         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.event\" package-name=\"org.drools\" version=\"1\" >\n";
        str = str + "\n";
        str = str + "  <header>\n";
        str = str + "    <variables>\n";
        str = str + "      <variable name=\"MyVar\" >\n";
        str = str + "        <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "        <value>SomeText</value>\n";
        str = str + "      </variable>\n";
        str = str + "    </variables>\n";
        str = str + "  </header>\n";
        str = str + "\n";
        str = str + "  <nodes>\n";
        str = str + "    <start id=\"1\" name=\"Start\" />\n";
        str = str + "    <eventNode id=\"2\" name=\"Event\" variableName=\"MyVar\" >\n";
        str = str + "      <eventFilters>\n";
        str = str + "        <eventFilter type=\"eventType\" eventType=\"MyEvent\" />\n";
        str = str + "      </eventFilters>\n";
        str = str + "    </eventNode>\n";
        str = str + "    <join id=\"3\" name=\"Join\" type=\"1\" />\n";
        str = str + "    <end id=\"4\" name=\"End\" />\n";
        str = str + "  </nodes>\n";
        str = str + "\n";
        str = str + "  <connections>\n";
        str = str + "    <connection from=\"1\" to=\"3\" />\n";
        str = str + "    <connection from=\"2\" to=\"3\" />\n";
        str = str + "    <connection from=\"3\" to=\"4\" />\n";
        str = str + "  </connections>\n";
        str = str + "\n";
        str = str + "</process>";
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRF);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        org.drools.runtime.process.ProcessInstance processInstance = ksession.startProcess("org.drools.event");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        String inXml = "";
        inXml = inXml + "{\"batch-execution\":{\"commands\":[";
        inXml = inXml + "{\"signal-event\":{\"process-instance-id\":" + processInstance.getId() + ",\"event-type\":\"MyEvent\"";
        inXml = inXml + "                   ,\"object\":{\"string\":[\"MyValue\"]} } }";
        inXml = inXml + "]}}";
        inXml = this.roundTripFromXml(inXml);
        this.getPipelineStateful(ksession).insert((Object)inXml, (ResultHandler)new ResultHandlerImpl());
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        Assert.assertEquals((Object)"MyValue", (Object)((VariableScopeInstance)((ProcessInstance)processInstance).getContextInstance("VariableScope")).getVariable("MyVar"));
    }

    @Test
    public void testProcessRuntimeSignalEvent() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        String str = "";
        str = str + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        str = str + "<process xmlns=\"http://drools.org/drools-5.0/process\"\n";
        str = str + "         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n";
        str = str + "         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n";
        str = str + "         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.event\" package-name=\"org.drools\" version=\"1\" >\n";
        str = str + "\n";
        str = str + "  <header>\n";
        str = str + "    <variables>\n";
        str = str + "      <variable name=\"MyVar\" >\n";
        str = str + "        <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "        <value>SomeText</value>\n";
        str = str + "      </variable>\n";
        str = str + "    </variables>\n";
        str = str + "  </header>\n";
        str = str + "\n";
        str = str + "  <nodes>\n";
        str = str + "    <start id=\"1\" name=\"Start\" />\n";
        str = str + "    <eventNode id=\"2\" name=\"Event\" scope=\"external\" variableName=\"MyVar\" >\n";
        str = str + "      <eventFilters>\n";
        str = str + "        <eventFilter type=\"eventType\" eventType=\"MyEvent\" />\n";
        str = str + "      </eventFilters>\n";
        str = str + "    </eventNode>\n";
        str = str + "    <join id=\"3\" name=\"Join\" type=\"1\" />\n";
        str = str + "    <end id=\"4\" name=\"End\" />\n";
        str = str + "  </nodes>\n";
        str = str + "\n";
        str = str + "  <connections>\n";
        str = str + "    <connection from=\"1\" to=\"3\" />\n";
        str = str + "    <connection from=\"2\" to=\"3\" />\n";
        str = str + "    <connection from=\"3\" to=\"4\" />\n";
        str = str + "  </connections>\n";
        str = str + "\n";
        str = str + "</process>";
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRF);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        org.drools.runtime.process.ProcessInstance processInstance = ksession.startProcess("org.drools.event");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        String inXml = "";
        inXml = inXml + "{\"batch-execution\":{\"commands\":[";
        inXml = inXml + "   {\"signal-event\":{\"event-type\":\"MyEvent\"";
        inXml = inXml + "                    ,\"object\":{\"string\":[\"MyValue\"]} } }";
        inXml = inXml + "]}}";
        inXml = this.roundTripFromXml(inXml);
        this.getPipelineStateful(ksession).insert((Object)inXml, (ResultHandler)new ResultHandlerImpl());
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        Assert.assertEquals((Object)"MyValue", (Object)((VariableScopeInstance)((ProcessInstance)processInstance).getContextInstance("VariableScope")).getVariable("MyVar"));
    }

    @Test
    public void testCompleteWorkItem() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        String str = "";
        str = str + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        str = str + "<process xmlns=\"http://drools.org/drools-5.0/process\"\n";
        str = str + "         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n";
        str = str + "         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n";
        str = str + "         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions\" package-name=\"org.drools\" version=\"1\" >\n";
        str = str + "\n";
        str = str + "  <header>\n";
        str = str + "    <variables>\n";
        str = str + "      <variable name=\"UserName\" >\n";
        str = str + "        <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "        <value>John Doe</value>\n";
        str = str + "      </variable>\n";
        str = str + "      <variable name=\"Person\" >\n";
        str = str + "        <type name=\"org.drools.process.core.datatype.impl.type.ObjectDataType\" className=\"org.drools.Person\" />\n";
        str = str + "      </variable>\n";
        str = str + "      <variable name=\"MyObject\" >\n";
        str = str + "        <type name=\"org.drools.process.core.datatype.impl.type.ObjectDataType\" className=\"java.lang.Object\" />\n";
        str = str + "      </variable>\n";
        str = str + "      <variable name=\"Number\" >\n";
        str = str + "        <type name=\"org.drools.process.core.datatype.impl.type.IntegerDataType\" />\n";
        str = str + "      </variable>\n";
        str = str + "    </variables>\n";
        str = str + "  </header>\n";
        str = str + "\n";
        str = str + "  <nodes>\n";
        str = str + "    <start id=\"1\" name=\"Start\" />\n";
        str = str + "    <workItem id=\"2\" name=\"HumanTask\" >\n";
        str = str + "      <work name=\"Human Task\" >\n";
        str = str + "        <parameter name=\"ActorId\" >\n";
        str = str + "          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "          <value>#{UserName}</value>\n";
        str = str + "        </parameter>\n";
        str = str + "        <parameter name=\"Content\" >\n";
        str = str + "          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "          <value>#{Person.name}</value>\n";
        str = str + "        </parameter>\n";
        str = str + "        <parameter name=\"TaskName\" >\n";
        str = str + "          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "          <value>Do something</value>\n";
        str = str + "        </parameter>\n";
        str = str + "        <parameter name=\"Priority\" >\n";
        str = str + "          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "        </parameter>\n";
        str = str + "        <parameter name=\"Comment\" >\n";
        str = str + "          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "        </parameter>\n";
        str = str + "        <parameter name=\"Attachment\" >\n";
        str = str + "          <type name=\"org.drools.process.core.datatype.impl.type.ObjectDataType\" className=\"java.lang.Object\" />\n";
        str = str + "        </parameter>\n";
        str = str + "      </work>\n";
        str = str + "      <mapping type=\"in\" from=\"MyObject\" to=\"Attachment\" />";
        str = str + "      <mapping type=\"in\" from=\"Person.name\" to=\"Comment\" />";
        str = str + "      <mapping type=\"out\" from=\"Result\" to=\"MyObject\" />";
        str = str + "      <mapping type=\"out\" from=\"Result.length()\" to=\"Number\" />";
        str = str + "    </workItem>\n";
        str = str + "    <end id=\"3\" name=\"End\" />\n";
        str = str + "  </nodes>\n";
        str = str + "\n";
        str = str + "  <connections>\n";
        str = str + "    <connection from=\"1\" to=\"2\" />\n";
        str = str + "    <connection from=\"2\" to=\"3\" />\n";
        str = str + "  </connections>\n";
        str = str + "\n";
        str = str + "</process>";
        StringReader source = new StringReader(str);
        kbuilder.add(ResourceFactory.newReaderResource((Reader)source), ResourceType.DRF);
        Collection kpkgs = kbuilder.getKnowledgePackages();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kpkgs);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        TestWorkItemHandler handler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("UserName", "John Doe");
        Person person = new Person();
        person.setName("John Doe");
        parameters.put("Person", person);
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.startProcess("org.drools.actions", parameters);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((Object)"John Doe", (Object)workItem.getParameter("ActorId"));
        Assert.assertEquals((Object)"John Doe", (Object)workItem.getParameter("Content"));
        Assert.assertEquals((Object)"John Doe", (Object)workItem.getParameter("Comment"));
        Assert.assertEquals((long)0L, (long)workItem.getState());
        String inXml = "";
        inXml = "{\"complete-work-item\":{\"id\":" + workItem.getId() + "}}";
        inXml = this.roundTripFromXml(inXml);
        this.getPipelineStateful(ksession).insert((Object)inXml, (ResultHandler)new ResultHandlerImpl());
        Assert.assertEquals((long)2L, (long)workItem.getState());
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        parameters = new HashMap();
        parameters.put("UserName", "Jane Doe");
        parameters.put("MyObject", "SomeString");
        person = new Person();
        person.setName("Jane Doe");
        parameters.put("Person", person);
        processInstance = (WorkflowProcessInstance)ksession.startProcess("org.drools.actions", parameters);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((Object)"Jane Doe", (Object)workItem.getParameter("ActorId"));
        Assert.assertEquals((Object)"SomeString", (Object)workItem.getParameter("Attachment"));
        Assert.assertEquals((Object)"Jane Doe", (Object)workItem.getParameter("Content"));
        Assert.assertEquals((Object)"Jane Doe", (Object)workItem.getParameter("Comment"));
        Assert.assertEquals((long)0L, (long)workItem.getState());
        inXml = "{\"complete-work-item\":{\"id\":" + workItem.getId() + ",\"results\":{\"identifier\":\"Result\",\"object\":{\"@class\":\"string\",\"$\":\"SomeOtherString\"}}}}";
        inXml = this.roundTripFromXml(inXml);
        this.getPipelineStateful(ksession).insert((Object)inXml, (ResultHandler)new ResultHandlerImpl());
        Assert.assertEquals((long)2L, (long)workItem.getState());
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        Assert.assertEquals((Object)"SomeOtherString", (Object)processInstance.getVariable("MyObject"));
        Assert.assertEquals((Object)15, (Object)processInstance.getVariable("Number"));
    }

    @Test
    public void testAbortWorkItem() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        String str = "";
        str = str + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        str = str + "<process xmlns=\"http://drools.org/drools-5.0/process\"\n";
        str = str + "         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n";
        str = str + "         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n";
        str = str + "         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions\" package-name=\"org.drools\" version=\"1\" >\n";
        str = str + "\n";
        str = str + "  <header>\n";
        str = str + "    <variables>\n";
        str = str + "      <variable name=\"UserName\" >\n";
        str = str + "        <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "        <value>John Doe</value>\n";
        str = str + "      </variable>\n";
        str = str + "      <variable name=\"Person\" >\n";
        str = str + "        <type name=\"org.drools.process.core.datatype.impl.type.ObjectDataType\" className=\"org.drools.Person\" />\n";
        str = str + "      </variable>\n";
        str = str + "      <variable name=\"MyObject\" >\n";
        str = str + "        <type name=\"org.drools.process.core.datatype.impl.type.ObjectDataType\" className=\"java.lang.Object\" />\n";
        str = str + "      </variable>\n";
        str = str + "      <variable name=\"Number\" >\n";
        str = str + "        <type name=\"org.drools.process.core.datatype.impl.type.IntegerDataType\" />\n";
        str = str + "      </variable>\n";
        str = str + "    </variables>\n";
        str = str + "  </header>\n";
        str = str + "\n";
        str = str + "  <nodes>\n";
        str = str + "    <start id=\"1\" name=\"Start\" />\n";
        str = str + "    <workItem id=\"2\" name=\"HumanTask\" >\n";
        str = str + "      <work name=\"Human Task\" >\n";
        str = str + "        <parameter name=\"ActorId\" >\n";
        str = str + "          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "          <value>#{UserName}</value>\n";
        str = str + "        </parameter>\n";
        str = str + "        <parameter name=\"Content\" >\n";
        str = str + "          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "          <value>#{Person.name}</value>\n";
        str = str + "        </parameter>\n";
        str = str + "        <parameter name=\"TaskName\" >\n";
        str = str + "          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "          <value>Do something</value>\n";
        str = str + "        </parameter>\n";
        str = str + "        <parameter name=\"Priority\" >\n";
        str = str + "          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "        </parameter>\n";
        str = str + "        <parameter name=\"Comment\" >\n";
        str = str + "          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n";
        str = str + "        </parameter>\n";
        str = str + "        <parameter name=\"Attachment\" >\n";
        str = str + "          <type name=\"org.drools.process.core.datatype.impl.type.ObjectDataType\" className=\"java.lang.Object\" />\n";
        str = str + "        </parameter>\n";
        str = str + "      </work>\n";
        str = str + "      <mapping type=\"in\" from=\"MyObject\" to=\"Attachment\" />";
        str = str + "      <mapping type=\"in\" from=\"Person.name\" to=\"Comment\" />";
        str = str + "      <mapping type=\"out\" from=\"Result\" to=\"MyObject\" />";
        str = str + "      <mapping type=\"out\" from=\"Result.length()\" to=\"Number\" />";
        str = str + "    </workItem>\n";
        str = str + "    <end id=\"3\" name=\"End\" />\n";
        str = str + "  </nodes>\n";
        str = str + "\n";
        str = str + "  <connections>\n";
        str = str + "    <connection from=\"1\" to=\"2\" />\n";
        str = str + "    <connection from=\"2\" to=\"3\" />\n";
        str = str + "  </connections>\n";
        str = str + "\n";
        str = str + "</process>";
        StringReader source = new StringReader(str);
        kbuilder.add(ResourceFactory.newReaderResource((Reader)source), ResourceType.DRF);
        Collection kpkgs = kbuilder.getKnowledgePackages();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kpkgs);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        TestWorkItemHandler handler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("UserName", "John Doe");
        Person person = new Person();
        person.setName("John Doe");
        parameters.put("Person", person);
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.startProcess("org.drools.actions", parameters);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((long)0L, (long)workItem.getState());
        String inXml = "{\"abort-work-item\":{\"id\":" + workItem.getId() + "}}";
        inXml = this.roundTripFromXml(inXml);
        this.getPipelineStateful(ksession).insert((Object)inXml, (ResultHandler)new ResultHandlerImpl());
        Assert.assertEquals((long)3L, (long)workItem.getState());
    }

    @Test
    public void testInsertObjectWithDeclaredFact() throws Exception {
        String str = "";
        str = str + "package org.foo \n";
        str = str + "declare Whee \n\ttype: String\n\tprice: Integer\n\toldPrice: Integer\nend\n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Whee() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n";
        str = str + "end\n";
        String inXml = "";
        inXml = inXml + "{\"batch-execution\":{\"commands\":[";
        inXml = inXml + "{\"insert\":{\"object\":{\"org.foo.Whee\":{\"type\":\"stilton\",\"price\":25,\"oldPrice\":0}}, \"out-identifier\":\"outStilton\" } }";
        inXml = inXml + ", {\"fire-all-rules\":\"\"}";
        inXml = inXml + "]}}";
        StatefulKnowledgeSession ksession = this.getSessionStateful(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        ResultHandlerImpl resultHandler = new ResultHandlerImpl();
        this.getPipelineStateful(ksession).insert((Object)inXml, (ResultHandler)resultHandler);
        String outXml = (String)resultHandler.getObject();
        CompositeClassLoader cl = ((InternalRuleBase)((StatefulKnowledgeSessionImpl)ksession).getRuleBase()).getRootClassLoader();
        XStream xstream = BatchExecutionHelper.newJSonMarshaller();
        xstream.setClassLoader((ClassLoader)cl);
        FactHandle factHandle = (FactHandle)((ExecutionResults)xstream.fromXML(outXml)).getFactHandle("outStilton");
        Assert.assertNotNull((Object)factHandle);
        Object object = ((ExecutionResults)xstream.fromXML(outXml)).getValue("outStilton");
        Assert.assertEquals((Object)"org.foo.Whee", (Object)object.getClass().getName());
    }

    @Test
    public void testInsertObjectStateful() throws Exception {
        String str = "";
        str = str + "package org.foo \n";
        str = str + "declare Whee \n\ttype: String\n\tprice: Integer\n\toldPrice: Integer\nend\n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Whee(price < 30) \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( $c.getPrice() + 5 ); \n update($c);\n";
        str = str + "end\n";
        str = str + "query results\n";
        str = str + "    w: Whee(price > 0)";
        str = str + "end\n";
        String inXml = "";
        inXml = inXml + "{\"batch-execution\":{\"commands\":[";
        inXml = inXml + "{\"insert\":{\"object\":{\"org.foo.Whee\":{\"type\":\"stilton\",\"price\":25,\"oldPrice\":0}} } }";
        inXml = inXml + "]}}";
        StatefulKnowledgeSession ksession = this.getSessionStateful(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        ResultHandlerImpl resultHandler = new ResultHandlerImpl();
        this.getPipelineStateful(ksession).insert((Object)inXml, (ResultHandler)resultHandler);
        inXml = "{\"batch-execution\":{\"commands\":[";
        inXml = inXml + "   {\"query\":{\"out-identifier\":\"matchingthings\",\"name\":\"results\"}}";
        inXml = inXml + "]}}";
        this.getPipelineStateful(ksession).insert((Object)inXml, (ResultHandler)resultHandler);
        String outXml = (String)resultHandler.getObject();
        Assert.assertTrue((outXml.indexOf("\"price\":25") >= 0 ? 1 : 0) != 0);
        this.getPipelineStateful(ksession).insert((Object)"{\"fire-all-rules\":\"\"}", (ResultHandler)resultHandler);
        inXml = "{\"batch-execution\":{\"commands\":[";
        inXml = inXml + "   {\"query\":{\"out-identifier\":\"matchingthings\",\"name\":\"results\"}}";
        inXml = inXml + "]}}";
        this.getPipelineStateful(ksession).insert((Object)inXml, (ResultHandler)resultHandler);
        outXml = (String)resultHandler.getObject();
        Assert.assertTrue((outXml.indexOf("\"price\":30") >= 0 ? 1 : 0) != 0);
    }

    private Pipeline getPipeline(StatelessKnowledgeSession ksession) {
        Action executeResultHandler = PipelineFactory.newExecuteResultHandler();
        Action assignResult = PipelineFactory.newAssignObjectAsResult();
        assignResult.setReceiver((Receiver)executeResultHandler);
        Transformer outTransformer = PipelineFactory.newXStreamToXmlTransformer((XStream)BatchExecutionHelper.newJSonMarshaller());
        outTransformer.setReceiver((Receiver)assignResult);
        KnowledgeRuntimeCommand batchExecution = PipelineFactory.newCommandExecutor();
        batchExecution.setReceiver((Receiver)outTransformer);
        Transformer inTransformer = PipelineFactory.newXStreamFromXmlTransformer((XStream)BatchExecutionHelper.newJSonMarshaller());
        inTransformer.setReceiver((Receiver)batchExecution);
        Pipeline pipeline = PipelineFactory.newStatelessKnowledgeSessionPipeline((StatelessKnowledgeSession)ksession);
        pipeline.setReceiver((Receiver)inTransformer);
        return pipeline;
    }

    private Pipeline getPipelineStateful(StatefulKnowledgeSession ksession) {
        Action executeResultHandler = PipelineFactory.newExecuteResultHandler();
        Action assignResult = PipelineFactory.newAssignObjectAsResult();
        assignResult.setReceiver((Receiver)executeResultHandler);
        Transformer outTransformer = PipelineFactory.newXStreamToXmlTransformer((XStream)BatchExecutionHelper.newJSonMarshaller());
        outTransformer.setReceiver((Receiver)assignResult);
        KnowledgeRuntimeCommand batchExecution = PipelineFactory.newCommandExecutor();
        batchExecution.setReceiver((Receiver)outTransformer);
        Transformer inTransformer = PipelineFactory.newXStreamFromXmlTransformer((XStream)BatchExecutionHelper.newJSonMarshaller());
        inTransformer.setReceiver((Receiver)batchExecution);
        Pipeline pipeline = PipelineFactory.newStatefulKnowledgeSessionPipeline((StatefulKnowledgeSession)ksession);
        pipeline.setReceiver((Receiver)inTransformer);
        return pipeline;
    }

    private Pipeline getPipelineSessionStateful(GridNode node, XStreamResolverStrategy xstreamResolverStrategy) {
        Action executeResultHandler = PipelineFactory.newExecuteResultHandler();
        Action assignResult = PipelineFactory.newAssignObjectAsResult();
        assignResult.setReceiver((Receiver)executeResultHandler);
        XStreamToXmlGridTransformer outTransformer = new XStreamToXmlGridTransformer();
        outTransformer.setReceiver((Receiver)assignResult);
        KnowledgeRuntimeCommand batchExecution = PipelineFactory.newCommandExecutor();
        batchExecution.setReceiver((Receiver)outTransformer);
        XStreamFromXmlGridTransformer inTransformer = new XStreamFromXmlGridTransformer(xstreamResolverStrategy);
        inTransformer.setReceiver((Receiver)batchExecution);
        ExecutionNodePipelineImpl pipeline = new ExecutionNodePipelineImpl(node);
        pipeline.setReceiver((Receiver)inTransformer);
        return pipeline;
    }

    private StatelessKnowledgeSession getSession2(Resource resource) throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(resource, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        Collection pkgs = kbuilder.getKnowledgePackages();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(pkgs);
        StatelessKnowledgeSession session = kbase.newStatelessKnowledgeSession();
        return session;
    }

    private StatefulKnowledgeSession getSessionStateful(Resource resource) throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(resource, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            System.out.println(kbuilder.getErrors());
        }
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        Collection pkgs = kbuilder.getKnowledgePackages();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(pkgs);
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        return session;
    }

    private StatefulKnowledgeSession getExecutionNodeSessionStateful(GridNode node, Resource resource) throws Exception {
        KnowledgeBuilder kbuilder = ((KnowledgeBuilderFactoryService)node.get(KnowledgeBuilderFactoryService.class)).newKnowledgeBuilder();
        kbuilder.add(resource, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            System.out.println(kbuilder.getErrors());
        }
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        Collection pkgs = kbuilder.getKnowledgePackages();
        KnowledgeBase kbase = ((KnowledgeBaseFactoryService)node.get(KnowledgeBaseFactoryService.class)).newKnowledgeBase();
        kbase.addKnowledgePackages(pkgs);
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        return session;
    }

    public String roundTripFromXml(String inXml) {
        Object object = BatchExecutionHelper.newJSonMarshaller().fromXML(inXml);
        inXml = BatchExecutionHelper.newJSonMarshaller().toXML(object);
        object = BatchExecutionHelper.newJSonMarshaller().fromXML(inXml);
        return BatchExecutionHelper.newJSonMarshaller().toXML(object);
    }

    public Object roundTripFromObject(Object object) {
        String xml = BatchExecutionHelper.newJSonMarshaller().toXML(object);
        object = BatchExecutionHelper.newJSonMarshaller().fromXML(xml);
        xml = BatchExecutionHelper.newJSonMarshaller().toXML(object);
        return BatchExecutionHelper.newJSonMarshaller().fromXML(xml);
    }

    public static class ResultHandlerImpl
    implements ResultHandler {
        Object object;

        public void handleResult(Object object) {
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }
    }

    public static class TestWorkItemHandler
    implements WorkItemHandler {
        private WorkItem workItem;

        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            this.workItem = workItem;
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        }

        public WorkItem getWorkItem() {
            return this.workItem;
        }
    }
}

