/*
 * Decompiled with CFR 0.152.
 */
package org.drools.pmml.pmml_4_1;

import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class PMMLErrorTest {
    String pmlm = "<PMML version=\"4.1\" xsi:schemaLocation=\"http://www.dmg.org/PMML-4_1 http://www.dmg.org/v4-1/pmml-4-1.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.dmg.org/PMML-4_1\">\n  <Header copyright=\"opensource\" description=\"test\">\n    <Application name=\"handmade\" version=\"1.0\"/>\n    <Annotation>notes here</Annotation>\n    <Timestamp>now</Timestamp>\n  </Header>\n<IllegalModel>\n</IllegalModel></PMML>";
    String pmml = "<PMML version=\"4.1\" xsi:schemaLocation=\"http://www.dmg.org/PMML-4_1 http://www.dmg.org/v4-1/pmml-4-1.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.dmg.org/PMML-4_1\">\n  <Header copyright=\"opensource\" description=\"test\">\n    <Application name=\"handmade\" version=\"1.0\"/>\n    <Annotation>notes here</Annotation>\n    <Timestamp>now</Timestamp>\n  </Header><DataDictionary>\n <DataField name=\"fld\" dataType=\"string\" optype=\"categorical\" /></DataDictionary>\n</PMML>";

    @Test
    public void testErrorDuringGenrationAPICompatibility() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])this.pmlm.getBytes()), ResourceType.PMML);
        System.out.print(kbuilder.getErrors());
        Assert.assertTrue((boolean)kbuilder.hasErrors());
        KnowledgeBuilder kbuilder2 = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder2.add(ResourceFactory.newByteArrayResource((byte[])this.pmml.getBytes()), ResourceType.PMML);
        System.out.print(kbuilder2.getErrors());
        Assert.assertFalse((boolean)kbuilder2.hasErrors());
    }

    @Test
    public void testErrorDuringGeneration() {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write(ResourceFactory.newByteArrayResource((byte[])this.pmlm.getBytes()).setResourceType(ResourceType.PMML).setSourcePath("pmlm.pmml"));
        KieBuilder kb = ks.newKieBuilder(kfs);
        kb.buildAll();
        Assert.assertEquals((long)1L, (long)kb.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).size());
    }

    @Test
    public void testNoErrorDuringGeneration() {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write(ResourceFactory.newByteArrayResource((byte[])this.pmml.getBytes()).setResourceType(ResourceType.PMML).setSourcePath("pmml.pmml"));
        KieBuilder kb = ks.newKieBuilder(kfs);
        kb.buildAll();
        Assert.assertEquals((long)0L, (long)kb.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).size());
    }
}

