/*
 * Decompiled with CFR 0.152.
 */
package org.drools.pmml.pmml_4_1.predictive.models;

import org.drools.pmml.pmml_4_1.DroolsAbstractPMMLTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.KieSession;

public class SVMTest
extends DroolsAbstractPMMLTest {
    private static final boolean VERBOSE = true;
    private static final String source1 = "org/drools/pmml/pmml_4_1/test_svm.xml";
    private static final String source2 = "org/drools/pmml/pmml_4_1/test_svm_1vN.xml";
    private static final String source3 = "org/drools/pmml/pmml_4_1/test_svm_1v1.xml";
    private static final String packageName = "org.drools.pmml.pmml_4_1.test";

    @After
    public void tearDown() {
        this.getKSession().dispose();
    }

    @Test
    public void testSVM() throws Exception {
        this.setKSession(this.getModelSession(source1, true));
        this.setKbase(this.getKSession().getKieBase());
        KieSession kSession = this.getKSession();
        kSession.fireAllRules();
        FactType ztype = kSession.getKieBase().getFactType(packageName, "Z");
        Assert.assertNotNull((Object)ztype);
        kSession.getEntryPoint("in_X").insert((Object)0.0);
        kSession.getEntryPoint("in_Y").insert((Object)0.0);
        kSession.fireAllRules();
        System.out.println(this.reportWMObjects(kSession));
        this.checkFirstDataFieldOfTypeStatus(ztype, true, false, "SVMXORMODEL", "yes");
        kSession.getEntryPoint("in_X").insert((Object)0.23);
        kSession.getEntryPoint("in_Y").insert((Object)0.75);
        kSession.fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(ztype, true, false, "SVMXORMODEL", "no");
        kSession.getEntryPoint("in_X").insert((Object)0.85);
        kSession.fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(ztype, true, false, "SVMXORMODEL", "yes");
        kSession.getEntryPoint("in_Y").insert((Object)-0.12);
        kSession.fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(ztype, true, false, "SVMXORMODEL", "no");
        kSession.getEntryPoint("in_X").insert((Object)7.85);
        kSession.fireAllRules();
        System.out.println(this.reportWMObjects(kSession));
        this.checkFirstDataFieldOfTypeStatus(ztype, true, false, "SVMXORMODEL", "no");
    }

    @Test
    public void testSVM1vN() throws Exception {
        this.setKSession(this.getModelSession(source2, true));
        this.setKbase(this.getKSession().getKieBase());
        KieSession kSession = this.getKSession();
        kSession.fireAllRules();
        FactType ztype = kSession.getKieBase().getFactType(packageName, "Z");
        Assert.assertNotNull((Object)ztype);
        kSession.getEntryPoint("in_X").insert((Object)0.0);
        kSession.getEntryPoint("in_Y").insert((Object)0.0);
        kSession.fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(ztype, true, false, "SVMXORMODEL", "no");
        this.checkFirstDataFieldOfTypeStatus(kSession.getKieBase().getFactType(packageName, "OutZ"), true, false, "SVMXORMODEL", "no");
        this.checkFirstDataFieldOfTypeStatus(kSession.getKieBase().getFactType(packageName, "ProbZNo"), true, false, "SVMXORMODEL", 0.7357588);
    }

    @Test
    public void testSVM1v1() throws Exception {
        this.setKSession(this.getModelSession(source3, true));
        this.setKbase(this.getKSession().getKieBase());
        KieSession kSession = this.getKSession();
        kSession.fireAllRules();
        FactType ztype = kSession.getKieBase().getFactType(packageName, "Z");
        Assert.assertNotNull((Object)ztype);
        kSession.getEntryPoint("in_X").insert((Object)0.63);
        kSession.getEntryPoint("in_Y").insert((Object)0.0);
        kSession.fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(ztype, true, false, "SVMXORMODEL", "yes");
        this.checkFirstDataFieldOfTypeStatus(kSession.getKieBase().getFactType(packageName, "OutZ"), true, false, "SVMXORMODEL", "yes");
        this.checkFirstDataFieldOfTypeStatus(kSession.getKieBase().getFactType(packageName, "ProbZYes"), true, false, "SVMXORMODEL", 0.872057);
    }
}

