/*
 * Decompiled with CFR 0.152.
 */
package org.drools.pmml.pmml_4_1.transformations;

import org.drools.pmml.pmml_4_1.DroolsAbstractPMMLTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.definition.type.FactType;

public class NormDiscreteFieldsTest
extends DroolsAbstractPMMLTest {
    private static final boolean VERBOSE = false;
    private static final String source = "org/drools/pmml/pmml_4_1/test_derived_fields_normDiscrete.xml";
    private static final String packageName = "org.drools.pmml.pmml_4_1.test";

    @Before
    public void setUp() throws Exception {
        this.setKSession(this.getModelSession(source, false));
        this.setKbase(this.getKSession().getKieBase());
    }

    @After
    public void tearDown() {
        this.getKSession().dispose();
    }

    @Test
    public void testNormDiscrete() throws Exception {
        FactType fld = this.getKbase().getFactType(packageName, "CatField");
        FactType val1 = this.getKbase().getFactType(packageName, "IsValue1");
        FactType val2 = this.getKbase().getFactType(packageName, "IsValue2");
        Assert.assertNotNull((Object)this.getKSession().getEntryPoint("in_CatField"));
        this.getKSession().getEntryPoint("in_CatField").insert((Object)"Value1");
        this.getKSession().fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(fld, true, false, null, "Value1");
        this.checkFirstDataFieldOfTypeStatus(val1, true, false, null, 1.0);
        this.checkFirstDataFieldOfTypeStatus(val2, true, false, null, 0.0);
        this.refreshKSession();
        this.getKSession().getEntryPoint("in_CatField").insert((Object)"Value2");
        this.getKSession().fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(fld, true, false, null, "Value2");
        this.checkFirstDataFieldOfTypeStatus(val1, true, false, null, 0.0);
        this.checkFirstDataFieldOfTypeStatus(val2, true, false, null, 1.0);
        this.refreshKSession();
        this.getKSession().getEntryPoint("in_CatField").insert((Object)"Value3");
        this.getKSession().fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(fld, true, false, null, "Value3");
        this.checkFirstDataFieldOfTypeStatus(val1, true, false, null, 0.0);
        this.checkFirstDataFieldOfTypeStatus(val2, true, false, null, 0.0);
        this.refreshKSession();
        this.getKSession().getEntryPoint("in_CatField").insert((Object)"Value0");
        this.getKSession().fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(fld, false, true, null, "Value0");
        this.checkFirstDataFieldOfTypeStatus(val1, true, false, null, 2.0);
        this.checkFirstDataFieldOfTypeStatus(val2, true, false, null, 2.0);
        this.refreshKSession();
    }
}

