/*
 * Decompiled with CFR 0.152.
 */
package org.drools.pmml.pmml_4_1.predictive.models;

import java.util.Iterator;
import java.util.LinkedHashMap;
import org.drools.pmml.pmml_4_1.DroolsAbstractPMMLTest;
import org.drools.pmml.pmml_4_1.PMML4Helper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.ClassObjectFilter;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;

public class ScorecardTest
extends DroolsAbstractPMMLTest {
    private static final boolean VERBOSE = true;
    private static final String source1 = "org/drools/pmml/pmml_4_1/test_scorecard.xml";
    private static final String source2 = "org/drools/pmml/pmml_4_1/test_scorecardOut.xml";
    private static final String packageName = "org.drools.pmml.pmml_4_1.test";

    @After
    public void tearDown() {
    }

    @Test
    public void testScorecard() throws Exception {
        this.setKSession(this.getModelSession(source1, true));
        this.setKbase(this.getKSession().getKieBase());
        KieSession kSession = this.getKSession();
        kSession.fireAllRules();
        kSession.getEntryPoint("in_Age").insert((Object)33.0);
        kSession.getEntryPoint("in_Occupation").insert((Object)"SKYDIVER");
        kSession.getEntryPoint("in_ResidenceState").insert((Object)"KN");
        kSession.getEntryPoint("in_ValidLicense").insert((Object)true);
        kSession.fireAllRules();
        FactType scoreCardType = this.getKbase().getFactType(PMML4Helper.pmmlDefaultPackageName(), "ScoreCard");
        Assert.assertNotNull((Object)scoreCardType);
        Assert.assertEquals((long)1L, (long)kSession.getObjects((ObjectFilter)new ClassObjectFilter(scoreCardType.getFactClass())).size());
        Object scoreCard = kSession.getObjects((ObjectFilter)new ClassObjectFilter(scoreCardType.getFactClass())).iterator().next();
        Assert.assertEquals((Object)"SampleScore", (Object)scoreCardType.get(scoreCard, "modelName"));
        Assert.assertEquals((Object)41.345, (Object)scoreCardType.get(scoreCard, "score"));
        Object x = scoreCardType.get(scoreCard, "ranking");
        Assert.assertTrue((boolean)(x instanceof LinkedHashMap));
        LinkedHashMap map = (LinkedHashMap)x;
        Assert.assertTrue((boolean)map.containsKey("LX00"));
        Assert.assertTrue((boolean)map.containsKey("RES"));
        Assert.assertTrue((boolean)map.containsKey("CX2"));
        Assert.assertEquals((Object)-1.0, map.get("LX00"));
        Assert.assertEquals((Object)-10.0, map.get("RES"));
        Assert.assertEquals((Object)-30.0, map.get("CX2"));
        Iterator iter = map.keySet().iterator();
        Assert.assertEquals((Object)"LX00", iter.next());
        Assert.assertEquals((Object)"RES", iter.next());
        Assert.assertEquals((Object)"CX2", iter.next());
    }

    @Test
    public void testScorecardOutputs() throws Exception {
        this.setKSession(this.getModelSession(source2, true));
        this.setKbase(this.getKSession().getKieBase());
        KieSession kSession = this.getKSession();
        kSession.fireAllRules();
        kSession.getEntryPoint("in_Cage").insert((Object)"engineering");
        kSession.getEntryPoint("in_Age").insert((Object)25);
        kSession.getEntryPoint("in_Wage").insert((Object)500.0);
        kSession.fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "OutRC1"), true, false, "SampleScorecard", "RC2");
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "OutRC2"), true, false, "SampleScorecard", "RC1");
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "OutRC3"), true, false, "SampleScorecard", "RC1");
    }
}

