/*
 * Decompiled with CFR 0.152.
 */
package org.drools.pmml.pmml_4_1.transformations;

import org.drools.pmml.pmml_4_1.DroolsAbstractPMMLTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.definition.type.FactType;

public class LinearNormalizedFieldsTest
extends DroolsAbstractPMMLTest {
    private static final boolean VERBOSE = false;
    private static final String source = "org/drools/pmml/pmml_4_1/test_derived_fields_linearNorm.xml";
    private static final String packageName = "org.drools.pmml.pmml_4_1.test";

    @Before
    public void setUp() throws Exception {
        this.setKSession(this.getModelSession(source, false));
        this.setKbase(this.getKSession().getKieBase());
    }

    @After
    public void tearDown() {
        this.getKSession().dispose();
    }

    @Test
    public void testDerivedTypesLinearNormMapMissing() throws Exception {
        FactType age = this.getKbase().getFactType(packageName, "Age");
        FactType age1 = this.getKbase().getFactType(packageName, "Age_norm");
        FactType age2 = this.getKbase().getFactType(packageName, "Age_norm2");
        FactType age3 = this.getKbase().getFactType(packageName, "Age_norm3");
        Assert.assertNotNull((Object)this.getKSession().getEntryPoint("in_Age"));
        Assert.assertNull((Object)this.getKSession().getEntryPoint("in_Age_mis"));
        Assert.assertNull((Object)this.getKSession().getEntryPoint("in_Age_norm"));
        this.getKSession().getEntryPoint("in_Age").insert((Object)-1);
        this.getKSession().fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(age, true, true, null, -1);
        this.checkFirstDataFieldOfTypeStatus(age1, true, false, null, 0.0);
        this.checkFirstDataFieldOfTypeStatus(age2, true, false, null, -931.0);
        this.checkFirstDataFieldOfTypeStatus(age3, true, false, null, 789.0);
    }

    @Test
    public void testDerivedTypesLinearNormOutliers() throws Exception {
        FactType age = this.getKbase().getFactType(packageName, "Age");
        FactType age1 = this.getKbase().getFactType(packageName, "Age_norm");
        FactType age2 = this.getKbase().getFactType(packageName, "Age_norm2");
        FactType age3 = this.getKbase().getFactType(packageName, "Age_norm3");
        this.getKSession().getEntryPoint("in_Age").insert((Object)-100);
        this.getKSession().fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(age, true, false, null, -100);
        this.checkFirstDataFieldOfTypeStatus(age1, true, false, null, 0.0);
        this.checkFirstDataFieldOfTypeStatus(age2, true, true, null, 0.0);
        this.checkFirstDataFieldOfTypeStatus(age3, true, false, null, -1.25);
        this.refreshKSession();
        this.getKSession().getEntryPoint("in_Age").insert((Object)1000);
        this.getKSession().fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(age, true, false, null, 1000);
        this.checkFirstDataFieldOfTypeStatus(age1, true, false, null, 2.0);
        this.checkFirstDataFieldOfTypeStatus(age2, true, true, null, 0.0);
        this.checkFirstDataFieldOfTypeStatus(age3, true, false, null, 12.5);
    }

    @Test
    public void testDerivedTypesLinearNormInterpolation() throws Exception {
        FactType age = this.getKbase().getFactType(packageName, "Age");
        FactType age1 = this.getKbase().getFactType(packageName, "Age_norm");
        this.getKSession().getEntryPoint("in_Age").insert((Object)30);
        this.getKSession().fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(age, true, false, null, 30);
        this.checkFirstDataFieldOfTypeStatus(age1, true, false, null, 0.375);
        this.refreshKSession();
        this.getKSession().getEntryPoint("in_Age").insert((Object)90);
        this.getKSession().fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(age, true, false, null, 90);
        this.checkFirstDataFieldOfTypeStatus(age1, true, false, null, 1.5);
    }
}

