/*
 * Decompiled with CFR 0.152.
 */
package org.drools.pmml.pmml_4_2.predictive.models;

import java.util.Collection;
import org.drools.pmml.pmml_4_2.DroolsAbstractPMMLTest;
import org.drools.pmml.pmml_4_2.ModelMarker;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;

public class CleanupTest
extends DroolsAbstractPMMLTest {
    private static final String source1 = "org/drools/pmml/pmml_4_2/test_ann_iris_prediction.xml";
    private static final String source2 = "org/drools/pmml/pmml_4_2/test_tree_simple.xml";
    private static final String source3 = "org/drools/pmml/pmml_4_2/test_regression.xml";
    private static final String source4 = "org/drools/pmml/pmml_4_2/test_clustering.xml";
    private static final String source5 = "org/drools/pmml/pmml_4_2/test_svm.xml";
    private static final String source6 = "org/drools/pmml/pmml_4_2/test_scorecard.xml";
    private static final String source9 = "org/drools/pmml/pmml_4_2/mock_cold.xml";
    private static final String packageName = "org.drools.pmml.pmml_4_2.test";

    @Test
    public void testCleanupANN() {
        KieSession kSession = this.getModelSession(source1);
        kSession.fireAllRules();
        Assert.assertTrue((kSession.getObjects().size() > 0 ? 1 : 0) != 0);
        Collection qres = this.getModelMarker(kSession, "Neuiris");
        Assert.assertEquals((long)1L, (long)qres.size());
        kSession.getEntryPoint("enable_Neuiris").insert((Object)Boolean.FALSE);
        kSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)kSession.getObjects().size());
        kSession.dispose();
    }

    private Collection getModelMarker(KieSession kSession, final String modelName) {
        return kSession.getObjects(new ObjectFilter(){

            public boolean accept(Object o) {
                return o instanceof ModelMarker && modelName.equals(((ModelMarker)o).getModelName());
            }
        });
    }

    @Test
    public void testReenableANN() {
        this.setKSession(this.getModelSession(source1));
        this.getKSession().fireAllRules();
        Assert.assertTrue((this.getKSession().getObjects().size() > 0 ? 1 : 0) != 0);
        Collection qres = this.getModelMarker(this.getKSession(), "Neuiris");
        Assert.assertEquals((long)1L, (long)qres.size());
        this.getKSession().getEntryPoint("enable_Neuiris").insert((Object)Boolean.FALSE);
        this.getKSession().fireAllRules();
        Assert.assertEquals((long)1L, (long)this.getKSession().getObjects().size());
        this.getKSession().getEntryPoint("enable_Neuiris").insert((Object)Boolean.TRUE);
        this.getKSession().fireAllRules();
        this.getKSession().getEntryPoint("in_PetalNum").insert((Object)101);
        this.getKSession().getEntryPoint("in_PetalWid").insert((Object)2);
        this.getKSession().getEntryPoint("in_Species").insert((Object)"virginica");
        this.getKSession().getEntryPoint("in_SepalWid").insert((Object)30);
        this.getKSession().fireAllRules();
        Assert.assertEquals((double)24.0, (double)this.queryIntegerField("OutSepLen", "Neuiris"), (double)0.0);
        Assert.assertEquals((long)38L, (long)this.getKSession().getObjects().size());
        this.getKSession().dispose();
    }

    @Test
    public void testCleanupDT() {
        KieSession kSession = this.getModelSession(source2);
        kSession.fireAllRules();
        Assert.assertTrue((kSession.getObjects().size() > 0 ? 1 : 0) != 0);
        Collection qres = this.getModelMarker(kSession, "TreeTest");
        Assert.assertEquals((long)1L, (long)qres.size());
        kSession.getEntryPoint("enable_TreeTest").insert((Object)Boolean.FALSE);
        kSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)kSession.getObjects().size());
        kSession.dispose();
    }

    @Test
    public void testCleanupRegression() {
        KieSession kSession = this.getModelSession(source3);
        kSession.fireAllRules();
        Assert.assertTrue((kSession.getObjects().size() > 0 ? 1 : 0) != 0);
        Collection qres = this.getModelMarker(kSession, "LinReg");
        Assert.assertEquals((long)1L, (long)qres.size());
        kSession.getEntryPoint("enable_LinReg").insert((Object)Boolean.FALSE);
        kSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)kSession.getObjects().size());
        kSession.dispose();
    }

    @Test
    public void testCleanupClustering() {
        KieSession kSession = this.getModelSession(source4);
        kSession.fireAllRules();
        Assert.assertTrue((kSession.getObjects().size() > 0 ? 1 : 0) != 0);
        Collection qres = this.getModelMarker(kSession, "CenterClustering");
        Assert.assertEquals((long)1L, (long)qres.size());
        kSession.getEntryPoint("enable_CenterClustering").insert((Object)Boolean.FALSE);
        kSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)kSession.getObjects().size());
        kSession.dispose();
    }

    @Test
    public void testCleanupSVM() {
        KieSession kSession = this.getModelSession(source5);
        kSession.fireAllRules();
        Assert.assertTrue((kSession.getObjects().size() > 0 ? 1 : 0) != 0);
        Collection qres = this.getModelMarker(kSession, "SVMXORModel");
        Assert.assertEquals((long)1L, (long)qres.size());
        kSession.getEntryPoint("enable_SVMXORModel").insert((Object)Boolean.FALSE);
        kSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)kSession.getObjects().size());
        kSession.dispose();
    }

    @Test
    public void testCleanupScorecard() {
        KieSession kSession = this.getModelSession(source6);
        kSession.fireAllRules();
        Assert.assertTrue((kSession.getObjects().size() > 0 ? 1 : 0) != 0);
        Collection qres = this.getModelMarker(kSession, "SampleScore");
        Assert.assertEquals((long)1L, (long)qres.size());
        kSession.getEntryPoint("enable_SampleScore").insert((Object)Boolean.FALSE);
        kSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)kSession.getObjects().size());
        kSession.dispose();
    }
}

