/*
 * Decompiled with CFR 0.152.
 */
package org.drools.pmml.pmml_4_2.predictive.models;

import org.drools.pmml.pmml_4_2.DroolsAbstractPMMLTest;
import org.drools.pmml.pmml_4_2.ModelMarker;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.ClassObjectFilter;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.internal.builder.IncrementalResults;
import org.kie.internal.builder.InternalKieBuilder;
import org.kie.internal.io.ResourceFactory;

public class MultipleModelTest
extends DroolsAbstractPMMLTest {
    private static final boolean VERBOSE = true;
    private static final String source1 = "org/drools/pmml/pmml_4_2/mock_ptsd.xml";
    private static final String source2 = "org/drools/pmml/pmml_4_2/mock_cold.xml";
    private static final String source3 = "org/drools/pmml/pmml_4_2/mock_breastcancer.xml";
    private static final String source4 = "org/drools/pmml/pmml_4_2/test_svm.xml";
    private static final String packageName = "org.drools.pmml.pmml_4_2";

    @Test
    public void testCompositeBuilding() throws Exception {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write(ResourceFactory.newClassPathResource((String)source1).setResourceType(ResourceType.PMML));
        kfs.write(ResourceFactory.newClassPathResource((String)source2).setResourceType(ResourceType.PMML));
        KieBuilder kb = ks.newKieBuilder(kfs);
        kb.buildAll();
        KieSession kSession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
        kSession.fireAllRules();
        Assert.assertEquals((long)2L, (long)kSession.getObjects((ObjectFilter)new ClassObjectFilter(ModelMarker.class)).size());
        Assert.assertEquals((long)11L, (long)kSession.getObjects((ObjectFilter)new ClassObjectFilter(kSession.getKieBase().getFactType(packageName, "Synapse").getFactClass())).size());
        kSession.dispose();
    }

    @Test
    public void testIncrementalBuilding() throws Exception {
        ReleaseId releaseId1 = KieServices.Factory.get().newReleaseId("org.test", "test", "1.0.0-SNAPSHOT");
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        KieBuilder kb = ks.newKieBuilder(kfs);
        kfs.generateAndWritePomXML(releaseId1);
        kfs.write(ResourceFactory.newClassPathResource((String)source1).setResourceType(ResourceType.PMML));
        kb.buildAll();
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession kSession = kc.newKieSession();
        kSession.fireAllRules();
        kfs.write(ResourceFactory.newClassPathResource((String)source2).setResourceType(ResourceType.PMML));
        IncrementalResults results = ((InternalKieBuilder)kb).incrementalBuild();
        kc.updateToVersion(releaseId1);
        kSession.fireAllRules();
        Assert.assertEquals((long)2L, (long)kSession.getObjects((ObjectFilter)new ClassObjectFilter(ModelMarker.class)).size());
        Assert.assertEquals((long)11L, (long)kSession.getObjects((ObjectFilter)new ClassObjectFilter(kSession.getKieBase().getFactType(packageName, "Synapse").getFactClass())).size());
        kSession.dispose();
    }
}

