/*
 * Decompiled with CFR 0.152.
 */
package org.drools.pmml.pmml_4_2.predictive.models;

import org.drools.pmml.pmml_4_2.DroolsAbstractPMMLTest;
import org.junit.After;
import org.junit.Test;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.KieSession;

public class SimpleRegressionTest
extends DroolsAbstractPMMLTest {
    private static final boolean VERBOSE = true;
    private static final String source1 = "org/drools/pmml/pmml_4_2/test_regression.xml";
    private static final String source2 = "org/drools/pmml/pmml_4_2/test_regression_clax.xml";
    private static final String packageName = "org.drools.pmml.pmml_4_2.test";

    @After
    public void tearDown() {
        this.getKSession().dispose();
    }

    @Test
    public void testRegression() throws Exception {
        this.setKSession(this.getModelSession(source1, true));
        this.setKbase(this.getKSession().getKieBase());
        KieSession kSession = this.getKSession();
        kSession.fireAllRules();
        FactType tgt = kSession.getKieBase().getFactType(packageName, "Fld4");
        kSession.getEntryPoint("in_Fld1").insert((Object)0.9);
        kSession.getEntryPoint("in_Fld2").insert((Object)0.3);
        kSession.getEntryPoint("in_Fld3").insert((Object)"x");
        kSession.fireAllRules();
        double x = 2.2579999999999996;
        x = 1.0 / (1.0 + Math.exp(-x));
        this.checkFirstDataFieldOfTypeStatus(tgt, true, false, "LinReg", x);
    }

    @Test
    public void testClassification() throws Exception {
        this.setKSession(this.getModelSession(source2, true));
        this.setKbase(this.getKSession().getKieBase());
        KieSession kSession = this.getKSession();
        kSession.fireAllRules();
        FactType tgt = kSession.getKieBase().getFactType(packageName, "Fld4");
        kSession.getEntryPoint("in_Fld1").insert((Object)1.0);
        kSession.getEntryPoint("in_Fld2").insert((Object)1.0);
        kSession.getEntryPoint("in_Fld3").insert((Object)"x");
        kSession.fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(kSession.getKieBase().getFactType(packageName, "RegOut"), true, false, "LinReg", "catC");
        this.checkFirstDataFieldOfTypeStatus(kSession.getKieBase().getFactType(packageName, "RegProb"), true, false, "LinReg", 0.709228);
        this.checkFirstDataFieldOfTypeStatus(kSession.getKieBase().getFactType(packageName, "RegProbA"), true, false, "LinReg", 0.010635);
    }
}

