/*
 * Decompiled with CFR 0.152.
 */
package org.drools.pmml.pmml_4_2.transformations;

import org.drools.pmml.pmml_4_2.DroolsAbstractPMMLTest;
import org.drools.pmml.pmml_4_2.PMML4Helper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FunctionsTest
extends DroolsAbstractPMMLTest {
    private static final boolean VERBOSE = false;
    private static final String source = "org/drools/pmml/pmml_4_2/test_functions.xml";
    private static final String packageName = "org.drools.pmml.pmml_4_2.test";

    @Before
    public void setUp() throws Exception {
        this.setKSession(this.getModelSession(source, false));
        this.setKbase(this.getKSession().getKieBase());
    }

    @After
    public void tearDown() {
        this.getKSession().dispose();
    }

    @Test
    public void testFunctions() throws Exception {
        this.getKSession().getEntryPoint("in_Age").insert((Object)30);
        this.getKSession().getEntryPoint("in_Age2").insert((Object)2);
        this.getKSession().fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "MappedAge"), true, false, null, 30);
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "NestedAge"), true, false, null, 932.0);
    }

    @Test
    public void testFunctionMapping() {
        PMML4Helper ctx = new PMML4Helper();
        Assert.assertEquals((Object)"(2 + 3 + 4)", (Object)ctx.mapFunction("+", new String[]{"2", "3", "4"}));
        Assert.assertEquals((Object)"(2 - 3)", (Object)ctx.mapFunction("-", new String[]{"2", "3"}));
        Assert.assertEquals((Object)"(2 * 3 * 4)", (Object)ctx.mapFunction("*", new String[]{"2", "3", "4"}));
        Assert.assertEquals((Object)"(2 / 4)", (Object)ctx.mapFunction("/", new String[]{"2", "4"}));
        Assert.assertEquals((Object)"(Math.min(2,Math.min(3,4)))", (Object)ctx.mapFunction("min", new String[]{"2", "3", "4"}));
        Assert.assertEquals((Object)"(Math.max(2,Math.max(3,4)))", (Object)ctx.mapFunction("max", new String[]{"2", "3", "4"}));
        Assert.assertEquals((Object)"(2 + 3 + 4)", (Object)ctx.mapFunction("sum", new String[]{"2", "3", "4"}));
        Assert.assertEquals((Object)"(2 * 3 * 4)", (Object)ctx.mapFunction("product", new String[]{"2", "3", "4"}));
        Assert.assertEquals((Object)"((2 + 3 + 4) / 3)", (Object)ctx.mapFunction("avg", new String[]{"2", "3", "4"}));
        Assert.assertEquals((Object)"(3)", (Object)ctx.mapFunction("median", new String[]{"1", "2", "3", "4", "5"}));
        Assert.assertEquals((Object)"( 0.5 * 3 + 0.5 * 4 )", (Object)ctx.mapFunction("median", new String[]{"1", "2", "3", "4", "5", "6"}));
        Assert.assertEquals((Object)"(Math.log10(2))", (Object)ctx.mapFunction("log10", new String[]{"2"}));
        Assert.assertEquals((Object)"(Math.log(2))", (Object)ctx.mapFunction("ln", new String[]{"2"}));
        Assert.assertEquals((Object)"(Math.sqrt(2))", (Object)ctx.mapFunction("sqrt", new String[]{"2"}));
        Assert.assertEquals((Object)"(Math.abs(2))", (Object)ctx.mapFunction("abs", new String[]{"2"}));
        Assert.assertEquals((Object)"(Math.exp(2))", (Object)ctx.mapFunction("exp", new String[]{"2"}));
        Assert.assertEquals((Object)"(Math.pow(2,3))", (Object)ctx.mapFunction("pow", new String[]{"2", "3"}));
        Assert.assertEquals((Object)"(1)", (Object)ctx.mapFunction("pow", new String[]{"0", "0"}));
        Assert.assertEquals((Object)"(2 > 3 ? 1 : 0)", (Object)ctx.mapFunction("threshold", new String[]{"2", "3"}));
        Assert.assertEquals((Object)"(Math.floor(2))", (Object)ctx.mapFunction("floor", new String[]{"2"}));
        Assert.assertEquals((Object)"(Math.ceil(2))", (Object)ctx.mapFunction("ceil", new String[]{"2"}));
        Assert.assertEquals((Object)"(Math.round(2))", (Object)ctx.mapFunction("round", new String[]{"2"}));
        Assert.assertEquals((Object)"(\"abc\".toString().toUpperCase())", (Object)ctx.mapFunction("uppercase", new String[]{"\"abc\""}));
        Assert.assertEquals((Object)"(\"testString\".toString().substring(2,6))", (Object)ctx.mapFunction("substring", new String[]{"\"testString\"", "3", "4"}));
        Assert.assertEquals((Object)"(new java.util.Formatter(new StringBuilder(),java.util.Locale.getDefault()).format(\"%3d\",3.0))", (Object)ctx.mapFunction("formatNumber", new String[]{"\"%3d\"", "3.0"}));
        Assert.assertEquals((Object)"(new java.text.SimpleDateFormat(\"format\").format(new SimpleDateFormat().parse(\"date\", java.util.Locale.ENGLISH)))", (Object)ctx.mapFunction("formatDatetime", new String[]{"\"date\"", "\"format\""}));
        Assert.assertEquals((Object)"(( (new java.text.SimpleDateFormat()).parse(\"date\").getTime() - (new java.text.SimpleDateFormat()).parse(\"01/01/1956\").getTime() ) / (1000*60*60*24))", (Object)ctx.mapFunction("dateDaysSinceYear", new String[]{"\"date\"", "1956"}));
        Assert.assertEquals((Object)"(( (new java.text.SimpleDateFormat()).parse(\"date\").getTime() - (new java.text.SimpleDateFormat()).parse(\"01/01/1956\").getTime() ) / 1000)", (Object)ctx.mapFunction("dateSecondsSinceYear", new String[]{"\"date\"", "1956"}));
        Assert.assertEquals((Object)"((new java.text.SimpleDateFormat()).parse(\"date\").getTime() % 1000)", (Object)ctx.mapFunction("dateSecondsSinceMidnight", new String[]{"\"date\""}));
        Assert.assertEquals((Object)"(a == b)", (Object)ctx.mapFunction("equal", new String[]{"a", "b"}));
        Assert.assertEquals((Object)"(a != b)", (Object)ctx.mapFunction("notEqual", new String[]{"a", "b"}));
        Assert.assertEquals((Object)"(a < b)", (Object)ctx.mapFunction("lessThan", new String[]{"a", "b"}));
        Assert.assertEquals((Object)"(a <= b)", (Object)ctx.mapFunction("lessOrEqual", new String[]{"a", "b"}));
        Assert.assertEquals((Object)"(a > b)", (Object)ctx.mapFunction("greaterThan", new String[]{"a", "b"}));
        Assert.assertEquals((Object)"(a >= b)", (Object)ctx.mapFunction("greaterOrEqual", new String[]{"a", "b"}));
        Assert.assertEquals((Object)"(a.contains(b))", (Object)ctx.mapFunction("isIn", new String[]{"a", "b"}));
        Assert.assertEquals((Object)"((! a.contains(b)))", (Object)ctx.mapFunction("isNotIn", new String[]{"a", "b"}));
        Assert.assertEquals((Object)"(( ! a ))", (Object)ctx.mapFunction("not", new String[]{"a"}));
        Assert.assertEquals((Object)"(a && b && c)", (Object)ctx.mapFunction("and", new String[]{"a", "b", "c"}));
        Assert.assertEquals((Object)"(a || b)", (Object)ctx.mapFunction("or", new String[]{"a", "b"}));
        Assert.assertEquals((Object)"(a ? b : c)", (Object)ctx.mapFunction("if", new String[]{"a", "b", "c"}));
        Assert.assertEquals((Object)"(a ? b : null)", (Object)ctx.mapFunction("if", new String[]{"a", "b"}));
    }
}

