/*
 * Decompiled with CFR 0.152.
 */
package org.drools.pmml.pmml_4_2;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.dmg.pmml.pmml_4_2.descr.ClusteringModel;
import org.dmg.pmml.pmml_4_2.descr.NaiveBayesModel;
import org.dmg.pmml.pmml_4_2.descr.NeuralNetwork;
import org.dmg.pmml.pmml_4_2.descr.PMML;
import org.dmg.pmml.pmml_4_2.descr.RegressionModel;
import org.dmg.pmml.pmml_4_2.descr.Scorecard;
import org.dmg.pmml.pmml_4_2.descr.SupportVectorMachineModel;
import org.dmg.pmml.pmml_4_2.descr.TreeModel;
import org.drools.compiler.compiler.PMMLCompiler;
import org.drools.core.io.impl.ByteArrayResource;
import org.drools.core.io.impl.ClassPathResource;
import org.drools.core.util.IoUtils;
import org.drools.pmml.pmml_4_2.PMML4Helper;
import org.drools.pmml.pmml_4_2.PMMLError;
import org.drools.pmml.pmml_4_2.PMMLWarning;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.io.ResourceFactory;
import org.mvel2.templates.SimpleTemplateRegistry;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRegistry;
import org.xml.sax.SAXException;

public class PMML4Compiler
implements PMMLCompiler {
    public static final String PMML_NAMESPACE = "org.dmg.pmml.pmml_4_2";
    public static final String PMML_DROOLS = "org.drools.pmml.pmml_4_2";
    public static final String PMML = "org.dmg.pmml.pmml_4_2.descr";
    public static final String SCHEMA_PATH = "xsd/org/dmg/pmml/pmml_4_2/pmml-4-2.xsd";
    public static final String BASE_PACK = "org.drools.pmml.pmml_4_2".replace('.', '/');
    protected static boolean globalLoaded = false;
    protected static final String[] GLOBAL_TEMPLATES = new String[]{"global/pmml_header.drlt", "global/pmml_import.drlt", "global/modelMark.drlt", "global/dataDefinition/common.drlt", "global/dataDefinition/rootDataField.drlt", "global/dataDefinition/inputBinding.drlt", "global/dataDefinition/outputBinding.drlt", "global/dataDefinition/ioTypeDeclare.drlt", "global/dataDefinition/updateIOField.drlt", "global/dataDefinition/inputFromEP.drlt", "global/dataDefinition/inputBean.drlt", "global/dataDefinition/outputBean.drlt", "global/manipulation/confirm.drlt", "global/manipulation/mapMissingValues.drlt", "global/manipulation/propagateMissingValues.drlt", "global/validation/intervalsOnDomainRestriction.drlt", "global/validation/valuesOnDomainRestriction.drlt", "global/validation/valuesOnDomainRestrictionMissing.drlt", "global/validation/valuesOnDomainRestrictionInvalid.drlt"};
    protected static boolean transformationLoaded = false;
    protected static final String[] TRANSFORMATION_TEMPLATES = new String[]{"transformations/normContinuous/boundedLowerOutliers.drlt", "transformations/normContinuous/boundedUpperOutliers.drlt", "transformations/normContinuous/normContOutliersAsMissing.drlt", "transformations/normContinuous/linearTractNormalization.drlt", "transformations/normContinuous/lowerExtrapolateLinearTractNormalization.drlt", "transformations/normContinuous/upperExtrapolateLinearTractNormalization.drlt", "transformations/aggregate/aggregate.drlt", "transformations/aggregate/collect.drlt", "transformations/simple/constantField.drlt", "transformations/simple/aliasedField.drlt", "transformations/normDiscrete/indicatorFieldYes.drlt", "transformations/normDiscrete/indicatorFieldNo.drlt", "transformations/normDiscrete/predicateField.drlt", "transformations/discretize/intervalBinning.drlt", "transformations/discretize/outOfBinningDefault.drlt", "transformations/discretize/outOfBinningMissing.drlt", "transformations/mapping/mapping.drlt", "transformations/functions/apply.drlt", "transformations/functions/function.drlt"};
    protected static boolean miningLoaded = false;
    protected static final String[] MINING_TEMPLATES = new String[]{"models/common/mining/miningField.drlt", "models/common/mining/miningFieldInvalid.drlt", "models/common/mining/miningFieldMissing.drlt", "models/common/mining/miningFieldOutlierAsMissing.drlt", "models/common/mining/miningFieldOutlierAsExtremeLow.drlt", "models/common/mining/miningFieldOutlierAsExtremeUpp.drlt", "models/common/target/targetReshape.drlt", "models/common/target/aliasedOutput.drlt", "models/common/target/addOutputFeature.drlt", "models/common/target/addRelOutputFeature.drlt", "models/common/target/outputQuery.drlt", "models/common/target/outputQueryPredicate.drlt"};
    protected static boolean neuralLoaded = false;
    protected static final String[] NEURAL_TEMPLATES = new String[]{"models/neural/neuralBeans.drlt", "models/neural/neuralWireInput.drlt", "models/neural/neuralBuildSynapses.drlt", "models/neural/neuralBuildNeurons.drlt", "models/neural/neuralLinkSynapses.drlt", "models/neural/neuralFire.drlt", "models/neural/neuralLayerMaxNormalization.drlt", "models/neural/neuralLayerSoftMaxNormalization.drlt", "models/neural/neuralOutputField.drlt", "models/neural/neuralClean.drlt"};
    protected static boolean svmLoaded = false;
    protected static final String[] SVM_TEMPLATES = new String[]{"models/svm/svmParams.drlt", "models/svm/svmDeclare.drlt", "models/svm/svmFunctions.drlt", "models/svm/svmBuild.drlt", "models/svm/svmInitSupportVector.drlt", "models/svm/svmInitInputVector.drlt", "models/svm/svmKernelEval.drlt", "models/svm/svmOutputGeneration.drlt", "models/svm/svmOutputVoteDeclare.drlt", "models/svm/svmOutputVote1vN.drlt", "models/svm/svmOutputVote1v1.drlt"};
    protected static boolean naiveBayesLoaded = false;
    protected static final String[] NAIVE_BAYES_TEMPLATES = new String[]{"models/bayes/naiveBayesDeclare.drlt", "models/bayes/naiveBayesEval.drlt", "models/bayes/naiveBayesBuildCounts.drlt", "models/bayes/naiveBayesBuildOuts.drlt"};
    protected static boolean simpleRegLoaded = false;
    protected static final String[] SIMPLEREG_TEMPLATES = new String[]{"models/regression/regDeclare.drlt", "models/regression/regCommon.drlt", "models/regression/regParams.drlt", "models/regression/regEval.drlt", "models/regression/regClaxOutput.drlt", "models/regression/regNormalization.drlt", "models/regression/regDecumulation.drlt"};
    protected static boolean clusteringLoaded = false;
    protected static final String[] CLUSTERING_TEMPLATES = new String[]{"models/clustering/clusteringDeclare.drlt", "models/clustering/clusteringInit.drlt", "models/clustering/clusteringEvalDistance.drlt", "models/clustering/clusteringEvalSimilarity.drlt", "models/clustering/clusteringMatrixCompare.drlt"};
    protected static boolean treeLoaded = false;
    protected static final String[] TREE_TEMPLATES = new String[]{"models/tree/treeDeclare.drlt", "models/tree/treeCommon.drlt", "models/tree/treeInputDeclare.drlt", "models/tree/treeInit.drlt", "models/tree/treeAggregateEval.drlt", "models/tree/treeDefaultEval.drlt", "models/tree/treeEval.drlt", "models/tree/treeIOBinding.drlt", "models/tree/treeMissHandleAggregate.drlt", "models/tree/treeMissHandleWeighted.drlt", "models/tree/treeMissHandleLast.drlt", "models/tree/treeMissHandleNull.drlt", "models/tree/treeMissHandleNone.drlt"};
    protected static boolean scorecardLoaded = false;
    protected static final String[] SCORECARD_TEMPLATES = new String[]{"models/scorecard/scorecardInit.drlt", "models/scorecard/scorecardParamsInit.drlt", "models/scorecard/scorecardDeclare.drlt", "models/scorecard/scorecardDataDeclare.drlt", "models/scorecard/scorecardPartialScore.drlt", "models/scorecard/scorecardScoring.drlt", "models/scorecard/scorecardOutputGeneration.drlt", "models/scorecard/scorecardOutputRankCode.drlt"};
    protected static final String RESOURCE_PATH = BASE_PACK;
    protected static final String TEMPLATE_PATH = "/" + RESOURCE_PATH + "/templates/";
    private static TemplateRegistry registry;
    private static List<KnowledgeBuilderResult> visitorBuildResults;
    private List<KnowledgeBuilderResult> results = new ArrayList<KnowledgeBuilderResult>();
    private Schema schema;
    private PMML4Helper helper = new PMML4Helper();

    public PMML4Compiler() {
        this.helper.setPack("org.drools.pmml.pmml_4_2.test");
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            this.schema = sf.newSchema(Thread.currentThread().getContextClassLoader().getResource(SCHEMA_PATH));
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public PMML4Helper getHelper() {
        return this.helper;
    }

    public String generateTheory(PMML pmml) {
        KieBase visitor;
        StringBuilder sb = new StringBuilder();
        try {
            visitor = PMML4Compiler.checkBuildingResources(pmml);
        }
        catch (IOException e) {
            this.results.add((KnowledgeBuilderResult)new PMMLError(e.getMessage()));
            return null;
        }
        KieSession visitorSession = visitor.newKieSession();
        this.helper.reset();
        visitorSession.setGlobal("registry", (Object)registry);
        visitorSession.setGlobal("fld2var", new HashMap());
        visitorSession.setGlobal("utils", (Object)this.helper);
        visitorSession.setGlobal("theory", (Object)sb);
        visitorSession.insert((Object)pmml);
        visitorSession.fireAllRules();
        String modelEvaluatingRules = sb.toString();
        visitorSession.dispose();
        return modelEvaluatingRules;
    }

    private static void initRegistry() {
        if (registry == null) {
            registry = new SimpleTemplateRegistry();
        }
        if (!globalLoaded) {
            for (String ntempl : GLOBAL_TEMPLATES) {
                PMML4Compiler.prepareTemplate(ntempl);
            }
            globalLoaded = true;
        }
        if (!transformationLoaded) {
            for (String ntempl : TRANSFORMATION_TEMPLATES) {
                PMML4Compiler.prepareTemplate(ntempl);
            }
            transformationLoaded = true;
        }
        if (!miningLoaded) {
            for (String ntempl : MINING_TEMPLATES) {
                PMML4Compiler.prepareTemplate(ntempl);
            }
            miningLoaded = true;
        }
    }

    private static KieBase checkBuildingResources(PMML pmml) throws IOException {
        KieServices ks = KieServices.Factory.get();
        KieContainer kieContainer = ks.getKieClasspathContainer();
        if (registry == null) {
            PMML4Compiler.initRegistry();
        }
        String chosenKieBase = null;
        for (Serializable o : pmml.getAssociationModelsAndBaselineModelsAndClusteringModels()) {
            if (o instanceof NaiveBayesModel) {
                if (!naiveBayesLoaded) {
                    for (String ntempl : NAIVE_BAYES_TEMPLATES) {
                        PMML4Compiler.prepareTemplate(ntempl);
                    }
                    naiveBayesLoaded = true;
                }
                String string = chosenKieBase = chosenKieBase == null ? "PMML-Bayes" : "PMML";
            }
            if (o instanceof NeuralNetwork) {
                if (!neuralLoaded) {
                    for (String ntempl : NEURAL_TEMPLATES) {
                        PMML4Compiler.prepareTemplate(ntempl);
                    }
                    neuralLoaded = true;
                }
                String string = chosenKieBase = chosenKieBase == null ? "PMML-Neural" : "PMML";
            }
            if (o instanceof ClusteringModel) {
                if (!clusteringLoaded) {
                    for (String ntempl : CLUSTERING_TEMPLATES) {
                        PMML4Compiler.prepareTemplate(ntempl);
                    }
                    clusteringLoaded = true;
                }
                String string = chosenKieBase = chosenKieBase == null ? "PMML-Cluster" : "PMML";
            }
            if (o instanceof SupportVectorMachineModel) {
                if (!svmLoaded) {
                    for (String ntempl : SVM_TEMPLATES) {
                        PMML4Compiler.prepareTemplate(ntempl);
                    }
                    svmLoaded = true;
                }
                String string = chosenKieBase = chosenKieBase == null ? "PMML-SVM" : "PMML";
            }
            if (o instanceof TreeModel) {
                if (!treeLoaded) {
                    for (String ntempl : TREE_TEMPLATES) {
                        PMML4Compiler.prepareTemplate(ntempl);
                    }
                    treeLoaded = true;
                }
                String string = chosenKieBase = chosenKieBase == null ? "PMML-Tree" : "PMML";
            }
            if (o instanceof RegressionModel) {
                if (!simpleRegLoaded) {
                    for (String ntempl : SIMPLEREG_TEMPLATES) {
                        PMML4Compiler.prepareTemplate(ntempl);
                    }
                    simpleRegLoaded = true;
                }
                String string = chosenKieBase = chosenKieBase == null ? "PMML-Regression" : "PMML";
            }
            if (!(o instanceof Scorecard)) continue;
            if (!scorecardLoaded) {
                for (String ntempl : SCORECARD_TEMPLATES) {
                    PMML4Compiler.prepareTemplate(ntempl);
                }
                scorecardLoaded = true;
            }
            chosenKieBase = chosenKieBase == null ? "PMML-Scorecard" : "PMML";
        }
        if (chosenKieBase == null) {
            chosenKieBase = "PMML-Base";
        }
        return kieContainer.getKieBase(chosenKieBase);
    }

    private static void prepareTemplate(String ntempl) {
        try {
            InputStream stream;
            String path = TEMPLATE_PATH + ntempl;
            Resource res = ResourceFactory.newClassPathResource((String)path, PMML4Compiler.class);
            if (res != null && (stream = res.getInputStream()) != null) {
                registry.addNamedTemplate(path.substring(path.lastIndexOf(47) + 1), TemplateCompiler.compileTemplate((InputStream)stream));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String compile(String resource, ClassLoader classLoader) {
        String theory = null;
        ClassPathResource cpr = new ClassPathResource(resource);
        try {
            theory = this.compile(cpr.getInputStream(), classLoader);
        }
        catch (IOException e) {
            this.results.add((KnowledgeBuilderResult)new PMMLError(e.toString()));
            e.printStackTrace();
        }
        return theory;
    }

    public Resource[] transform(Resource resource, ClassLoader classLoader) {
        String theory = null;
        try {
            theory = this.compile(resource.getInputStream(), classLoader);
        }
        catch (IOException e) {
            this.results.add((KnowledgeBuilderResult)new PMMLError(e.toString()));
            e.printStackTrace();
            return new Resource[0];
        }
        return new Resource[]{this.buildOutputResource(resource, theory)};
    }

    private Resource buildOutputResource(Resource resource, String theory) {
        ByteArrayResource byteArrayResource = new ByteArrayResource(theory.getBytes(IoUtils.UTF8_CHARSET));
        byteArrayResource.setResourceType(ResourceType.PMML);
        if (resource.getSourcePath() != null) {
            String originalPath = resource.getSourcePath();
            int start = originalPath.lastIndexOf(File.separator);
            byteArrayResource.setSourcePath("generated-sources/" + originalPath.substring(start) + ".pmml");
        } else {
            byteArrayResource.setSourcePath("generated-sources/" + this.helper.getContext() + ".pmml");
        }
        return byteArrayResource;
    }

    public String compile(InputStream source, ClassLoader classLoader) {
        this.results = new ArrayList<KnowledgeBuilderResult>();
        PMML pmml = this.loadModel(PMML, source);
        this.helper.setResolver(classLoader);
        if (this.getResults().isEmpty()) {
            return this.generateTheory(pmml);
        }
        return null;
    }

    public List<KnowledgeBuilderResult> getResults() {
        ArrayList<KnowledgeBuilderResult> combinedResults = new ArrayList<KnowledgeBuilderResult>(this.results);
        combinedResults.addAll(visitorBuildResults);
        return combinedResults;
    }

    public void clearResults() {
        this.results.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(String s, OutputStream ostream) {
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter(ostream, "UTF-8");
            writer.write(s);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (writer != null) {
                    ((Writer)writer).flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public PMML loadModel(String model, InputStream source) {
        try {
            if (this.schema == null) {
                visitorBuildResults.add((KnowledgeBuilderResult)new PMMLWarning(ResourceFactory.newInputStreamResource((InputStream)source), "Could not validate PMML document, schema not available"));
            }
            JAXBContext jc = JAXBContext.newInstance((String)model);
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            if (this.schema != null) {
                unmarshaller.setSchema(this.schema);
            }
            return (PMML)unmarshaller.unmarshal(source);
        }
        catch (JAXBException e) {
            this.results.add((KnowledgeBuilderResult)new PMMLError(e.toString()));
            return null;
        }
    }

    public static void dumpModel(PMML model, OutputStream target) {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)PMML.class.getPackage().getName());
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)model, target);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    static {
        visitorBuildResults = new ArrayList<KnowledgeBuilderResult>();
    }
}

