/*
 * Decompiled with CFR 0.152.
 */
package org.drools.pmml.pmml_4_2.predictive.models;

import java.io.Serializable;
import java.util.Collection;
import org.dmg.pmml.pmml_4_2.descr.MISSINGVALUESTRATEGY;
import org.dmg.pmml.pmml_4_2.descr.PMML;
import org.dmg.pmml.pmml_4_2.descr.TreeModel;
import org.drools.pmml.pmml_4_2.DroolsAbstractPMMLTest;
import org.drools.pmml.pmml_4_2.PMML4Compiler;
import org.drools.pmml.pmml_4_2.PMML4Helper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.ClassObjectFilter;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.internal.io.ResourceFactory;

public class DecisionTreeTest
extends DroolsAbstractPMMLTest {
    private static final boolean VERBOSE = false;
    private static final String source1 = "org/drools/pmml/pmml_4_2/test_tree_simple.xml";
    private static final String source2 = "org/drools/pmml/pmml_4_2/test_tree_missing.xml";
    private static final String packageName = "org.drools.pmml.pmml_4_2.test";

    @After
    public void tearDown() {
        this.getKSession().dispose();
    }

    @Test
    public void testSimpleTree() throws Exception {
        this.setKSession(this.getModelSession(source1, false));
        this.setKbase(this.getKSession().getKieBase());
        KieSession kSession = this.getKSession();
        kSession.fireAllRules();
        FactType tgt = kSession.getKieBase().getFactType(packageName, "Fld5");
        kSession.getEntryPoint("in_Fld1").insert((Object)30.0);
        kSession.getEntryPoint("in_Fld2").insert((Object)60.0);
        kSession.getEntryPoint("in_Fld3").insert((Object)"false");
        kSession.getEntryPoint("in_Fld4").insert((Object)"optA");
        kSession.fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(tgt, true, false, "Missing", "tgtY");
        this.checkGeneratedRules();
    }

    protected Object getToken(KieSession kSession) {
        FactType tok = kSession.getKieBase().getFactType(PMML4Helper.pmmlDefaultPackageName(), "TreeToken");
        Assert.assertNotNull((Object)tok);
        Collection c = kSession.getObjects((ObjectFilter)new ClassObjectFilter(tok.getFactClass()));
        Assert.assertEquals((long)1L, (long)c.size());
        return c.iterator().next();
    }

    @Test
    public void testMissingTree() throws Exception {
        this.setKSession(this.getModelSession(source2, false));
        this.setKbase(this.getKSession().getKieBase());
        KieSession kSession = this.getKSession();
        kSession.fireAllRules();
        FactType tgt = kSession.getKieBase().getFactType(packageName, "Fld9");
        FactType tok = kSession.getKieBase().getFactType(PMML4Helper.pmmlDefaultPackageName(), "TreeToken");
        kSession.getEntryPoint("in_Fld1").insert((Object)45.0);
        kSession.getEntryPoint("in_Fld2").insert((Object)60.0);
        kSession.getEntryPoint("in_Fld3").insert((Object)"optA");
        kSession.fireAllRules();
        Object token = this.getToken(kSession);
        Assert.assertEquals((Object)0.6, (Object)tok.get(token, "confidence"));
        Assert.assertEquals((Object)"null", (Object)tok.get(token, "current"));
        this.checkFirstDataFieldOfTypeStatus(tgt, true, false, "Missing", "tgtZ");
        this.checkGeneratedRules();
    }

    @Test
    public void testMissingTreeWeighted1() throws Exception {
        this.setKSession(this.getModelSession(source2, false));
        this.setKbase(this.getKSession().getKieBase());
        KieSession kSession = this.getKSession();
        kSession.fireAllRules();
        FactType tgt = kSession.getKieBase().getFactType(packageName, "Fld9");
        FactType tok = kSession.getKieBase().getFactType(PMML4Helper.pmmlDefaultPackageName(), "TreeToken");
        kSession.getEntryPoint("in_Fld1").insert((Object)-1.0);
        kSession.getEntryPoint("in_Fld2").insert((Object)-1.0);
        kSession.getEntryPoint("in_Fld3").insert((Object)"optA");
        kSession.fireAllRules();
        Object token = this.getToken(kSession);
        Assert.assertEquals((Object)0.8, (Object)tok.get(token, "confidence"));
        Assert.assertEquals((Object)"null", (Object)tok.get(token, "current"));
        Assert.assertEquals((Object)50.0, (Object)tok.get(token, "totalCount"));
        this.checkFirstDataFieldOfTypeStatus(tgt, true, false, "Missing", "tgtX");
        this.checkGeneratedRules();
    }

    @Test
    public void testMissingTreeWeighted2() throws Exception {
        this.setKSession(this.getModelSession(source2, false));
        this.setKbase(this.getKSession().getKieBase());
        KieSession kSession = this.getKSession();
        kSession.fireAllRules();
        FactType tgt = kSession.getKieBase().getFactType(packageName, "Fld9");
        FactType tok = kSession.getKieBase().getFactType(PMML4Helper.pmmlDefaultPackageName(), "TreeToken");
        kSession.getEntryPoint("in_Fld1").insert((Object)-1.0);
        kSession.getEntryPoint("in_Fld2").insert((Object)-1.0);
        kSession.getEntryPoint("in_Fld3").insert((Object)"miss");
        kSession.fireAllRules();
        Object token = this.getToken(kSession);
        Assert.assertEquals((Object)0.6, (Object)tok.get(token, "confidence"));
        Assert.assertEquals((Object)"null", (Object)tok.get(token, "current"));
        Assert.assertEquals((Object)100.0, (Object)tok.get(token, "totalCount"));
        this.checkFirstDataFieldOfTypeStatus(tgt, true, false, "Missing", "tgtX");
        this.checkGeneratedRules();
    }

    @Test
    public void testMissingTreeDefault() throws Exception {
        PMML4Compiler compiler = new PMML4Compiler();
        PMML pmml = compiler.loadModel("org.dmg.pmml.pmml_4_2.descr", ResourceFactory.newClassPathResource((String)source2).getInputStream());
        for (Serializable o : pmml.getAssociationModelsAndBaselineModelsAndClusteringModels()) {
            if (!(o instanceof TreeModel)) continue;
            TreeModel tree = (TreeModel)o;
            tree.setMissingValueStrategy(MISSINGVALUESTRATEGY.DEFAULT_CHILD);
        }
        KieSession kSession = this.getSession(compiler.generateTheory(pmml));
        this.setKSession(kSession);
        this.setKbase(this.getKSession().getKieBase());
        kSession.fireAllRules();
        FactType tgt = kSession.getKieBase().getFactType(packageName, "Fld9");
        FactType tok = kSession.getKieBase().getFactType(PMML4Helper.pmmlDefaultPackageName(), "TreeToken");
        kSession.getEntryPoint("in_Fld1").insert((Object)70.0);
        kSession.getEntryPoint("in_Fld2").insert((Object)40.0);
        kSession.getEntryPoint("in_Fld3").insert((Object)"miss");
        kSession.fireAllRules();
        Object token = this.getToken(kSession);
        Assert.assertEquals((double)0.72, (double)((Double)tok.get(token, "confidence")), (double)1.0E-6);
        Assert.assertEquals((Object)"null", (Object)tok.get(token, "current"));
        Assert.assertEquals((Object)40.0, (Object)tok.get(token, "totalCount"));
        this.checkFirstDataFieldOfTypeStatus(tgt, true, false, "Missing", "tgtX");
        this.checkGeneratedRules();
    }

    @Test
    public void testMissingTreeAllMissingDefault() throws Exception {
        PMML4Compiler compiler = new PMML4Compiler();
        PMML pmml = compiler.loadModel("org.dmg.pmml.pmml_4_2.descr", ResourceFactory.newClassPathResource((String)source2).getInputStream());
        for (Serializable o : pmml.getAssociationModelsAndBaselineModelsAndClusteringModels()) {
            if (!(o instanceof TreeModel)) continue;
            TreeModel tree = (TreeModel)o;
            tree.setMissingValueStrategy(MISSINGVALUESTRATEGY.DEFAULT_CHILD);
        }
        String theory = compiler.generateTheory(pmml);
        KieSession kSession = this.getSession(theory);
        this.setKSession(kSession);
        this.setKbase(this.getKSession().getKieBase());
        kSession.fireAllRules();
        FactType tgt = kSession.getKieBase().getFactType(packageName, "Fld9");
        FactType tok = kSession.getKieBase().getFactType(PMML4Helper.pmmlDefaultPackageName(), "TreeToken");
        kSession.getEntryPoint("in_Fld1").insert((Object)-1.0);
        kSession.getEntryPoint("in_Fld2").insert((Object)-1.0);
        kSession.getEntryPoint("in_Fld3").insert((Object)"miss");
        kSession.fireAllRules();
        Object token = this.getToken(kSession);
        Assert.assertEquals((double)1.0, (double)((Double)tok.get(token, "confidence")), (double)1.0E-6);
        Assert.assertEquals((Object)"null", (Object)tok.get(token, "current"));
        Assert.assertEquals((Object)0.0, (Object)tok.get(token, "totalCount"));
        this.checkGeneratedRules();
    }

    @Test
    public void testMissingTreeLastChoice() throws Exception {
        PMML4Compiler compiler = new PMML4Compiler();
        PMML pmml = compiler.loadModel("org.dmg.pmml.pmml_4_2.descr", ResourceFactory.newClassPathResource((String)source2).getInputStream());
        for (Serializable o : pmml.getAssociationModelsAndBaselineModelsAndClusteringModels()) {
            if (!(o instanceof TreeModel)) continue;
            TreeModel tree = (TreeModel)o;
            tree.setMissingValueStrategy(MISSINGVALUESTRATEGY.LAST_PREDICTION);
        }
        String theory = compiler.generateTheory(pmml);
        KieSession kSession = this.getSession(theory);
        this.setKSession(kSession);
        this.setKbase(this.getKSession().getKieBase());
        kSession.fireAllRules();
        FactType tgt = kSession.getKieBase().getFactType(packageName, "Fld9");
        FactType tok = kSession.getKieBase().getFactType(PMML4Helper.pmmlDefaultPackageName(), "TreeToken");
        kSession.getEntryPoint("in_Fld1").insert((Object)-1.0);
        kSession.getEntryPoint("in_Fld2").insert((Object)-1.0);
        kSession.getEntryPoint("in_Fld3").insert((Object)"optA");
        kSession.fireAllRules();
        Object token = this.getToken(kSession);
        Assert.assertEquals((double)0.8, (double)((Double)tok.get(token, "confidence")), (double)1.0E-6);
        Assert.assertEquals((Object)"null", (Object)tok.get(token, "current"));
        Assert.assertEquals((Object)50.0, (Object)tok.get(token, "totalCount"));
        this.checkFirstDataFieldOfTypeStatus(tgt, true, false, "Missing", "tgtX");
        this.checkGeneratedRules();
    }

    @Test
    public void testMissingTreeNull() throws Exception {
        PMML4Compiler compiler = new PMML4Compiler();
        PMML pmml = compiler.loadModel("org.dmg.pmml.pmml_4_2.descr", ResourceFactory.newClassPathResource((String)source2).getInputStream());
        for (Serializable o : pmml.getAssociationModelsAndBaselineModelsAndClusteringModels()) {
            if (!(o instanceof TreeModel)) continue;
            TreeModel tree = (TreeModel)o;
            tree.setMissingValueStrategy(MISSINGVALUESTRATEGY.NULL_PREDICTION);
        }
        String theory = compiler.generateTheory(pmml);
        KieSession kSession = this.getSession(theory);
        this.setKSession(kSession);
        this.setKbase(this.getKSession().getKieBase());
        kSession.fireAllRules();
        FactType tgt = kSession.getKieBase().getFactType(packageName, "Fld9");
        FactType tok = kSession.getKieBase().getFactType(PMML4Helper.pmmlDefaultPackageName(), "TreeToken");
        kSession.getEntryPoint("in_Fld1").insert((Object)-1.0);
        kSession.getEntryPoint("in_Fld2").insert((Object)-1.0);
        kSession.getEntryPoint("in_Fld3").insert((Object)"optA");
        kSession.fireAllRules();
        Object token = this.getToken(kSession);
        Assert.assertEquals((double)0.0, (double)((Double)tok.get(token, "confidence")), (double)1.0E-6);
        Assert.assertEquals((Object)"null", (Object)tok.get(token, "current"));
        Assert.assertEquals((Object)0.0, (Object)tok.get(token, "totalCount"));
        Assert.assertEquals((long)0L, (long)this.getKSession().getObjects((ObjectFilter)new ClassObjectFilter(tgt.getFactClass())).size());
        this.checkGeneratedRules();
    }

    @Test
    public void testMissingAggregate() throws Exception {
        PMML4Compiler compiler = new PMML4Compiler();
        PMML pmml = compiler.loadModel("org.dmg.pmml.pmml_4_2.descr", ResourceFactory.newClassPathResource((String)source2).getInputStream());
        for (Serializable o : pmml.getAssociationModelsAndBaselineModelsAndClusteringModels()) {
            if (!(o instanceof TreeModel)) continue;
            TreeModel tree = (TreeModel)o;
            tree.setMissingValueStrategy(MISSINGVALUESTRATEGY.AGGREGATE_NODES);
        }
        String theory = compiler.generateTheory(pmml);
        KieSession kSession = this.getSession(theory);
        this.setKSession(kSession);
        this.setKbase(this.getKSession().getKieBase());
        kSession.fireAllRules();
        FactType tgt = kSession.getKieBase().getFactType(packageName, "Fld9");
        FactType tok = kSession.getKieBase().getFactType(PMML4Helper.pmmlDefaultPackageName(), "TreeToken");
        kSession.getEntryPoint("in_Fld1").insert((Object)45.0);
        kSession.getEntryPoint("in_Fld2").insert((Object)90.0);
        kSession.getEntryPoint("in_Fld3").insert((Object)"miss");
        kSession.fireAllRules();
        Object token = this.getToken(kSession);
        Assert.assertEquals((double)0.47, (double)((Double)tok.get(token, "confidence")), (double)0.01);
        Assert.assertEquals((Object)"null", (Object)tok.get(token, "current"));
        Assert.assertEquals((Object)60.0, (Object)tok.get(token, "totalCount"));
        this.checkFirstDataFieldOfTypeStatus(tgt, true, false, "Missing", "tgtY");
        this.checkGeneratedRules();
    }

    @Test
    public void testMissingTreeNone() throws Exception {
        PMML4Compiler compiler = new PMML4Compiler();
        PMML pmml = compiler.loadModel("org.dmg.pmml.pmml_4_2.descr", ResourceFactory.newClassPathResource((String)source2).getInputStream());
        for (Serializable o : pmml.getAssociationModelsAndBaselineModelsAndClusteringModels()) {
            if (!(o instanceof TreeModel)) continue;
            TreeModel tree = (TreeModel)o;
            tree.setMissingValueStrategy(MISSINGVALUESTRATEGY.NONE);
        }
        String theory = compiler.generateTheory(pmml);
        KieSession kSession = this.getSession(theory);
        this.setKSession(kSession);
        this.setKbase(this.getKSession().getKieBase());
        kSession.fireAllRules();
        FactType tgt = kSession.getKieBase().getFactType(packageName, "Fld9");
        FactType tok = kSession.getKieBase().getFactType(PMML4Helper.pmmlDefaultPackageName(), "TreeToken");
        kSession.getEntryPoint("in_Fld1").insert((Object)-1.0);
        kSession.getEntryPoint("in_Fld2").insert((Object)-1.0);
        kSession.getEntryPoint("in_Fld3").insert((Object)"miss");
        kSession.fireAllRules();
        Object token = this.getToken(kSession);
        Assert.assertEquals((double)0.6, (double)((Double)tok.get(token, "confidence")), (double)1.0E-6);
        Assert.assertEquals((Object)"null", (Object)tok.get(token, "current"));
        Assert.assertEquals((Object)100.0, (Object)tok.get(token, "totalCount"));
        this.checkFirstDataFieldOfTypeStatus(tgt, true, false, "Missing", "tgtX");
        this.checkGeneratedRules();
    }

    @Test
    public void testSimpleTreeOutput() throws Exception {
        this.setKSession(this.getModelSession(source2, false));
        this.setKbase(this.getKSession().getKieBase());
        KieSession kSession = this.getKSession();
        kSession.fireAllRules();
        FactType tgt = kSession.getKieBase().getFactType(packageName, "Fld9");
        FactType tok = kSession.getKieBase().getFactType(PMML4Helper.pmmlDefaultPackageName(), "TreeToken");
        kSession.getEntryPoint("in_Fld1").insert((Object)-1.0);
        kSession.getEntryPoint("in_Fld2").insert((Object)-1.0);
        kSession.getEntryPoint("in_Fld3").insert((Object)"optA");
        kSession.fireAllRules();
        Object token = this.getToken(kSession);
        Assert.assertEquals((Object)0.8, (Object)tok.get(token, "confidence"));
        Assert.assertEquals((Object)"null", (Object)tok.get(token, "current"));
        Assert.assertEquals((Object)50.0, (Object)tok.get(token, "totalCount"));
        this.checkFirstDataFieldOfTypeStatus(tgt, true, false, "Missing", "tgtX");
        this.checkFirstDataFieldOfTypeStatus(kSession.getKieBase().getFactType(packageName, "OutClass"), true, false, "Missing", "tgtX");
        this.checkFirstDataFieldOfTypeStatus(kSession.getKieBase().getFactType(packageName, "OutProb"), true, false, "Missing", 0.8);
        this.checkGeneratedRules();
    }
}

